/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diet4j.core.Module;
import org.diet4j.core.ModuleActivationException;
import org.diet4j.core.ModuleActivator;
import org.diet4j.core.ModuleDeactivationException;
import org.diet4j.core.ModuleMeta;

public class DefaultModuleActivator
implements ModuleActivator {
    protected final Module theModule;
    public static final String ACTIVATION_METHOD_NAME = "moduleActivate";
    public static final String DEACTIVATION_METHOD_NAME = "moduleDeactivate";
    private static final Logger log = Logger.getLogger(DefaultModuleActivator.class.getName());

    public DefaultModuleActivator(Module mod) {
        this.theModule = mod;
    }

    @Override
    public Module getModule() {
        return this.theModule;
    }

    @Override
    public Object activate() throws ModuleActivationException {
        ModuleMeta meta = this.theModule.getModuleMeta();
        String activationClassName = meta.getActivationClassName();
        if (activationClassName == null) {
            return null;
        }
        try {
            log.log(Level.FINER, "moduleActivateStarted: {0}", this.theModule);
            Class<?> activationClass = Class.forName(activationClassName, true, this.theModule.getClassLoader());
            Method activationMethod = activationClass.getMethod(ACTIVATION_METHOD_NAME, Module.class);
            log.log(Level.FINER, "moduleActivate {0} ({1} {2})", new Object[]{this.theModule, activationClassName, activationMethod});
            Object ret = activationMethod.invoke(null, this.theModule);
            log.log(Level.FINER, "moduleActivateSucceeded: {0}", this.theModule);
            return ret;
        }
        catch (NoSuchMethodException ex) {
            log.log(Level.FINER, "moduleActivate no activation method: " + this.theModule, ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            log.log(Level.FINE, "moduleActivateFailed: " + this.theModule, ex.getTargetException());
            if (ex.getTargetException() instanceof ModuleActivationException) {
                throw (ModuleActivationException)ex.getTargetException();
            }
            throw new ModuleActivationException(meta, ex.getTargetException());
        }
        catch (Throwable ex) {
            log.log(Level.FINE, "moduleActivateFailed: " + this.theModule, ex);
            throw new ModuleActivationException(meta, ex);
        }
    }

    @Override
    public void deactivate() throws ModuleDeactivationException {
        ModuleMeta meta = this.theModule.getModuleMeta();
        String deactivationClassName = meta.getActivationClassName();
        if (deactivationClassName == null) {
            return;
        }
        try {
            log.log(Level.FINER, "moduleDeactivateStarted: {0}", this.theModule);
            Class<?> deactivationClass = Class.forName(deactivationClassName, true, this.theModule.getClassLoader());
            Method deactivationMethod = deactivationClass.getMethod(DEACTIVATION_METHOD_NAME, Module.class);
            log.log(Level.FINER, "moduleDeactivate: {0} ({1} {2})", new Object[]{this.theModule, deactivationClassName, deactivationMethod});
            deactivationMethod.invoke(null, this.theModule);
            log.log(Level.FINER, "moduleDeactivateSucceeded: {0}", this.theModule);
        }
        catch (NoSuchMethodException ex) {
            log.log(Level.FINER, "moduleDeactivate no deactivation method: " + this.theModule, ex);
        }
        catch (InvocationTargetException ex) {
            log.log(Level.FINE, "moduleDeactivateFailed: " + this.theModule, ex.getTargetException());
            if (ex.getTargetException() instanceof ModuleDeactivationException) {
                throw (ModuleDeactivationException)ex.getTargetException();
            }
            throw new ModuleDeactivationException(meta, ex.getTargetException());
        }
        catch (Throwable ex) {
            log.log(Level.FINE, "moduleDeactivateFailed: " + this.theModule, ex);
            throw new ModuleDeactivationException(this.theModule.getModuleMeta(), ex);
        }
    }

    @Override
    public ModuleActivator dependentModuleActivator(Module dependentModule) {
        return dependentModule.getDefaultModuleActivator();
    }
}

