/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diet4j.core.AbstractModuleRegistry;
import org.diet4j.core.DefaultModuleActivator;
import org.diet4j.core.ModuleActivationException;
import org.diet4j.core.ModuleActivator;
import org.diet4j.core.ModuleDeactivationException;
import org.diet4j.core.ModuleMeta;
import org.diet4j.core.ModuleNotFoundException;
import org.diet4j.core.ModuleRegistry;
import org.diet4j.core.ModuleResolutionException;
import org.diet4j.core.ModuleRunException;
import org.diet4j.core.NoRunMethodException;

public class Module {
    protected ModuleRegistry theRegistry;
    protected ModuleMeta theModuleMeta;
    protected ClassLoader theClassLoader = null;
    protected ClassLoader theParentClassLoader;
    private int theActivationCount = 0;
    private Object theContextObject;
    public static final String RUN_METHOD_NAME = "main";
    private static final Logger log = Logger.getLogger(Module.class.getName());

    public Module(ModuleMeta meta, AbstractModuleRegistry registry, ClassLoader parentClassLoader) {
        if (meta == null) {
            throw new NullPointerException("Null ModuleMeta");
        }
        if (registry == null) {
            throw new NullPointerException("Null Module Registry");
        }
        if (parentClassLoader == null) {
            throw new NullPointerException("Null parent ClassLoader");
        }
        this.theModuleMeta = meta;
        this.theRegistry = registry;
        this.theParentClassLoader = parentClassLoader;
    }

    public final String getModuleGroupId() {
        return this.theModuleMeta.getModuleGroupId();
    }

    public final String getModuleArtifactId() {
        return this.theModuleMeta.getModuleArtifactId();
    }

    public final String getModuleVersion() {
        return this.theModuleMeta.getModuleVersion();
    }

    public final ModuleMeta getModuleMeta() {
        return this.theModuleMeta;
    }

    public final ModuleRegistry getModuleRegistry() {
        return this.theRegistry;
    }

    public final Module[] determineRuntimeDependencies() {
        return this.theRegistry.determineRuntimeDependencies(this);
    }

    public final Module[] determineRuntimeUses() {
        return this.theRegistry.determineRuntimeUses(this);
    }

    public final synchronized ClassLoader getClassLoader() throws MalformedURLException {
        if (this.theClassLoader == null) {
            this.theClassLoader = this.theRegistry.createClassLoader(this, this.theParentClassLoader);
        }
        return this.theClassLoader;
    }

    public final boolean isActive() {
        return this.theActivationCount > 0;
    }

    public final void activateRecursively() throws ModuleResolutionException, ModuleNotFoundException, ModuleActivationException {
        this.activateRecursively(this.getDefaultModuleActivator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activateRecursively(ModuleActivator activator) throws ModuleResolutionException, ModuleNotFoundException, ModuleActivationException {
        if (this.theActivationCount == 0) {
            boolean success = false;
            try {
                log.log(Level.FINER, "moduleActivateRecursivelyStarted: {0}", this);
                Module[] dependencies = this.theRegistry.determineRuntimeDependencies(this);
                for (int i = 0; i < dependencies.length; ++i) {
                    if (dependencies[i] == null) continue;
                    ModuleActivator childActivator = activator.dependentModuleActivator(dependencies[i]);
                    try {
                        dependencies[i].activateRecursively(childActivator);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new ModuleActivationException(this.theModuleMeta, (Throwable)ex);
                    }
                }
                this.theContextObject = activator.activate();
                success = true;
            }
            finally {
                if (success) {
                    log.log(Level.FINER, "moduleActivateRecursivelySucceeded: {0}", this);
                } else {
                    log.log(Level.FINER, "moduleActivateRecursivelyFailed: {0}", this);
                }
            }
        }
        ++this.theActivationCount;
    }

    public final void deactivateRecursively() throws ModuleDeactivationException {
        this.deactivateRecursively(this.getDefaultModuleActivator());
    }

    public final void deactivateRecursively(ModuleActivator activator) throws ModuleDeactivationException {
        --this.theActivationCount;
        if (this.theActivationCount == 0) {
            Module[] dependencies = this.theRegistry.determineRuntimeDependencies(this);
            activator.deactivate();
            for (int i = 0; i < dependencies.length; ++i) {
                if (dependencies[i] == null) continue;
                ModuleActivator childDeactivator = activator.dependentModuleActivator(dependencies[i]);
                dependencies[i].deactivateRecursively(childDeactivator);
            }
        }
    }

    public final Object getContextObject() {
        return this.theContextObject;
    }

    public final void run(String[] arguments) throws ClassNotFoundException, ModuleRunException, NoRunMethodException, InvocationTargetException {
        this.run(null, null, arguments);
    }

    public int run(String overriddenRunClassName, String overriddenRunMethodName, String[] arguments) throws ClassNotFoundException, ModuleRunException, NoRunMethodException, InvocationTargetException {
        log.log(Level.FINER, "runStarted: {0} ({1} {2})", new Object[]{this, overriddenRunClassName, overriddenRunMethodName});
        String runClassName = overriddenRunClassName;
        String runMethodName = overriddenRunMethodName;
        try {
            if (runClassName == null) {
                runClassName = this.theModuleMeta.getRunClassName();
            }
            if (runMethodName == null) {
                runMethodName = RUN_METHOD_NAME;
            }
            if (runClassName == null) {
                throw new NoRunMethodException(this.theModuleMeta, runClassName, runMethodName, null);
            }
            Class<?> runClass = Class.forName(runClassName, true, this.getClassLoader());
            Method runMethod = runClass.getMethod(runMethodName, String[].class);
            log.log(Level.FINER, "run: {0} ({1} {2})", new Object[]{this, runClass, runMethod});
            Object ret = runMethod.invoke(null, new Object[]{arguments});
            log.log(Level.FINER, "runSucceeded: {0}", this);
            if (ret instanceof Number) {
                return ((Number)ret).intValue();
            }
            return 0;
        }
        catch (MalformedURLException ex) {
            log.log(Level.SEVERE, "run failed: " + this, ex);
            return 1;
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof ModuleRunException) {
                throw (ModuleRunException)ex.getTargetException();
            }
            throw new ModuleRunException(this.theModuleMeta, runClassName, runMethodName, ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new NoRunMethodException(this.theModuleMeta, runClassName, runMethodName, ex);
        }
    }

    public ModuleActivator getDefaultModuleActivator() {
        return new DefaultModuleActivator(this);
    }

    public boolean equals(Object other) {
        if (other instanceof Module) {
            return this.theModuleMeta.equals(((Module)other).theModuleMeta);
        }
        return false;
    }

    public int hashCode() {
        return this.theModuleMeta.hashCode();
    }

    public String toString() {
        return this.theModuleMeta.toString();
    }
}

