/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.io.Serializable;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.diet4j.core.ModuleMeta;

public class ModuleRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String theRequiredModuleGroupId;
    protected String theRequiredModuleArtifactId;
    protected String theUninterpretedRequiredModuleVersion;
    protected String theMinRequiredModuleVersion;
    protected boolean theMinRequiredModuleVersionIsInclusive;
    protected Object[][] theParsedMinRequiredModuleVersion;
    protected String theMaxRequiredModuleVersion;
    protected boolean theMaxRequiredModuleVersionIsInclusive;
    protected Object[][] theParsedMaxRequiredModuleVersion;
    protected boolean theIsOptional;
    public static Pattern MAVEN_VERSION_REGEX = Pattern.compile("([\\[\\(])([^,\\[\\]\\(\\)]*),([^,\\[\\]\\(\\)]*)(\\]\\))");

    public static ModuleRequirement create(String requiredModuleArtifactId) {
        return new ModuleRequirement(null, requiredModuleArtifactId, null, false);
    }

    public static ModuleRequirement create(String requiredModuleGroupId, String requiredModuleArtifactId) {
        return new ModuleRequirement(requiredModuleGroupId, requiredModuleArtifactId, null, false);
    }

    public static ModuleRequirement create(String requiredModuleGroupId, String requiredModuleArtifactId, String requiredModuleVersion) {
        return new ModuleRequirement(requiredModuleGroupId, requiredModuleArtifactId, requiredModuleVersion, false);
    }

    public static ModuleRequirement create(String requiredModuleGroupId, String requiredModuleArtifactId, String requiredModuleVersion, boolean isOptional) {
        return new ModuleRequirement(requiredModuleGroupId, requiredModuleArtifactId, requiredModuleVersion, isOptional);
    }

    public static ModuleRequirement parse(String s) throws ParseException {
        String[] parts = s.split(":");
        switch (parts.length) {
            case 1: {
                return new ModuleRequirement(null, parts[0], null, false);
            }
            case 2: {
                return new ModuleRequirement(parts[0].isEmpty() ? null : parts[0], parts[1], null, false);
            }
            case 3: {
                return new ModuleRequirement(parts[0].isEmpty() ? null : parts[0], parts[1], parts[2].isEmpty() ? null : parts[2], false);
            }
        }
        throw new ParseException("Not a valid Module identifier: " + s, 0);
    }

    protected ModuleRequirement(String requiredModuleGroupId, String requiredModuleArtifactId, String requiredModuleVersion, boolean isOptional) {
        if (requiredModuleGroupId != null && requiredModuleGroupId.isEmpty()) {
            throw new IllegalArgumentException("Required module groupId must not be an empty string");
        }
        if (requiredModuleArtifactId == null || requiredModuleArtifactId.isEmpty()) {
            throw new IllegalArgumentException("Required module artifactId must not be null or an empty string");
        }
        if (requiredModuleVersion != null && requiredModuleVersion.isEmpty()) {
            throw new IllegalArgumentException("Required module version must not be an empty string");
        }
        this.theRequiredModuleGroupId = requiredModuleGroupId;
        this.theRequiredModuleArtifactId = requiredModuleArtifactId;
        this.theIsOptional = isOptional;
        this.parseAndSetMinMaxVersions(requiredModuleVersion);
    }

    public final String getRequiredModuleGroupId() {
        return this.theRequiredModuleGroupId;
    }

    public final String getRequiredModuleArtifactId() {
        return this.theRequiredModuleArtifactId;
    }

    public final String getUninterpretedRequiredModuleVersion() {
        return this.theUninterpretedRequiredModuleVersion;
    }

    public final boolean isOptional() {
        return this.theIsOptional;
    }

    public boolean matches(ModuleMeta candidate) {
        if (this.theRequiredModuleGroupId != null && !this.theRequiredModuleGroupId.equals(candidate.getModuleGroupId())) {
            return false;
        }
        if (!this.theRequiredModuleArtifactId.equals(candidate.getModuleArtifactId())) {
            return false;
        }
        return this.matchesVersionRequirement(candidate.getModuleVersion());
    }

    public ModuleMeta[] findVersionMatchesFrom(ModuleMeta[] candidates) {
        ModuleMeta[] ret = new ModuleMeta[candidates.length];
        int count = 0;
        for (int i = 0; i < candidates.length; ++i) {
            if (!this.matches(candidates[i])) continue;
            ret[count++] = candidates[i];
        }
        if (count < ret.length) {
            ModuleMeta[] tmp = new ModuleMeta[count];
            System.arraycopy(ret, 0, tmp, 0, count);
            ret = tmp;
        }
        return ret;
    }

    public boolean matchesVersionRequirement(String version) {
        int comp;
        if (this.theMinRequiredModuleVersionIsInclusive && version != null && version.equals(this.theMaxRequiredModuleVersion)) {
            return true;
        }
        this.ensureVersionsParsed();
        Object[][] parsedVersion = this.parseVersion(version);
        if (this.theParsedMinRequiredModuleVersion != null) {
            comp = this.compareParsedVersions(this.theParsedMinRequiredModuleVersion, parsedVersion);
            if (comp > 0) {
                return false;
            }
            if (comp == 0 && !this.theMinRequiredModuleVersionIsInclusive) {
                return false;
            }
        }
        if (this.theParsedMaxRequiredModuleVersion != null) {
            comp = this.compareParsedVersions(this.theParsedMaxRequiredModuleVersion, parsedVersion);
            if (comp < 0) {
                return false;
            }
            if (comp == 0 && !this.theMaxRequiredModuleVersionIsInclusive) {
                return false;
            }
        }
        return true;
    }

    protected int compareParsedVersions(Object[][] a, Object[][] b) {
        int max = Math.min(a.length, b.length);
        for (int i = 0; i < max; ++i) {
            if (a[i] != null) {
                if (b[i] != null) {
                    int found = this.compareParsedVersionParts(a[i], b[i]);
                    if (found == 0) continue;
                    return found;
                }
                return 1;
            }
            if (b[i] == null) continue;
            return -1;
        }
        if (a.length > max) {
            return 1;
        }
        return -1;
    }

    protected int compareParsedVersionParts(Object[] a, Object[] b) {
        int max;
        for (max = Math.min(a.length, b.length); max > 0 && a[max - 1] == null && b[max - 1] == null; --max) {
        }
        if (max == 0) {
            return 0;
        }
        for (int i = 0; i < max; ++i) {
            if (a[i] != null) {
                if (b[i] != null) {
                    int found;
                    if (a[i] instanceof String) {
                        if (b[i] instanceof String) {
                            found = ((String)a[i]).compareTo((String)b[i]);
                            if (found == 0) continue;
                            return found;
                        }
                        return 1;
                    }
                    if (b[i] instanceof String) {
                        return -1;
                    }
                    found = ((Long)a[i]).compareTo((Long)b[i]);
                    if (found == 0) continue;
                    return found;
                }
                return 1;
            }
            if (b[i] != null) {
                return -1;
            }
            return 0;
        }
        if (a.length > max) {
            if (a[max] != null) {
                return 1;
            }
            return -1;
        }
        if (b[max] != null) {
            return -1;
        }
        return 0;
    }

    protected void parseAndSetMinMaxVersions(String s) {
        this.theUninterpretedRequiredModuleVersion = s;
        this.theParsedMinRequiredModuleVersion = null;
        this.theParsedMaxRequiredModuleVersion = null;
        if (s == null) {
            this.theMinRequiredModuleVersion = null;
            this.theMaxRequiredModuleVersion = null;
            this.theMinRequiredModuleVersionIsInclusive = true;
            this.theMaxRequiredModuleVersionIsInclusive = true;
        } else {
            Matcher m = MAVEN_VERSION_REGEX.matcher(s);
            if (m.matches()) {
                this.theMinRequiredModuleVersion = m.group(2);
                this.theMaxRequiredModuleVersion = m.group(3);
                this.theMinRequiredModuleVersionIsInclusive = "[".equals(m.group(1));
                this.theMaxRequiredModuleVersionIsInclusive = "]".equals(m.group(4));
            } else {
                this.theMinRequiredModuleVersion = s;
                this.theMaxRequiredModuleVersion = null;
                this.theMinRequiredModuleVersionIsInclusive = true;
                this.theMaxRequiredModuleVersionIsInclusive = true;
            }
        }
    }

    protected synchronized void ensureVersionsParsed() {
        if (this.theMinRequiredModuleVersion != null) {
            if (this.theParsedMinRequiredModuleVersion == null) {
                this.theParsedMinRequiredModuleVersion = this.parseVersion(this.theMinRequiredModuleVersion);
            }
        } else {
            this.theParsedMinRequiredModuleVersion = null;
        }
        if (this.theMaxRequiredModuleVersion != null) {
            if (this.theParsedMaxRequiredModuleVersion == null) {
                this.theParsedMaxRequiredModuleVersion = this.parseVersion(this.theMaxRequiredModuleVersion);
            }
        } else {
            this.theParsedMaxRequiredModuleVersion = null;
        }
    }

    protected Object[][] parseVersion(String v) {
        String[] major = v.split(".");
        Object[][] ret = new Object[major.length][];
        for (int i = 0; i < major.length; ++i) {
            ret[i] = new Object[major[i].length()];
            int count = 0;
            StringBuilder currentString = null;
            long currentLong = -1L;
            for (int j = 0; j < major[i].length(); ++j) {
                char c = major[i].charAt(j);
                if (Character.isDigit(c)) {
                    if (currentString != null) {
                        ret[i][count++] = currentString.toString();
                        currentString = null;
                        currentLong = Character.digit(c, 10);
                        continue;
                    }
                    if (currentLong == -1L) {
                        currentLong = Character.digit(c, 10);
                        continue;
                    }
                    currentLong = currentLong * 10L + (long)Character.digit(c, 10);
                    continue;
                }
                if (currentString != null) {
                    currentString.append(c);
                    continue;
                }
                currentString = new StringBuilder();
                currentString.append(c);
                ret[i][count++] = currentLong;
                currentLong = -1L;
            }
            if (currentString != null) {
                ret[i][count++] = currentString.toString();
                continue;
            }
            if (currentLong == -1L) continue;
            ret[i][count++] = currentLong;
        }
        return ret;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.theRequiredModuleGroupId != null) {
            buf.append(this.theRequiredModuleGroupId);
        }
        buf.append(":");
        buf.append(this.theRequiredModuleArtifactId);
        buf.append(":");
        if (this.theMinRequiredModuleVersion != null && this.theMinRequiredModuleVersionIsInclusive && this.theMaxRequiredModuleVersion == null) {
            buf.append(this.theMinRequiredModuleVersion);
        } else if (this.theMinRequiredModuleVersion != null || this.theMaxRequiredModuleVersion != null) {
            if (this.theMinRequiredModuleVersionIsInclusive) {
                buf.append("[");
            } else {
                buf.append("(");
            }
            if (this.theMinRequiredModuleVersion != null) {
                buf.append(this.theMinRequiredModuleVersion);
            }
            buf.append(",");
            if (this.theMaxRequiredModuleVersion != null) {
                buf.append(this.theMaxRequiredModuleVersion);
            }
            if (this.theMaxRequiredModuleVersionIsInclusive) {
                buf.append("]");
            } else {
                buf.append(")");
            }
        }
        return buf.toString();
    }
}

