/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.jsvc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.HashSet;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonInitException;
import org.diet4j.cmdline.CmdlineParameters;
import org.diet4j.core.Module;
import org.diet4j.core.ModuleActivationException;
import org.diet4j.core.ModuleDeactivationException;
import org.diet4j.core.ModuleMeta;
import org.diet4j.core.ModuleNotFoundException;
import org.diet4j.core.ModuleRegistry;
import org.diet4j.core.ModuleRequirement;
import org.diet4j.core.ModuleResolutionException;
import org.diet4j.core.ModuleRunException;
import org.diet4j.core.NoRunMethodException;
import org.diet4j.core.ScanningDirectoriesModuleRegistry;

public class Diet4jDaemon
implements Daemon {
    protected Module theRootModule;
    protected ModuleMeta theRootModuleMeta;
    protected ModuleRegistry theModuleRegistry;
    protected ModuleRequirement theRootModuleRequirement;
    protected String[] theRunArguments;
    protected File[] theModuleDirectories;
    protected String theRunClassName;
    protected String theRunMethodName;

    @Override
    public void init(DaemonContext dc) throws DaemonInitException {
        CmdlineParameters parameters = new CmdlineParameters(new CmdlineParameters.Parameter("directory", 1, true), new CmdlineParameters.Parameter("run", 1), new CmdlineParameters.Parameter("method", 1));
        String[] remaining = parameters.parse(dc.getArguments());
        if (remaining.length < 1) {
            throw new DaemonInitException("Must provide the name of one root module");
        }
        try {
            this.theRootModuleRequirement = ModuleRequirement.parse(remaining[0]);
        }
        catch (ParseException ex) {
            throw new DaemonInitException("Failed to parse root module requirement " + remaining[0], ex);
        }
        this.theRunArguments = new String[remaining.length - 1];
        System.arraycopy(remaining, 1, this.theRunArguments, 0, this.theRunArguments.length);
        String[] dirs = parameters.getMany("directory");
        HashSet<File> fileDirs = new HashSet<File>();
        if (dirs != null) {
            for (String dir : dirs) {
                try {
                    if (fileDirs.add(new File(dir).getCanonicalFile())) continue;
                    throw new DaemonInitException("Directory (indirectly?) specified more than once in moduledirectory parameter: " + dir);
                }
                catch (IOException ex) {
                    throw new DaemonInitException("Failed to read directory " + dir, ex);
                }
            }
        }
        this.theModuleDirectories = new File[fileDirs.size()];
        fileDirs.toArray(this.theModuleDirectories);
        this.theRunClassName = parameters.get("run");
        this.theRunMethodName = parameters.get("method");
        this.theModuleRegistry = ScanningDirectoriesModuleRegistry.create(this.theModuleDirectories);
        try {
            this.theRootModuleMeta = this.theModuleRegistry.determineSingleResolutionCandidate(this.theRootModuleRequirement);
        }
        catch (Throwable ex) {
            throw new DaemonInitException("Cannot find module " + this.theRootModuleRequirement);
        }
        try {
            this.theRootModule = this.theModuleRegistry.resolve(this.theRootModuleMeta);
        }
        catch (Throwable ex) {
            throw new DaemonInitException("Cannot resolve module " + this.theRootModuleMeta.toString());
        }
    }

    @Override
    public void start() throws ModuleResolutionException, ModuleNotFoundException, ModuleActivationException, ClassNotFoundException, ModuleRunException, NoRunMethodException, InvocationTargetException {
        if (this.theRootModule != null) {
            this.theRootModule.activateRecursively();
            if (this.theRunClassName != null) {
                this.theRootModule.run(this.theRunClassName, this.theRunMethodName, this.theRunArguments);
            }
        }
    }

    @Override
    public void stop() throws ModuleDeactivationException {
        if (this.theRootModule != null) {
            this.theRootModule.deactivateRecursively();
        }
    }

    @Override
    public void destroy() {
    }
}

