/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.digidoc4j.ddoc.Base64Util;
import org.digidoc4j.ddoc.CertID;
import org.digidoc4j.ddoc.CertValue;
import org.digidoc4j.ddoc.CompleteCertificateRefs;
import org.digidoc4j.ddoc.CompleteRevocationRefs;
import org.digidoc4j.ddoc.DataFile;
import org.digidoc4j.ddoc.DataFileAttribute;
import org.digidoc4j.ddoc.DataObjectFormat;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.Identifier;
import org.digidoc4j.ddoc.IncludeInfo;
import org.digidoc4j.ddoc.KeyInfo;
import org.digidoc4j.ddoc.Notary;
import org.digidoc4j.ddoc.ObjectIdentifier;
import org.digidoc4j.ddoc.OcspRef;
import org.digidoc4j.ddoc.Reference;
import org.digidoc4j.ddoc.SigPolicyQualifier;
import org.digidoc4j.ddoc.Signature;
import org.digidoc4j.ddoc.SignaturePolicyId;
import org.digidoc4j.ddoc.SignaturePolicyIdentifier;
import org.digidoc4j.ddoc.SignatureProductionPlace;
import org.digidoc4j.ddoc.SignatureValue;
import org.digidoc4j.ddoc.SignedDataObjectProperties;
import org.digidoc4j.ddoc.SignedDoc;
import org.digidoc4j.ddoc.SignedInfo;
import org.digidoc4j.ddoc.SignedProperties;
import org.digidoc4j.ddoc.SpUri;
import org.digidoc4j.ddoc.TimestampInfo;
import org.digidoc4j.ddoc.UnsignedProperties;
import org.digidoc4j.ddoc.XmlElemInfo;
import org.digidoc4j.ddoc.factory.CanonicalizationFactory;
import org.digidoc4j.ddoc.factory.DigiDocFactory;
import org.digidoc4j.ddoc.factory.DigiDocStructureValidator;
import org.digidoc4j.ddoc.factory.DigiDocVerifyFactory;
import org.digidoc4j.ddoc.factory.NotaryFactory;
import org.digidoc4j.ddoc.factory.SAXDigiDocException;
import org.digidoc4j.ddoc.factory.SignatureInputStream;
import org.digidoc4j.ddoc.utils.ConfigManager;
import org.digidoc4j.ddoc.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDigiDocFactory
extends DefaultHandler
implements DigiDocFactory {
    private Stack m_tags;
    private SignedDoc m_doc = null;
    private Signature m_sig = null;
    private String m_strSigValTs;
    private String m_strSigAndRefsTs;
    private StringBuffer m_sbCollectChars;
    private StringBuffer m_sbCollectItem = null;
    private StringBuffer m_sbCollectSignature = null;
    private boolean m_bCollectDigest = false;
    private String m_xmlnsAttr = null;
    private int m_nCollectMode;
    private long nMaxBdocFilCached;
    private Logger m_logger = LoggerFactory.getLogger(SAXDigiDocFactory.class);
    private MessageDigest m_digest = null;
    private MessageDigest m_altDigest = null;
    private FileOutputStream m_dfCacheOutStream = null;
    private String m_tempDir = null;
    private String m_fileName;
    private String m_sigComment;
    private String m_nsDsPref;
    private String m_nsXadesPref;
    private String m_nsAsicPref = null;
    private List m_errs = null;
    private XmlElemInfo m_elemRoot = null;
    private XmlElemInfo m_elemCurrent = null;
    private static final String xmlnsEtsi = "http://uri.etsi.org/01903/v1.3.2#";
    private static final String xmlnsDs = "http://www.w3.org/2000/09/xmldsig#";
    private static final String xmlnsAsic = "http://uri.etsi.org/02918/v1.2.1#";

    public SAXDigiDocFactory() {
        this.m_tags = new Stack();
        this.nMaxBdocFilCached = ConfigManager.instance().getLongProperty("DIGIDOC_MAX_DATAFILE_CACHED", Long.MAX_VALUE);
    }

    private void updateDigest(byte[] data) {
        try {
            if (this.m_digest == null) {
                this.m_digest = MessageDigest.getInstance("SHA-1");
            }
            this.m_digest.update(data);
        }
        catch (Exception ex) {
            this.m_logger.error("Error calculating digest: " + ex);
        }
    }

    private void updateAltDigest(byte[] data) {
        try {
            if (this.m_altDigest == null) {
                this.m_altDigest = MessageDigest.getInstance("SHA-1");
            }
            this.m_altDigest.update(data);
        }
        catch (Exception ex) {
            this.m_logger.error("Error calculating digest: " + ex);
        }
    }

    @Override
    public void setTempDir(String s) {
        this.m_tempDir = s;
    }

    private byte[] getDigest() {
        byte[] digest = null;
        try {
            digest = this.m_digest.digest();
            this.m_digest = null;
        }
        catch (Exception ex) {
            this.m_logger.error("Error calculating digest: " + ex);
        }
        return digest;
    }

    private byte[] getAltDigest() {
        byte[] digest = null;
        try {
            digest = this.m_altDigest.digest();
            this.m_altDigest = null;
        }
        catch (Exception ex) {
            this.m_logger.error("Error calculating digest: " + ex);
        }
        return digest;
    }

    @Override
    public void init() throws DigiDocException {
    }

    private void handleError(Exception err) throws DigiDocException {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Handle err: " + err + " list: " + (this.m_errs != null));
        }
        err.printStackTrace();
        DigiDocException err1 = null;
        if (err instanceof SAXDigiDocException) {
            err1 = ((SAXDigiDocException)err).getDigiDocException();
        } else if (err instanceof DigiDocException) {
            err1 = (DigiDocException)err;
            err1.printStackTrace();
            if (err1.getNestedException() != null) {
                err1.getNestedException().printStackTrace();
            }
        } else {
            err1 = new DigiDocException(75, "Invalid xml file!", err);
        }
        if (this.m_errs == null) {
            throw err1;
        }
        this.m_errs.add(err1);
    }

    private void handleSAXError(Exception err) throws SAXDigiDocException {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Handle sa err: " + err + " list: " + (this.m_errs != null));
            this.m_logger.debug("Trace: " + ConvertUtils.getTrace(err));
        }
        DigiDocException err1 = null;
        SAXDigiDocException err2 = null;
        if (err instanceof SAXDigiDocException) {
            err1 = ((SAXDigiDocException)err).getDigiDocException();
            err2 = (SAXDigiDocException)err;
        } else if (err instanceof DigiDocException) {
            err1 = (DigiDocException)err;
            err2 = new SAXDigiDocException(err.getMessage());
            err2.setNestedException(err);
        } else {
            err1 = new DigiDocException(0, err.getMessage(), null);
            err2 = new SAXDigiDocException(err.getMessage());
            err2.setNestedException(err);
        }
        if (this.m_errs == null) {
            throw err2;
        }
        this.m_errs.add(err1);
    }

    private SignedDoc readSignedDocOfType(String fname, InputStream isSdoc, List errs) throws DigiDocException {
        boolean bErrList;
        File inFile;
        SAXDigiDocFactory handler = this;
        this.m_errs = errs;
        DigiDocVerifyFactory.initProvider();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Start reading ddoc " + (fname != null ? "from file: " + fname : "from stream"));
        }
        if (fname == null && isSdoc == null) {
            throw new DigiDocException(10, "No input file", null);
        }
        if (!(fname == null || (inFile = new File(fname)).canRead() && inFile.length() != 0L)) {
            throw new DigiDocException(10, "Empty or unreadable input file", null);
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Reading ddoc: " + fname + " file: " + this.m_fileName);
            }
            this.m_fileName = fname;
            SAXParser saxParser = factory.newSAXParser();
            if (fname != null) {
                saxParser.parse((InputStream)new SignatureInputStream(new FileInputStream(fname)), (DefaultHandler)this);
            } else if (isSdoc != null) {
                saxParser.parse((InputStream)new SignatureInputStream(isSdoc), (DefaultHandler)this);
            }
        }
        catch (SAXParseException ex) {
            this.m_logger.error("SAX Error: " + ex);
            this.handleError(ex);
        }
        catch (Exception ex) {
            this.m_logger.error("Error reading3: " + ex);
            ex.printStackTrace();
            this.handleError(ex);
        }
        boolean bl = bErrList = errs != null;
        if (errs == null) {
            errs = new ArrayList();
        }
        if (this.m_doc == null) {
            this.m_logger.error("Error reading4: doc == null");
            this.handleError(new DigiDocException(12, "This document is not in ddoc format", null));
        }
        if (!bErrList && errs.size() > 0) {
            DigiDocException ex = (DigiDocException)errs.get(0);
            throw ex;
        }
        return this.m_doc;
    }

    @Override
    public SignedDoc readSignedDoc(String fname) throws DigiDocException {
        return this.readSignedDocOfType(fname, null, null);
    }

    @Override
    public SignedDoc readSignedDocFromStream(InputStream is) throws DigiDocException {
        return this.readSignedDocOfType(null, is, null);
    }

    @Override
    public SignedDoc readSignedDoc(String fname, List lerr) throws DigiDocException {
        return this.readSignedDocOfType(fname, null, lerr);
    }

    @Override
    public SignedDoc readSignedDocFromStream(InputStream is, List lerr) throws DigiDocException {
        return this.readSignedDocOfType(null, is, lerr);
    }

    @Override
    public Signature readSignature(InputStream digiSigStream) throws DigiDocException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(digiSigStream, (DefaultHandler)this);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_sig == null) {
            throw new DigiDocException(13, "This document is not in signature format", null);
        }
        return this.m_sig;
    }

    private String canonicalizeXml(String xml) {
        try {
            CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
            byte[] tmp = canFac.canonicalize(xml.getBytes("UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            return new String(tmp, "UTF-8");
        }
        catch (Exception ex) {
            this.m_logger.error("Canonicalizing exception: " + ex);
            return null;
        }
    }

    public Signature getLastSignature() {
        if (this.m_doc != null) {
            return this.m_doc.getLastSignature();
        }
        return this.m_sig;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_nCollectMode = 0;
        this.m_xmlnsAttr = null;
        this.m_dfCacheOutStream = null;
        this.m_nsDsPref = null;
        this.m_nsXadesPref = null;
        this.m_nsAsicPref = null;
    }

    private void findCertIDandCertValueTypes(Signature sig) {
        int i;
        if (this.m_logger.isDebugEnabled() && sig != null) {
            this.m_logger.debug("Sig: " + sig.getId() + " certids: " + sig.countCertIDs());
        }
        for (i = 0; sig != null && i < sig.countCertIDs(); ++i) {
            CertValue cval;
            CertID cid = sig.getCertID(i);
            if (cid == null || cid.getType() != 0) continue;
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("CertId: " + cid.getId() + " type: " + cid.getType() + " nr: " + cid.getSerial());
            }
            if ((cval = sig.findCertValueWithSerial(cid.getSerial())) == null) continue;
            String cn = null;
            try {
                cn = SignedDoc.getCommonName(cval.getCert().getSubjectDN().getName());
                if (this.m_logger.isDebugEnabled() && cid != null) {
                    this.m_logger.debug("CertId type: " + cid.getType() + " nr: " + cid.getSerial() + " cval: " + cval.getId() + " CN: " + cn);
                }
                if (ConvertUtils.isKnownOCSPCert(cn)) {
                    if (this.m_logger.isInfoEnabled()) {
                        this.m_logger.debug("Cert: " + cn + " is OCSP responders cert");
                    }
                    cid.setType(2);
                    cval.setType(2);
                }
                if (!ConvertUtils.isKnownTSACert(cn)) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Cert: " + cn + " is TSA cert");
                }
                cid.setType(3);
                cval.setType(3);
                if (!this.m_logger.isDebugEnabled()) continue;
                this.m_logger.debug("CertId: " + cid.getId() + " type: " + cid.getType() + " nr: " + cid.getSerial());
                continue;
            }
            catch (DigiDocException ex) {
                this.m_logger.error("Error setting type on certid or certval: " + cn);
            }
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Sig: " + sig.getId() + " certvals: " + sig.countCertValues());
        }
        for (i = 0; sig != null && i < sig.countCertValues(); ++i) {
            CertValue cval = sig.getCertValue(i);
            if (this.m_logger.isDebugEnabled() && cval != null) {
                this.m_logger.debug("CertValue: " + cval.getId() + " type: " + cval.getType());
            }
            if (cval.getType() != 0) continue;
            String cn = null;
            try {
                cn = SignedDoc.getCommonName(cval.getCert().getSubjectDN().getName());
                if (ConvertUtils.isKnownOCSPCert(cn)) {
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("Cert: " + cn + " is OCSP responders cert");
                    }
                    cval.setType(2);
                }
                if (!ConvertUtils.isKnownTSACert(cn)) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Cert: " + cn + " is TSA cert");
                }
                cval.setType(3);
                continue;
            }
            catch (DigiDocException ex) {
                this.m_logger.error("Error setting type on certid or certval: " + cn);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private String findNsPrefForUri(Attributes attrs, String uri) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            String val = attrs.getValue(i);
            if (!val.equals(uri)) continue;
            int p = key.indexOf(58);
            if (p > 0) {
                return key.substring(p + 1);
            }
            return null;
        }
        return null;
    }

    private String findAttrValueByName(Attributes attrs, String aName) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            if (!key.equalsIgnoreCase(aName)) continue;
            return attrs.getValue(i);
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXDigiDocException {
        Serializable spi;
        OcspRef orf;
        CompleteRevocationRefs rrefs;
        SignedProperties sp;
        Reference ref;
        Signature sig;
        String Id;
        Signature sig2;
        DigiDocException exv;
        String tag;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Start Element: " + qName + " lname: " + lName + " uri: " + namespaceURI);
        }
        if ((tag = qName).indexOf(58) != -1) {
            tag = qName.substring(qName.indexOf(58) + 1);
            if (this.m_nsDsPref == null) {
                this.m_nsDsPref = this.findNsPrefForUri(attrs, xmlnsDs);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Element: " + qName + " xmldsig pref: " + (this.m_nsDsPref != null ? this.m_nsDsPref : "NULL"));
                }
            }
            if (this.m_nsXadesPref == null) {
                this.m_nsXadesPref = this.findNsPrefForUri(attrs, xmlnsEtsi);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Element: " + qName + " xades pref: " + (this.m_nsXadesPref != null ? this.m_nsXadesPref : "NULL"));
                }
            }
            if (this.m_nsAsicPref == null) {
                this.m_nsAsicPref = this.findNsPrefForUri(attrs, xmlnsAsic);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Element: " + qName + " asic pref: " + (this.m_nsAsicPref != null ? this.m_nsAsicPref : "NULL"));
                }
            }
        }
        XmlElemInfo e = new XmlElemInfo(tag, this.findAttrValueByName(attrs, "id"), tag.equals("XAdESSignatures") || tag.equals("SignedDoc") ? null : this.m_elemCurrent);
        if (this.m_elemCurrent != null && !tag.equals("XAdESSignatures") && !tag.equals("SignedDoc")) {
            this.m_elemCurrent.addChild(e);
        }
        this.m_elemCurrent = e;
        if (this.m_elemRoot == null || tag.equals("XAdESSignatures") || tag.equals("SignedDoc")) {
            this.m_elemRoot = e;
        }
        if ((exv = DigiDocStructureValidator.validateElementPath(this.m_elemCurrent)) != null) {
            this.handleSAXError(exv);
        }
        this.m_tags.push(tag);
        if (tag.equals("SigningTime") || tag.equals("IssuerSerial") || tag.equals("X509SerialNumber") || tag.equals("X509IssuerName") || tag.equals("ClaimedRole") || tag.equals("City") || tag.equals("StateOrProvince") || tag.equals("CountryName") || tag.equals("PostalCode") || tag.equals("SignatureValue") || tag.equals("DigestValue") || tag.equals("IssuerSerial") || tag.equals("ResponderID") || tag.equals("X509SerialNumber") || tag.equals("ProducedAt") || tag.equals("EncapsulatedTimeStamp") || tag.equals("Identifier") || tag.equals("SPURI") || tag.equals("NonceAlgorithm") || tag.equals("MimeType") || tag.equals("EncapsulatedOCSPValue")) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Start collecting tag: " + tag);
            }
            this.m_sbCollectItem = new StringBuffer();
        }
        if (tag.equals("X509Certificate")) {
            sig2 = this.getLastSignature();
            CertValue cval = null;
            try {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Adding signers cert to: " + sig2.getId());
                }
                cval = sig2.getOrCreateCertValueOfType(1);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            this.m_sbCollectItem = new StringBuffer();
        }
        if (tag.equals("EncapsulatedX509Certificate")) {
            sig2 = this.getLastSignature();
            String id = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String key = attrs.getQName(i);
                if (!key.equalsIgnoreCase("Id")) continue;
                id = attrs.getValue(i);
            }
            CertValue cval = new CertValue();
            if (id != null) {
                cval.setId(id);
                try {
                    if (id.indexOf("RESPONDER_CERT") != -1 || id.indexOf("RESPONDER-CERT") != -1) {
                        cval.setType(2);
                    }
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (this.m_logger.isDebugEnabled() && cval != null) {
                this.m_logger.debug("Adding cval " + cval.getId() + " type: " + cval.getType() + " to: " + sig2.getId());
            }
            sig2.addCertValue(cval);
            this.m_sbCollectItem = new StringBuffer();
        }
        boolean bDfDdoc13Bad = false;
        if (tag.equals("DataFile")) {
            String ContentType = null;
            String Filename = null;
            Id = null;
            String MimeType = null;
            String Size = null;
            String DigestType = null;
            String Codepage = null;
            byte[] DigestValue = null;
            this.m_digest = null;
            if (this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && this.m_doc.getVersion().equals("1.3")) {
                this.m_xmlnsAttr = SignedDoc.xmlns_digidoc13;
                bDfDdoc13Bad = true;
            } else {
                this.m_xmlnsAttr = null;
            }
            ArrayList<DataFileAttribute> dfAttrs = new ArrayList<DataFileAttribute>();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String key = attrs.getQName(i);
                if (key.equals("ContentType")) {
                    ContentType = attrs.getValue(i);
                    continue;
                }
                if (key.equals("Filename")) {
                    Filename = attrs.getValue(i);
                    if (Filename.indexOf(47) == -1 && Filename.indexOf(92) == -1) continue;
                    DigiDocException ex = new DigiDocException(172, "Failed to parse DataFile name. Invalid file name!", null);
                    this.handleSAXError(ex);
                    continue;
                }
                if (key.equals("Id")) {
                    Id = attrs.getValue(i);
                    continue;
                }
                if (key.equals("MimeType")) {
                    MimeType = attrs.getValue(i);
                    continue;
                }
                if (key.equals("Size")) {
                    Size = attrs.getValue(i);
                    continue;
                }
                if (key.equals("DigestType")) {
                    DigestType = attrs.getValue(i);
                    continue;
                }
                if (key.equals("Codepage")) {
                    Codepage = attrs.getValue(i);
                    continue;
                }
                if (key.equals("DigestValue")) {
                    DigestValue = Base64Util.decode(attrs.getValue(i));
                    continue;
                }
                try {
                    if (!key.equals("xmlns")) {
                        DataFileAttribute attr = new DataFileAttribute(key, attrs.getValue(i));
                        dfAttrs.add(attr);
                        continue;
                    }
                    bDfDdoc13Bad = false;
                    continue;
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (this.m_nCollectMode == 0) {
                try {
                    DataFile df = new DataFile(Id, ContentType, Filename, MimeType, this.m_doc);
                    this.m_dfCacheOutStream = null;
                    if (Size != null) {
                        df.setSize(Long.parseLong(Size));
                    }
                    if (DigestValue != null) {
                        if (this.m_doc.getFormat().equals("SK-XML")) {
                            df.setAltDigest(DigestValue);
                        }
                        if (ContentType != null && ContentType.equals("HASHCODE")) {
                            df.setDigestValue(DigestValue);
                        }
                    }
                    if (Codepage != null) {
                        df.setInitialCodepage(Codepage);
                    }
                    for (int i = 0; i < dfAttrs.size(); ++i) {
                        df.addAttribute((DataFileAttribute)dfAttrs.get(i));
                    }
                    if (this.m_tempDir != null) {
                        File fCache = new File(this.m_tempDir + File.separator + df.getFileName());
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug("Parser temp DF: " + Id + " size: " + df.getSize() + " cache-file: " + fCache.getAbsolutePath());
                        }
                        this.m_dfCacheOutStream = new FileOutputStream(fCache);
                        df.setCacheFile(fCache);
                    } else if (df.schouldUseTempFile()) {
                        File fCache = df.createCacheFile();
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug("Df-temp DF: " + Id + " size: " + df.getSize() + " cache-file: " + fCache.getAbsolutePath());
                        }
                        df.setCacheFile(fCache);
                        this.m_dfCacheOutStream = new FileOutputStream(fCache);
                    }
                    this.m_doc.addDataFile(df);
                }
                catch (IOException ex) {
                    this.handleSAXError(ex);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            ++this.m_nCollectMode;
            try {
                if (Size != null) {
                    int nSize = Integer.parseInt(Size);
                    if (!ContentType.equals("HASHCODE")) {
                        if (ContentType.equals("EMBEDDED_BASE64")) {
                            nSize *= 2;
                            this.m_bCollectDigest = true;
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug("Start collecting digest");
                            }
                        }
                        if (this.m_doc.getFormat().equals("SK-XML")) {
                            this.m_bCollectDigest = false;
                        }
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug("Allocating buf: " + nSize + " Element: " + qName + " lname: " + lName + " uri: " + namespaceURI);
                        }
                        if (this.m_dfCacheOutStream == null) {
                            this.m_sbCollectChars = new StringBuffer(nSize);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.m_logger.error("Error: " + ex);
            }
        }
        if (tag.equals("SignedInfo")) {
            if (this.m_nCollectMode == 0) {
                try {
                    this.m_xmlnsAttr = this.m_doc != null && (this.m_doc.getVersion().equals("1.3") || this.m_doc.getFormat().equals("SK-XML")) ? null : SignedDoc.xmlns_xmldsig;
                    Signature sig3 = this.getLastSignature();
                    SignedInfo si = new SignedInfo(sig3);
                    if (sig3 != null) {
                        sig3.setSignedInfo(si);
                        Id = attrs.getValue("Id");
                        if (Id != null) {
                            si.setId(Id);
                        }
                    }
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            ++this.m_nCollectMode;
            this.m_sbCollectChars = new StringBuffer(1024);
        }
        if (tag.equals("SignedProperties")) {
            String Id2 = attrs.getValue("Id");
            String Target = attrs.getValue("Target");
            if (this.m_nCollectMode == 0) {
                try {
                    this.m_xmlnsAttr = this.m_doc != null && this.m_doc.getVersion().equals("1.3") ? null : SignedDoc.xmlns_xmldsig;
                    Signature sig4 = this.getLastSignature();
                    SignedProperties sp2 = new SignedProperties(sig4);
                    sp2.setId(Id2);
                    if (Target != null) {
                        sp2.setTarget(Target);
                    }
                    sig4.setSignedProperties(sp2);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            ++this.m_nCollectMode;
            this.m_sbCollectChars = new StringBuffer(2048);
        }
        if (tag.equals("XAdESSignatures") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Start collecting <XAdESSignatures>");
            }
            this.m_sbCollectSignature = new StringBuffer();
        }
        if (tag.equals("Signature") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Start collecting <Signature>");
            }
            if (this.m_doc == null) {
                DigiDocException ex = new DigiDocException(75, "Invalid signature format. Missing signed container root element.", null);
                this.handleSAXError(ex);
                SAXDigiDocException sex1 = new SAXDigiDocException("Invalid signature format. Missing signed container root element.");
                throw sex1;
            }
            String str1 = attrs.getValue("Id");
            sig = null;
            if (this.m_doc != null) {
                sig = this.m_doc.findSignatureById(str1);
            }
            if (sig == null || sig.getId() != null && !sig.getId().equals(str1)) {
                String sProfile;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Create signature: " + str1);
                }
                if (this.m_doc != null) {
                    sig = new Signature(this.m_doc);
                    try {
                        sig.setId(str1);
                    }
                    catch (DigiDocException ex) {
                        this.handleSAXError(ex);
                    }
                    sig.setPath(this.m_fileName);
                    sig.setComment(this.m_sigComment);
                    sProfile = this.m_doc.findSignatureProfile(this.m_fileName);
                    if (sProfile == null) {
                        sProfile = this.m_doc.findSignatureProfile(sig.getId());
                    }
                    if (sProfile != null) {
                        sig.setProfile(sProfile);
                    }
                    this.m_doc.addSignature(sig);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("Sig1: " + this.m_fileName + " profile: " + sProfile + " doc: " + (this.m_doc != null ? "OK" : "NULL"));
                    }
                } else {
                    this.m_sig = new Signature(null);
                    this.m_sig.setPath(this.m_fileName);
                    this.m_sig.setComment(this.m_sigComment);
                    sProfile = null;
                    if (this.m_doc != null && this.m_fileName != null) {
                        sProfile = this.m_doc.findSignatureProfile(this.m_fileName);
                    }
                    if (sProfile != null) {
                        this.m_sig.setProfile(sProfile);
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("Sig2: " + this.m_fileName + " profile: " + sProfile);
                    }
                    sig = this.m_sig;
                }
            }
            if (this.m_sbCollectSignature == null) {
                this.m_sbCollectSignature = new StringBuffer();
            }
        }
        if (tag.equals("SignatureValue") && this.m_nCollectMode == 0) {
            this.m_strSigValTs = null;
            ++this.m_nCollectMode;
            this.m_sbCollectChars = new StringBuffer(1024);
        }
        if (this.m_sbCollectSignature != null) {
            this.m_sbCollectSignature.append("<");
            this.m_sbCollectSignature.append(qName);
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.m_sbCollectSignature.append(" ");
                this.m_sbCollectSignature.append(attrs.getQName(i));
                this.m_sbCollectSignature.append("=\"");
                String s = attrs.getValue(i);
                s = s.replaceAll("&", "&amp;");
                this.m_sbCollectSignature.append(s);
                this.m_sbCollectSignature.append("\"");
            }
            this.m_sbCollectSignature.append(">");
        }
        if (this.m_nCollectMode > 0 || this.m_sbCollectChars != null) {
            StringBuffer sb = new StringBuffer();
            String sDfTagBad = null;
            sb.append("<");
            sb.append(qName);
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.getQName(i).equals("xmlns")) {
                    this.m_xmlnsAttr = null;
                    bDfDdoc13Bad = false;
                }
                sb.append(" ");
                sb.append(attrs.getQName(i));
                sb.append("=\"");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Attr: " + attrs.getQName(i) + " ='" + attrs.getValue(i) + "'");
                }
                if (!this.m_doc.getFormat().equals("SK-XML")) {
                    sb.append(ConvertUtils.escapeXmlSymbols(attrs.getValue(i)));
                } else {
                    String sv = attrs.getValue(i);
                    if (attrs.getQName(i).equals("DigestValue") && sv.endsWith(" ")) {
                        sv = sv.replaceAll(" ", "\n");
                    }
                    sb.append(sv);
                }
                sb.append("\"");
            }
            if (bDfDdoc13Bad) {
                sDfTagBad = sb.toString() + ">";
            }
            if (this.m_xmlnsAttr != null) {
                sb.append(" xmlns=\"" + this.m_xmlnsAttr + "\"");
                this.m_xmlnsAttr = null;
            }
            sb.append(">");
            if (tag.equals("DataFile") && this.m_nCollectMode == 1) {
                String strCan = null;
                if (!this.m_doc.getFormat().equals("SK-XML")) {
                    strCan = sb.toString() + "</DataFile>";
                    strCan = this.canonicalizeXml(strCan);
                    strCan = strCan.substring(0, strCan.length() - 11);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("Canonicalized: '" + strCan + "'");
                    }
                    if (sDfTagBad != null) {
                        strCan = sDfTagBad + "</DataFile>";
                        strCan = this.canonicalizeXml(strCan);
                        sDfTagBad = strCan.substring(0, strCan.length() - 11);
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug("Canonicalized alternative: '" + sDfTagBad + "'");
                        }
                    }
                    try {
                        this.updateDigest(ConvertUtils.str2data(strCan));
                        if (sDfTagBad != null) {
                            this.updateAltDigest(ConvertUtils.str2data(sDfTagBad));
                        }
                    }
                    catch (DigiDocException ex) {
                        this.handleSAXError(ex);
                    }
                }
            } else {
                if (this.m_sbCollectChars != null) {
                    this.m_sbCollectChars.append(sb.toString());
                }
                try {
                    if (this.m_dfCacheOutStream != null) {
                        this.m_dfCacheOutStream.write(ConvertUtils.str2data(sb.toString()));
                    }
                }
                catch (IOException ex) {
                    this.handleSAXError(ex);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
        }
        if (this.m_nCollectMode == 1) {
            DigiDocException ex;
            String sXmlns;
            if (tag.equals("CanonicalizationMethod")) {
                String Algorithm = attrs.getValue("Algorithm");
                try {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    si.setCanonicalizationMethod(Algorithm);
                }
                catch (DigiDocException ex2) {
                    this.handleSAXError(ex2);
                }
            }
            if (tag.equals("SignatureMethod")) {
                String Algorithm = attrs.getValue("Algorithm");
                try {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    si.setSignatureMethod(Algorithm);
                }
                catch (DigiDocException ex3) {
                    this.handleSAXError(ex3);
                }
            }
            if (tag.equals("Reference")) {
                String URI2 = attrs.getValue("URI");
                try {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    ref = new Reference(si);
                    String Id3 = attrs.getValue("Id");
                    if (Id3 != null) {
                        ref.setId(Id3);
                    }
                    ref.setUri(ConvertUtils.unescapeXmlSymbols(ConvertUtils.uriDecode(URI2)));
                    String sType = attrs.getValue("Type");
                    if (sType != null) {
                        ref.setType(sType);
                    }
                    si.addReference(ref);
                }
                catch (DigiDocException ex4) {
                    this.handleSAXError(ex4);
                }
            }
            if (tag.equals("X509SerialNumber") && this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && ((sXmlns = attrs.getValue("xmlns")) == null || !sXmlns.equals(SignedDoc.xmlns_xmldsig))) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("X509SerialNumber has none or invalid namespace: " + sXmlns);
                }
                ex = new DigiDocException(176, "X509SerialNumber has none or invalid namespace: " + sXmlns, null);
                this.handleSAXError(ex);
            }
            if (tag.equals("X509IssuerName") && this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && ((sXmlns = attrs.getValue("xmlns")) == null || !sXmlns.equals(SignedDoc.xmlns_xmldsig))) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("X509IssuerName has none or invalid namespace: " + sXmlns);
                }
                ex = new DigiDocException(176, "X509IssuerName has none or invalid namespace: " + sXmlns, null);
                this.handleSAXError(ex);
            }
            if (tag.equals("SignatureProductionPlace")) {
                try {
                    Signature sig5 = this.getLastSignature();
                    sp = sig5.getSignedProperties();
                    SignatureProductionPlace spp = new SignatureProductionPlace();
                    sp.setSignatureProductionPlace(spp);
                }
                catch (DigiDocException ex5) {
                    this.handleSAXError(ex5);
                }
            }
        }
        if (tag.equals("SignatureValue")) {
            String Id4 = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                SignatureValue spp = new SignatureValue(sig, Id4);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("OCSPRef")) {
            OcspRef orf2 = new OcspRef();
            sig = this.getLastSignature();
            UnsignedProperties usp = sig.getUnsignedProperties();
            rrefs = usp.getCompleteRevocationRefs();
            rrefs.addOcspRef(orf2);
        }
        if (tag.equals("DigestMethod")) {
            String Algorithm = attrs.getValue("Algorithm");
            try {
                if (this.m_tags.search("Reference") != -1) {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    ref = si.getLastReference();
                    ref.setDigestAlgorithm(Algorithm);
                } else if (this.m_tags.search("SigningCertificate") != -1) {
                    sig = this.getLastSignature();
                    CertID cid = sig.getOrCreateCertIdOfType(1);
                    cid.setDigestAlgorithm(Algorithm);
                } else if (this.m_tags.search("CompleteCertificateRefs") != -1) {
                    sig = this.getLastSignature();
                    CertID cid = sig.getLastCertId();
                    cid.setDigestAlgorithm(Algorithm);
                } else if (this.m_tags.search("CompleteRevocationRefs") != -1) {
                    sig = this.getLastSignature();
                    UnsignedProperties up = sig.getUnsignedProperties();
                    rrefs = up.getCompleteRevocationRefs();
                    orf = rrefs.getLastOcspRef();
                    if (orf != null) {
                        orf.setDigestAlgorithm(Algorithm);
                    }
                } else if (this.m_tags.search("SigPolicyHash") != -1) {
                    sig = this.getLastSignature();
                    SignedProperties sp3 = sig.getSignedProperties();
                    spi = sp3.getSignaturePolicyIdentifier();
                    SignaturePolicyId sppi = ((SignaturePolicyIdentifier)spi).getSignaturePolicyId();
                    sppi.setDigestAlgorithm(Algorithm);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("Cert")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                if (this.m_tags.search("SigningCertificate") != -1) {
                    CertID cid = sig.getOrCreateCertIdOfType(1);
                    if (id != null) {
                        cid.setId(id);
                    }
                }
                if (this.m_tags.search("CompleteCertificateRefs") != -1) {
                    CertID cid = sig.getOrCreateCertIdOfType(2);
                    if (id != null) {
                        cid.setId(id);
                    }
                    sig.addCertID(cid);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("AllDataObjectsTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 1);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("IndividualDataObjectsTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 2);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 3);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SigAndRefsTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 4);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("RefsOnlyTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 5);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("ArchiveTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 6);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("Include")) {
            String uri = attrs.getValue("URI");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = sig.getLastTimestampInfo();
                IncludeInfo inc = new IncludeInfo(uri);
                ts.addIncludeInfo(inc);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("CompleteCertificateRefs")) {
            String Target = attrs.getValue("Target");
            try {
                sig = this.getLastSignature();
                UnsignedProperties up = sig.getUnsignedProperties();
                CompleteCertificateRefs crefs = new CompleteCertificateRefs();
                up.setCompleteCertificateRefs(crefs);
                crefs.setUnsignedProperties(up);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("CompleteRevocationRefs")) {
            try {
                Signature sig6 = this.getLastSignature();
                UnsignedProperties up = sig6.getUnsignedProperties();
                CompleteRevocationRefs rrefs2 = new CompleteRevocationRefs();
                up.setCompleteRevocationRefs(rrefs2);
                rrefs2.setUnsignedProperties(up);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("OCSPIdentifier")) {
            String URI3 = attrs.getValue("URI");
            try {
                sig = this.getLastSignature();
                UnsignedProperties up = sig.getUnsignedProperties();
                rrefs = up.getCompleteRevocationRefs();
                orf = rrefs.getLastOcspRef();
                orf.setUri(URI3);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignaturePolicyIdentifier")) {
            try {
                Signature sig7 = this.getLastSignature();
                sp = sig7.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignaturePolicyId")) {
            try {
                Signature sig8 = this.getLastSignature();
                sp = sig8.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
                if ((spi = spid.getSignaturePolicyId()) == null) {
                    spi = new SignaturePolicyId(null);
                    spid.setSignaturePolicyId((SignaturePolicyId)spi);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("Identifier")) {
            try {
                Signature sig9 = this.getLastSignature();
                sp = sig9.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
                if ((spi = spid.getSignaturePolicyId()) == null) {
                    spi = new SignaturePolicyId(null);
                    spid.setSignaturePolicyId((SignaturePolicyId)spi);
                }
                String sQualifier = attrs.getValue("Qualifier");
                Identifier id = new Identifier(sQualifier);
                ObjectIdentifier oi = ((SignaturePolicyId)spi).getSigPolicyId();
                if (oi == null) {
                    oi = new ObjectIdentifier(id);
                } else {
                    oi.setIdentifier(id);
                }
                ((SignaturePolicyId)spi).setSigPolicyId(oi);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SigPolicyQualifier")) {
            try {
                Signature sig10 = this.getLastSignature();
                sp = sig10.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
                if ((spi = spid.getSignaturePolicyId()) == null) {
                    spi = new SignaturePolicyId(null);
                    spid.setSignaturePolicyId((SignaturePolicyId)spi);
                }
                SigPolicyQualifier spq = new SigPolicyQualifier();
                ((SignaturePolicyId)spi).addSigPolicyQualifier(spq);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("DataObjectFormat")) {
            Signature sig11 = this.getLastSignature();
            try {
                if (sig11 != null && (sp = sig11.getSignedProperties()) != null) {
                    SignedDataObjectProperties sdps = sp.getSignedDataObjectProperties();
                    if (sdps == null) {
                        sdps = new SignedDataObjectProperties();
                        sp.setSignedDataObjectProperties(sdps);
                    }
                    String sObjectReference = attrs.getValue("ObjectReference");
                    DataObjectFormat dof = new DataObjectFormat(sObjectReference);
                    sdps.addDataObjectFormat(dof);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("NonceAlgorithm")) {
            // empty if block
        }
        if (this.m_nCollectMode == 0) {
            if (tag.equals("SignedDoc")) {
                String format = null;
                String version = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String key = attrs.getQName(i);
                    if (key.equals("format")) {
                        format = attrs.getValue(i);
                    }
                    if (!key.equals("version")) continue;
                    version = attrs.getValue(i);
                }
                try {
                    this.m_doc = new SignedDoc();
                    this.m_doc.setFormat(format);
                    this.m_doc.setVersion(version);
                    if (format != null && (format.equals("SK-XML") || format.equals("DIGIDOC-XML"))) {
                        this.m_doc.setProfile("TM");
                    }
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("KeyInfo")) {
                try {
                    KeyInfo ki = new KeyInfo();
                    String Id5 = attrs.getValue("Id");
                    if (Id5 != null) {
                        ki.setId(Id5);
                    }
                    Signature sig12 = this.getLastSignature();
                    sig12.setKeyInfo(ki);
                    ki.setSignature(sig12);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("UnsignedProperties")) {
                String Target = attrs.getValue("Target");
                try {
                    sig = this.getLastSignature();
                    UnsignedProperties up = new UnsignedProperties(sig);
                    sig.setUnsignedProperties(up);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("EncapsulatedOCSPValue")) {
                String Id6 = attrs.getValue("Id");
                sig = this.getLastSignature();
                UnsignedProperties up = sig.getUnsignedProperties();
                Notary not = new Notary();
                if (Id6 != null) {
                    not.setId(Id6);
                }
                not.setId(Id6);
                up.addNotary(not);
                if (sig.getProfile() == null && (this.m_doc.getFormat().equals("DIGIDOC-XML") || this.m_doc.getFormat().equals("SK-XML"))) {
                    sig.setProfile("TM");
                }
            }
        }
    }

    private TreeSet collectNamespaces(String sCanInfo, TreeSet tsOtherAttr) {
        TreeSet<String> ts = new TreeSet<String>();
        int p1 = -1;
        int p2 = -1;
        p1 = sCanInfo.indexOf(62);
        if (p1 != -1) {
            String sHdr = sCanInfo.substring(0, p1);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Header: " + sHdr);
            }
            String[] toks = sHdr.split(" ");
            for (int i = 0; toks != null && i < toks.length; ++i) {
                String tok = toks[i];
                if (tok == null || tok.trim().length() <= 0 || tok.charAt(0) == '<') continue;
                if (tok.indexOf("xmlns") != -1) {
                    ts.add(tok);
                    continue;
                }
                tsOtherAttr.add(tok);
            }
        }
        return ts;
    }

    private void addNamespaceIfMissing(TreeSet ts, String ns, String pref) {
        boolean bF = false;
        for (String s : ts) {
            if (s == null || s.indexOf(ns) == -1) continue;
            bF = true;
            break;
        }
        if (!bF) {
            StringBuffer sb = new StringBuffer("xmlns");
            if (pref != null) {
                sb.append(":");
                sb.append(pref);
            }
            sb.append("=\"");
            sb.append(ns);
            sb.append("\"");
            ts.add(sb.toString());
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        CertValue cval;
        CertID cid;
        OcspRef orf;
        CompleteRevocationRefs rrefs;
        UnsignedProperties up;
        SignedProperties sp;
        TimestampInfo ts;
        SignedInfo si;
        Signature sig;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("End Element: " + qName + " collect: " + this.m_nCollectMode);
        }
        String tag = qName;
        String nsPref = null;
        if (tag.indexOf(58) != -1) {
            tag = qName.substring(qName.indexOf(58) + 1);
            nsPref = qName.substring(0, qName.indexOf(58));
        }
        if (this.m_elemCurrent != null) {
            this.m_elemCurrent = this.m_elemCurrent.getParent();
        }
        String currTag = (String)this.m_tags.pop();
        StringBuffer sb = null;
        if (!(this.m_nCollectMode <= 0 || tag.equals("DataFile") && this.m_nCollectMode <= 1)) {
            sb = new StringBuffer();
            sb.append("</");
            sb.append(qName);
            sb.append(">");
        }
        if (this.m_sbCollectSignature != null) {
            this.m_sbCollectSignature.append("</");
            this.m_sbCollectSignature.append(qName);
            this.m_sbCollectSignature.append(">");
        }
        if (this.m_sbCollectChars != null && sb != null) {
            this.m_sbCollectChars.append(sb.toString());
        }
        if (tag.equals("DataFile")) {
            --this.m_nCollectMode;
            if (this.m_nCollectMode == 0) {
                try {
                    if (this.m_dfCacheOutStream != null) {
                        if (sb != null) {
                            this.m_dfCacheOutStream.write(ConvertUtils.str2data(sb.toString()));
                        }
                        this.m_dfCacheOutStream.close();
                        this.m_dfCacheOutStream = null;
                    }
                }
                catch (IOException ex) {
                    this.handleSAXError(ex);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
                DataFile df = this.m_doc.getLastDataFile();
                if (df != null && df.getContentType().equals("EMBEDDED_BASE64")) {
                    try {
                        if (this.m_doc.getFormat().equals("SK-XML")) {
                            String sDf = null;
                            if (this.m_sbCollectChars != null) {
                                sDf = this.m_sbCollectChars.toString();
                                this.setDataFileBodyAsData(df);
                                this.m_sbCollectChars = null;
                            } else if (df.getDfCacheFile() != null) {
                                byte[] data = null;
                                try {
                                    data = SignedDoc.readFile(df.getDfCacheFile());
                                    sDf = new String(data);
                                }
                                catch (Exception ex) {
                                    this.m_logger.error("Error reading cache file: " + df.getDfCacheFile() + " - " + ex);
                                }
                            }
                            if (sDf != null) {
                                byte[] bDf = Base64Util.decode(sDf);
                                this.updateDigest(bDf);
                            }
                            df.setDigest(this.getDigest());
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug("Digest: " + df.getId() + " - " + Base64Util.encode(df.getDigest()) + " size: " + df.getSize());
                            }
                        } else {
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug("DF: " + df.getId() + " cache-file: " + df.getDfCacheFile());
                            }
                            if (df.getDfCacheFile() == null) {
                                this.setDataFileBodyAsData(df);
                            }
                            this.updateDigest("</DataFile>".getBytes());
                            df.setDigest(this.getDigest());
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug("Digest: " + df.getId() + " - " + Base64Util.encode(df.getDigest()) + " size: " + df.getSize());
                            }
                        }
                        if (this.m_altDigest != null) {
                            this.updateAltDigest(ConvertUtils.str2data("</DataFile>"));
                            df.setAltDigest(this.getAltDigest());
                        }
                        this.m_sbCollectChars = null;
                    }
                    catch (DigiDocException ex) {
                        this.handleSAXError(ex);
                    }
                }
                this.m_bCollectDigest = false;
            }
        }
        if (tag.equals("SignedInfo")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            try {
                sig = this.getLastSignature();
                si = sig.getSignedInfo();
                String sSigInf = this.m_sbCollectChars.toString();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("SigInf:\n------\n" + sSigInf + "\n------\n");
                }
                byte[] bCanSI = null;
                if (this.m_doc.getFormat().equals("SK-XML")) {
                    bCanSI = sSigInf.getBytes();
                } else {
                    CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                    bCanSI = si.getCanonicalizationMethod().equals("http://www.w3.org/2001/10/xml-exc-c14n#") ? canFac.canonicalize(ConvertUtils.str2data(sSigInf, "UTF-8"), "http://www.w3.org/2001/10/xml-exc-c14n#") : canFac.canonicalize(ConvertUtils.str2data(sSigInf, "UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                }
                si.setOrigDigest(SignedDoc.digestOfType(bCanSI, "SHA-1"));
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("SigInf:\n------\n" + new String(bCanSI) + "\n------\nHASH: " + Base64Util.encode(si.getOrigDigest()));
                }
                this.m_sbCollectChars = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignedProperties")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            try {
                sig = this.getLastSignature();
                si = sig.getSignedInfo();
                SignedProperties sp2 = sig.getSignedProperties();
                String sigProp = this.m_sbCollectChars.toString();
                byte[] bSigProp = ConvertUtils.str2data(sigProp, "UTF-8");
                byte[] bDig0 = SignedDoc.digestOfType(bSigProp, "SHA-1");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("SigProp0:\n------\n" + sigProp + "\n------ len: " + sigProp.length() + " sha1 HASH0: " + Base64Util.encode(bDig0));
                }
                CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                byte[] bCanProp = null;
                bCanProp = si.getCanonicalizationMethod().equals("http://www.w3.org/2001/10/xml-exc-c14n#") ? canFac.canonicalize(bSigProp, "http://www.w3.org/2001/10/xml-exc-c14n#") : canFac.canonicalize(bSigProp, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("SigProp can:\n------\n" + new String(bCanProp, "UTF-8") + "\n------ len: " + bCanProp.length);
                }
                this.m_sbCollectChars = null;
                CertID cid2 = sig.getCertIdOfType(1);
                if (cid2 != null) {
                    if (cid2.getId() != null) {
                        sp2.setCertId(cid2.getId());
                    } else if (!sig.getSignedDoc().getVersion().equals("1.3")) {
                        sp2.setCertId(sig.getId() + "-CERTINFO");
                    }
                    sp2.setCertSerial(cid2.getSerial());
                    sp2.setCertDigestAlgorithm(cid2.getDigestAlgorithm());
                    if (cid2.getDigestValue() != null) {
                        sp2.setCertDigestValue(cid2.getDigestValue());
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("CID: " + cid2.getId() + " ser: " + cid2.getSerial() + " alg: " + cid2.getDigestAlgorithm());
                    }
                }
                if (this.m_doc.getFormat().equals("DIGIDOC-XML") || this.m_doc.getFormat().equals("SK-XML")) {
                    String sDigType1 = ConfigManager.digAlg2Type(sp2.getCertDigestAlgorithm());
                    if (sDigType1 != null) {
                        sp2.setOrigDigest(SignedDoc.digestOfType(bCanProp, sDigType1));
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("SigProp2:\n------\n" + new String(bCanProp) + "\n------\n len: " + bCanProp.length + " digtype: " + sDigType1 + " HASH: " + Base64Util.encode(sp2.getOrigDigest()));
                    }
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            catch (UnsupportedEncodingException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureValue")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            this.m_strSigValTs = this.m_sbCollectChars.toString();
            this.m_sbCollectChars = null;
        }
        if (tag.equals("CompleteRevocationRefs")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            if (this.m_sbCollectChars != null) {
                this.m_strSigAndRefsTs = this.m_strSigValTs + this.m_sbCollectChars.toString();
            }
            this.m_sbCollectChars = null;
        }
        if (tag.equals("Signature") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("End collecting <Signature>");
            }
            try {
                sig = this.getLastSignature();
                if (this.m_sbCollectSignature != null) {
                    sig.setOrigContent(ConvertUtils.str2data(this.m_sbCollectSignature.toString(), "UTF-8"));
                    this.m_sbCollectSignature = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("XAdESSignatures") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("End collecting <XAdESSignatures>");
            }
            try {
                sig = this.getLastSignature();
                if (this.m_sbCollectSignature != null) {
                    sig.setOrigContent(ConvertUtils.str2data(this.m_sbCollectSignature.toString(), "UTF-8"));
                    this.m_sbCollectSignature = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureTimeStamp")) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("End collecting <SignatureTimeStamp>");
            }
            try {
                sig = this.getLastSignature();
                ts = sig.getTimestampInfoOfType(3);
                if (ts != null && this.m_strSigValTs != null) {
                    CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                    byte[] bCanXml = canFac.canonicalize(ConvertUtils.str2data(this.m_strSigValTs, "UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    byte[] hash = SignedDoc.digest(bCanXml);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("SigValTS \n---\n" + new String(bCanXml) + "\n---\nHASH: " + Base64Util.encode(hash));
                    }
                    ts.setHash(hash);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SigAndRefsTimeStamp")) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("End collecting <SigAndRefsTimeStamp>");
            }
            try {
                sig = this.getLastSignature();
                ts = sig.getTimestampInfoOfType(4);
                if (ts != null && this.m_strSigAndRefsTs != null) {
                    String canXml = "<a>" + this.m_strSigAndRefsTs + "</a>";
                    CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                    byte[] bCanXml = canFac.canonicalize(ConvertUtils.str2data(canXml, "UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    canXml = new String(bCanXml, "UTF-8");
                    canXml = canXml.substring(3, canXml.length() - 4);
                    byte[] hash = SignedDoc.digest(ConvertUtils.str2data(canXml, "UTF-8"));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("SigAndRefsTimeStamp \n---\n" + canXml + "\n---\n" + Base64Util.encode(hash));
                    }
                    ts.setHash(hash);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            catch (Exception ex) {
                this.handleSAXError(ex);
            }
        }
        if (this.m_nCollectMode == 1) {
            SignatureProductionPlace spp;
            if (tag.equals("SigningTime")) {
                try {
                    sig = this.getLastSignature();
                    sp = sig.getSignedProperties();
                    sp.setSigningTime(ConvertUtils.string2date(this.m_sbCollectItem.toString(), this.m_doc));
                    this.m_sbCollectItem = null;
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("ClaimedRole")) {
                sig = this.getLastSignature();
                sp = sig.getSignedProperties();
                sp.addClaimedRole(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("City")) {
                sig = this.getLastSignature();
                sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setCity(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("StateOrProvince")) {
                sig = this.getLastSignature();
                sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setStateOrProvince(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("CountryName")) {
                sig = this.getLastSignature();
                sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setCountryName(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("PostalCode")) {
                sig = this.getLastSignature();
                sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setPostalCode(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
        }
        if (tag.equals("DigestValue")) {
            try {
                if (this.m_tags.search("Reference") != -1) {
                    sig = this.getLastSignature();
                    si = sig.getSignedInfo();
                    Reference ref = si.getLastReference();
                    ref.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("SigningCertificate") != -1) {
                    sig = this.getLastSignature();
                    sp = sig.getSignedProperties();
                    sp.setCertDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    CertID cid3 = sig.getCertIdOfType(1);
                    if (cid3 != null) {
                        cid3.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    }
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("CompleteCertificateRefs") != -1) {
                    sig = this.getLastSignature();
                    up = sig.getUnsignedProperties();
                    CompleteCertificateRefs crefs = up.getCompleteCertificateRefs();
                    CertID cid4 = crefs.getLastCertId();
                    if (cid4 != null) {
                        cid4.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("CertID: " + cid4.getId() + " digest: " + this.m_sbCollectItem.toString());
                    }
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("CompleteRevocationRefs") != -1) {
                    sig = this.getLastSignature();
                    up = sig.getUnsignedProperties();
                    rrefs = up.getCompleteRevocationRefs();
                    orf = rrefs.getLastOcspRef();
                    orf.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("Revoc ref: " + this.m_sbCollectItem.toString());
                    }
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("SigPolicyHash") != -1) {
                    sig = this.getLastSignature();
                    sp = sig.getSignedProperties();
                    SignaturePolicyIdentifier spi = sp.getSignaturePolicyIdentifier();
                    SignaturePolicyId sppi = spi.getSignaturePolicyId();
                    sppi.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("SignaturePolicyId hash: " + this.m_sbCollectItem.toString());
                    }
                    this.m_sbCollectItem = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("IssuerSerial") && this.m_doc != null && !this.m_doc.getVersion().equals("1.3")) {
            try {
                sig = this.getLastSignature();
                cid = sig.getLastCertId();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("X509SerialNumber 0: " + this.m_sbCollectItem.toString());
                }
                if (cid != null) {
                    cid.setSerial(ConvertUtils.string2bigint(this.m_sbCollectItem.toString()));
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("X509SerialNumber") && this.m_doc != null && this.m_doc.getVersion().equals("1.3")) {
            try {
                sig = this.getLastSignature();
                cid = sig.getLastCertId();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("X509SerialNumber: " + this.m_sbCollectItem.toString());
                }
                if (cid != null) {
                    cid.setSerial(ConvertUtils.string2bigint(this.m_sbCollectItem.toString()));
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("X509SerialNumber: " + cid.getSerial() + " type: " + cid.getType());
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("X509IssuerName") && this.m_doc != null && this.m_doc.getVersion().equals("1.3")) {
            try {
                sig = this.getLastSignature();
                cid = sig.getLastCertId();
                String s = this.m_sbCollectItem.toString();
                if (cid != null) {
                    cid.setIssuer(s);
                }
                if (this.m_logger.isDebugEnabled() && cid != null) {
                    this.m_logger.debug("X509IssuerName: " + s + " type: " + cid.getType() + " nr: " + cid.getSerial());
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("ResponderID")) {
            try {
                sig = this.getLastSignature();
                up = sig.getUnsignedProperties();
                rrefs = up.getCompleteRevocationRefs();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("ResponderID: " + this.m_sbCollectItem.toString());
                }
                orf = rrefs.getLastOcspRef();
                orf.setResponderId(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("ProducedAt")) {
            try {
                sig = this.getLastSignature();
                up = sig.getUnsignedProperties();
                rrefs = up.getCompleteRevocationRefs();
                orf = rrefs.getLastOcspRef();
                orf.setProducedAt(ConvertUtils.string2date(this.m_sbCollectItem.toString(), this.m_doc));
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureValue")) {
            try {
                sig = this.getLastSignature();
                SignatureValue sv = sig.getSignatureValue();
                if (this.m_sbCollectItem != null && this.m_sbCollectItem.length() > 0) {
                    sig.setSignatureValue(Base64Util.decode(this.m_sbCollectItem.toString().trim()));
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("SIGVAL mode: " + this.m_nCollectMode + ":\n--\n" + (this.m_sbCollectItem != null ? this.m_sbCollectItem.toString() : "NULL") + "\n---\n len: " + (sv.getValue() != null ? sv.getValue().length : 0));
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("X509Certificate")) {
            try {
                sig = this.getLastSignature();
                cval = sig.getLastCertValue();
                cval.setCert(SignedDoc.readCertificate(Base64Util.decode(this.m_sbCollectItem.toString())));
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("EncapsulatedX509Certificate")) {
            try {
                sig = this.getLastSignature();
                cval = sig.getLastCertValue();
                cval.setCert(SignedDoc.readCertificate(Base64Util.decode(this.m_sbCollectItem.toString())));
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("EncapsulatedOCSPValue")) {
            try {
                sig = this.getLastSignature();
                this.findCertIDandCertValueTypes(sig);
                up = sig.getUnsignedProperties();
                Notary not = up.getLastNotary();
                not.setOcspResponseData(Base64Util.decode(this.m_sbCollectItem.toString()));
                NotaryFactory notFac = ConfigManager.instance().getNotaryFactory();
                notFac.parseAndVerifyResponse(sig, not);
                if (this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && this.m_doc.getVersion().equals("1.1")) {
                    CompleteRevocationRefs rrefs2 = up.getCompleteRevocationRefs();
                    OcspRef orf2 = rrefs2.getLastOcspRef();
                    orf2.setDigestValue(SignedDoc.digestOfType(not.getOcspResponseData(), "SHA-1"));
                }
                this.m_sbCollectItem = null;
            }
            catch (Exception ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SPURI")) {
            SignaturePolicyId spi;
            SignaturePolicyIdentifier spid;
            sig = this.getLastSignature();
            if (sig != null && (sp = sig.getSignedProperties()) != null && (spid = sp.getSignaturePolicyIdentifier()) != null && (spi = spid.getSignaturePolicyId()) != null) {
                spi.addSigPolicyQualifier(new SpUri(this.m_sbCollectItem.toString().trim()));
            }
            this.m_sbCollectItem = null;
        }
        if (tag.equals("MimeType")) {
            try {
                SignedDataObjectProperties sdps;
                DataObjectFormat dof;
                sig = this.getLastSignature();
                if (sig != null && (sp = sig.getSignedProperties()) != null && (dof = (sdps = sp.getSignedDataObjectProperties()).getLastDataObjectFormat()) != null) {
                    dof.setMimeType(this.m_sbCollectItem.toString());
                    Reference ref = sig.getSignedInfo().getReferenceForDataObjectFormat(dof);
                    if (ref != null) {
                        for (int d = 0; d < sig.getSignedDoc().countDataFiles(); ++d) {
                            String sUri;
                            DataFile df = sig.getSignedDoc().getDataFile(d);
                            if (df.getFileName() == null || df.getFileName().length() <= 1 || ref.getUri() == null || ref.getUri().length() <= 1) continue;
                            String sFileName = df.getFileName();
                            if (sFileName.charAt(0) == '/') {
                                sFileName = sFileName.substring(1);
                            }
                            if ((sUri = ref.getUri()).charAt(0) == '/') {
                                sUri = sUri.substring(1);
                            }
                            if (!sFileName.equals(sUri)) continue;
                            df.setMimeType(this.m_sbCollectItem.toString());
                        }
                    }
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
    }

    private void setDataFileBodyAsData(DataFile df) throws DigiDocException {
        long nSize = df.getSize();
        byte[] b = Base64Util.decode(this.m_sbCollectChars.toString());
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("DF: " + df.getId() + " orig-size: " + nSize + " new size: " + b.length);
        }
        if (nSize == 0L) {
            nSize = b.length;
        }
        df.setBodyAsData(ConvertUtils.str2data(this.m_sbCollectChars.toString(), "UTF-8"), true, nSize);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (s != null) {
            if (this.m_sbCollectItem != null) {
                this.m_sbCollectItem.append(s);
            }
            if (this.m_sbCollectChars != null) {
                this.m_sbCollectChars.append(ConvertUtils.escapeTextNode(s));
            }
            if (this.m_sbCollectSignature != null) {
                this.m_sbCollectSignature.append(ConvertUtils.escapeTextNode(s));
            }
            if (this.m_digest != null && this.m_bCollectDigest) {
                this.updateDigest(s.getBytes());
            }
            if (this.m_altDigest != null && this.m_bCollectDigest) {
                this.updateAltDigest(s.getBytes());
            }
            try {
                if (this.m_dfCacheOutStream != null) {
                    this.m_dfCacheOutStream.write(ConvertUtils.str2data(s));
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            catch (IOException ex) {
                this.handleSAXError(ex);
            }
        }
    }
}

