/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.Serializable;
import java.util.ArrayList;
import org.digidoc4j.ddoc.DataFile;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.SignedInfo;
import org.digidoc4j.ddoc.SignedProperties;
import org.digidoc4j.ddoc.utils.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SignedInfo m_sigInfo;
    private String m_id;
    private String m_uri;
    private String m_digestAlgorithm;
    private byte[] m_digestValue;
    private String m_transformAlgorithm;
    private String m_type;
    private static Logger m_logger = LoggerFactory.getLogger(Reference.class);

    public Reference(SignedInfo sigInfo) {
        this.m_sigInfo = sigInfo;
        this.m_uri = null;
        this.m_id = null;
        this.m_type = null;
        this.m_digestAlgorithm = null;
        this.m_digestValue = null;
        this.m_transformAlgorithm = null;
    }

    public Reference(SignedInfo sigInfo, String uri, String algorithm, byte[] digest, String transform) throws DigiDocException {
        this.m_sigInfo = sigInfo;
        this.setUri(uri);
        this.setDigestAlgorithm(algorithm);
        this.setDigestValue(digest);
        this.setTransformAlgorithm(transform);
    }

    public Reference(SignedInfo sigInfo, DataFile df, String digType) throws DigiDocException {
        this.m_sigInfo = sigInfo;
        String sDigType = digType;
        if (digType == null) {
            sDigType = ConfigManager.instance().getDefaultDigestType(this.m_sigInfo.getSignature().getSignedDoc());
        }
        String sDigAlg = ConfigManager.digType2Alg(sDigType);
        this.setDigestAlgorithm(sDigAlg);
        if (df.getContentType().equals("HASHCODE") || df.getContentType().equals("EMBEDDED_BASE64")) {
            this.setUri("#" + df.getId());
        }
        this.setDigestValue(df.getDigestValueOfType(sDigType));
    }

    public SignedInfo getSignedInfo() {
        return this.m_sigInfo;
    }

    public void setSignedInfo(SignedInfo sigInfo) {
        this.m_sigInfo = sigInfo;
    }

    public Reference(SignedInfo sigInfo, SignedProperties sp, String digType) throws DigiDocException {
        this.m_sigInfo = sigInfo;
        String sDigType = digType;
        if (digType == null) {
            sDigType = ConfigManager.instance().getDefaultDigestType(this.m_sigInfo.getSignature().getSignedDoc());
        }
        String sDigAlg = ConfigManager.digType2Alg(sDigType);
        this.setDigestAlgorithm(sDigAlg);
        this.setUri(sp.getTarget() + "-SignedProperties");
        this.setDigestValue(sp.calculateDigest());
        this.setTransformAlgorithm(null);
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setUri(String str) throws DigiDocException {
        DigiDocException ex = this.validateUri(str);
        if (ex != null) {
            throw ex;
        }
        this.m_uri = str;
    }

    private DigiDocException validateUri(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(22, "URI does not exists", null);
        }
        return ex;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public String getDigestAlgorithm() {
        return this.m_digestAlgorithm;
    }

    public void setDigestAlgorithm(String str) throws DigiDocException {
        DigiDocException ex = this.validateDigestAlgorithm(str);
        if (ex != null) {
            throw ex;
        }
        this.m_digestAlgorithm = str;
    }

    private DigiDocException validateDigestAlgorithm(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            ex = new DigiDocException(20, "Currently supports only SHA-1", null);
        }
        return ex;
    }

    public byte[] getDigestValue() {
        return this.m_digestValue;
    }

    public void setDigestValue(byte[] data) throws DigiDocException {
        DigiDocException ex = this.validateDigestValue(data);
        if (ex != null) {
            throw ex;
        }
        this.m_digestValue = data;
    }

    private DigiDocException validateDigestValue(byte[] data) {
        DigiDocException ex = null;
        if (data == null || data.length != 20) {
            ex = new DigiDocException(21, "Invalid digest length", null);
        }
        return ex;
    }

    public String getTransformAlgorithm() {
        return this.m_transformAlgorithm;
    }

    public void setTransformAlgorithm(String str) throws DigiDocException {
        DigiDocException ex = this.validateTransformAlgorithm(str);
        if (ex != null) {
            throw ex;
        }
        this.m_transformAlgorithm = str;
    }

    private DigiDocException validateTransformAlgorithm(String str) {
        DigiDocException ex = null;
        if (!(str == null || str.equals("http://www.sk.ee/2002/10/digidoc#detatched-document-signature") || str.equals("http://www.w3.org/TR/2000/CR-xml-c14n-20001026") || str.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature"))) {
            ex = new DigiDocException(23, "Currently supports either no transforms or one detatched document transform", null);
        }
        return ex;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String str) {
        this.m_type = str;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateUri(this.m_uri);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateDigestAlgorithm(this.m_digestAlgorithm)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateDigestValue(this.m_digestValue)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateTransformAlgorithm(this.m_transformAlgorithm)) != null) {
            errs.add(ex);
        }
        return errs;
    }
}

