/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc.tsl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.factory.TrustServiceFactory;
import org.digidoc4j.ddoc.tsl.MultiLangString;
import org.digidoc4j.ddoc.tsl.SchemeInformation;
import org.digidoc4j.ddoc.tsl.TSPInformation;
import org.digidoc4j.ddoc.tsl.TSPService;
import org.digidoc4j.ddoc.tsl.TrustServiceProvider;
import org.digidoc4j.ddoc.tsl.TrustServiceStatusList;
import org.digidoc4j.ddoc.tsl.TslParser;
import org.digidoc4j.ddoc.utils.ConfigManager;
import org.digidoc4j.ddoc.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigiDocTrustServiceFactory
implements TrustServiceFactory {
    private static Logger m_logger = LoggerFactory.getLogger(DigiDocTrustServiceFactory.class);
    private List m_tsls;

    @Override
    public void init() throws DigiDocException {
        try {
            ConfigManager cfg = ConfigManager.instance();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("Reading local config file");
            }
            TrustServiceStatusList tsl = new TrustServiceStatusList();
            SchemeInformation si = new SchemeInformation();
            si.setVersionIdentifier(1);
            si.setSequenceNumber(1);
            si.setType("LOCAL");
            tsl.setSchemeInformation(si);
            this.m_tsls = new ArrayList();
            this.m_tsls.add(tsl);
            int nCas = cfg.getIntProperty("DIGIDOC_CAS", 0);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("CA-s: " + nCas);
            }
            for (int c = 1; c <= nCas; ++c) {
                TrustServiceProvider tsp = this.addTspProvider(cfg.getStringProperty("DIGIDOC_CA_" + c + "_NAME", null), cfg.getStringProperty("DIGIDOC_CA_" + c + "_TRADENAME", null));
                int nCerts = cfg.getIntProperty("DIGIDOC_CA_" + c + "_CERTS", 0);
                for (int n = 1; n <= nCerts; ++n) {
                    String certLoc = cfg.getStringProperty("DIGIDOC_CA_" + c + "_CERT" + n, null);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("CA" + c + " ca-cert" + n + " - " + certLoc);
                    }
                    try {
                        X509Certificate cert = DigiDocTrustServiceFactory.readCertificate(certLoc);
                        if (cert == null || tsp == null) continue;
                        this.addCATspService(tsp, cert);
                        continue;
                    }
                    catch (Exception ex2) {
                        m_logger.warn("Failed to read CA cert: " + certLoc);
                    }
                }
                int nOcsps = cfg.getIntProperty("DIGIDOC_CA_" + c + "_OCSPS", 0);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("OCSP-s: " + nOcsps);
                }
                for (int n = 1; n <= nOcsps; ++n) {
                    String certLoc = cfg.getStringProperty("DIGIDOC_CA_" + c + "_OCSP" + n + "_CERT", null);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("CA" + c + " ocsp-cert" + n + " - " + certLoc);
                    }
                    TSPService tsps = null;
                    try {
                        X509Certificate cert = DigiDocTrustServiceFactory.readCertificate(certLoc);
                        if (cert != null && tsp != null) {
                            tsps = this.addOcspTspService(tsp, cert, cfg.getStringProperty("DIGIDOC_CA_" + c + "_OCSP" + n + "_CN", null), cfg.getStringProperty("DIGIDOC_CA_" + c + "_OCSP" + n + "_URL", null), cfg.getStringProperty("DIGIDOC_CA_" + c + "_OCSP" + n + "_CN", null), cfg.getStringProperty("DIGIDOC_CA_" + c + "_OCSP" + n + "_CA_CN", null));
                        }
                    }
                    catch (Exception ex2) {
                        m_logger.warn("Failed to read OCSP responder cert: " + certLoc);
                    }
                    int j = 1;
                    do {
                        certLoc = cfg.getStringProperty("DIGIDOC_CA_" + c + "_OCSP" + n + "_CERT_" + j, null);
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug("CA" + c + " ocsp-cert" + n + "/" + j + " - " + certLoc);
                        }
                        if (certLoc != null && tsps != null) {
                            try {
                                X509Certificate cert = DigiDocTrustServiceFactory.readCertificate(certLoc);
                                if (cert != null) {
                                    tsps.addCertificate(cert);
                                }
                            }
                            catch (Exception ex) {
                                m_logger.warn("Failed to read OCSP responder cert: " + certLoc);
                            }
                        }
                        ++j;
                    } while (certLoc != null);
                }
                if (!m_logger.isDebugEnabled()) continue;
                m_logger.debug("Local config: " + tsl);
            }
            String sTslDir = cfg.getStringProperty("DIGIDOC_TSL_DIR", null);
            if (sTslDir != null && sTslDir.length() > 0) {
                File fTslDir = new File(sTslDir);
                File[] lTsls = fTslDir.listFiles();
                for (int i = 0; lTsls != null && i < lTsls.length; ++i) {
                    File f = lTsls[i];
                    if (!f.isFile() || !f.canRead()) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("Reading TSL: " + f.getAbsolutePath());
                    }
                    TslParser parser = new TslParser();
                    FileInputStream fis = new FileInputStream(f);
                    TrustServiceStatusList tsl2 = parser.readTSL(fis);
                    fis.close();
                    if (tsl2 == null) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("Got TSL: " + tsl2);
                    }
                    this.m_tsls.add(tsl2);
                }
            }
        }
        catch (DigiDocException ex) {
            m_logger.error("Error init TrustServiceFactory dd: " + ex);
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            m_logger.error("Error init TrustServiceFactory: " + ex);
            ex.printStackTrace();
        }
    }

    private TrustServiceStatusList findTslByType(String type) {
        for (int i = 0; this.m_tsls != null && i < this.m_tsls.size(); ++i) {
            TrustServiceStatusList tsl = (TrustServiceStatusList)this.m_tsls.get(i);
            if (tsl.getSchemeInformation() == null || tsl.getSchemeInformation().getType() == null || !tsl.getSchemeInformation().getType().equals(type)) continue;
            return tsl;
        }
        return null;
    }

    public TrustServiceProvider addTspProvider(String name, String tradeName) {
        TrustServiceStatusList tsl = this.findTslByType("LOCAL");
        if (tsl != null) {
            TrustServiceProvider tsp = new TrustServiceProvider();
            tsl.addTrustServiceProvider(tsp);
            TSPInformation tsi = new TSPInformation();
            tsi.addName(new MultiLangString(null, name));
            tsi.addTradeName(new MultiLangString(null, tradeName));
            tsp.setTSPInformation(tsi);
            return tsp;
        }
        return null;
    }

    public TSPService addCATspService(TrustServiceProvider tspProvider, X509Certificate cert) {
        TSPService tsps = new TSPService();
        tsps.setType("http://uri.etsi.org/TrstSvc/Svctype/CA/QC");
        tsps.addCertificate(cert);
        tsps.addSubjectName(new MultiLangString(null, cert.getSubjectDN().getName()));
        tsps.addName(new MultiLangString(null, ConvertUtils.getCommonName(cert.getSubjectDN().getName())));
        tsps.setCn(ConvertUtils.getCommonName(cert.getSubjectDN().getName()));
        tspProvider.addTSPService(tsps);
        return tsps;
    }

    public TSPService addOcspTspService(TrustServiceProvider tspProvider, X509Certificate cert, String name, String ocspUrl, String cn, String caCn) {
        TSPService tsps = new TSPService();
        tsps.setType("http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/SvcInfoExt/OCSP-QC");
        tsps.addCertificate(cert);
        tsps.addSubjectName(new MultiLangString(null, cert.getSubjectDN().getName()));
        tsps.addName(new MultiLangString(null, name));
        tsps.addServiceAccessPoint(ocspUrl);
        tsps.setCn(cn);
        tsps.setCaCn(caCn);
        tspProvider.addTSPService(tsps);
        return tsps;
    }

    private static X509Certificate readCertificate(String certLocation) throws DigiDocException {
        X509Certificate cert = null;
        try {
            InputStream isCert = null;
            URL url = null;
            if (certLocation != null) {
                if (certLocation.startsWith("http")) {
                    url = new URL(certLocation);
                    isCert = url.openStream();
                } else if (certLocation.startsWith("jar://")) {
                    ClassLoader cl = ConfigManager.instance().getClass().getClassLoader();
                    isCert = cl.getResourceAsStream(certLocation.substring(6));
                } else {
                    isCert = new FileInputStream(certLocation);
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)certificateFactory.generateCertificate(isCert);
                isCert.close();
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Read cert: " + certLocation + " - " + (cert != null ? "OK" : "NULL"));
                }
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
        return cert;
    }

    private X509Certificate findCaForCertInTsl(TrustServiceStatusList tsl, X509Certificate cert, Date dtSigning) {
        Principal caP = cert.getIssuerDN();
        String subDn = cert.getSubjectDN().getName();
        for (int j = 0; j < tsl.getNumProviders(); ++j) {
            TrustServiceProvider tsp = tsl.getTrustServiceProvider(j);
            for (int l = 0; l < tsp.getNumServices(); ++l) {
                TSPService tsps = tsp.getTSPService(l);
                if (!tsps.isCA()) continue;
                for (int m = 0; m < tsps.getNumCertificates(); ++m) {
                    X509Certificate c2 = tsps.getCertificate(m);
                    if (c2 == null) continue;
                    Principal c2p = c2.getSubjectDN();
                    String ca2Dn = c2.getSubjectDN().getName();
                    if (!c2p.equals(caP) || dtSigning != null && (dtSigning == null || !dtSigning.after(c2.getNotBefore()) || !dtSigning.before(c2.getNotAfter()))) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("Found matching CA dn: " + ca2Dn);
                    }
                    try {
                        cert.verify(c2.getPublicKey());
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug("CA: " + ca2Dn + " IS issuer of: " + subDn + " serial: " + c2.getSerialNumber().toString());
                        }
                        return c2;
                    }
                    catch (Exception ex) {
                        if (!m_logger.isDebugEnabled()) continue;
                        m_logger.debug("CA: " + ca2Dn + " IS NOT issuer of: " + subDn);
                    }
                }
            }
        }
        return null;
    }

    private X509Certificate findOcspInTsl(TrustServiceStatusList tsl, String cn) {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Search OCSP by cn: " + cn);
        }
        for (int j = 0; j < tsl.getNumProviders(); ++j) {
            TrustServiceProvider tsp = tsl.getTrustServiceProvider(j);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("TSP: " + tsp.getTSPInformation().getName(0));
            }
            for (int l = 0; l < tsp.getNumServices(); ++l) {
                TSPService tsps = tsp.getTSPService(l);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Service: " + tsps.getCn() + " ocsp: " + tsps.isOCSP() + " CA: " + tsps.isCA());
                }
                if (!tsps.isOCSP() || tsps.getCn() == null || !tsps.getCn().equalsIgnoreCase(cn)) continue;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Found OCSP: " + cn);
                }
                return tsps.getCertificate(0);
            }
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Did not find ocsp for: " + cn);
        }
        return null;
    }

    private X509Certificate[] findOcspsInTsl(TrustServiceStatusList tsl, String cn, String serialNr) {
        int j;
        X509Certificate[] lcert = null;
        Vector<X509Certificate> vec = new Vector<X509Certificate>();
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Search OCSP by cn: " + cn + " serial: " + serialNr);
        }
        for (j = 0; j < tsl.getNumProviders(); ++j) {
            TrustServiceProvider tsp = tsl.getTrustServiceProvider(j);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("TSP: " + tsp.getTSPInformation().getName(0));
            }
            for (int l = 0; l < tsp.getNumServices(); ++l) {
                TSPService tsps = tsp.getTSPService(l);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Service: " + tsps.getCn() + " ocsp: " + tsps.isOCSP() + " CA: " + tsps.isCA());
                }
                if (!tsps.isOCSP() || tsps.getCn() == null || !tsps.getCn().equalsIgnoreCase(cn)) continue;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Found OCSP: " + cn);
                }
                for (int m = 0; m < tsps.getNumCertificates(); ++m) {
                    X509Certificate cert = tsps.getCertificate(m);
                    if (serialNr != null && (serialNr == null || !serialNr.equals(cert.getSerialNumber().toString()))) continue;
                    if (m_logger.isDebugEnabled() && cert != null) {
                        m_logger.debug("Found cert: " + cert.getSubjectDN().toString() + " serial: " + cert.getSerialNumber().toString());
                    }
                    vec.add(cert);
                }
            }
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Found: " + vec.size() + " certs for: " + cn);
        }
        lcert = new X509Certificate[vec.size()];
        for (j = 0; j < vec.size(); ++j) {
            lcert[j] = (X509Certificate)vec.elementAt(j);
        }
        return lcert;
    }

    @Override
    public X509Certificate findCaForCert(X509Certificate cert, boolean bUseLocal) {
        return this.findCaForCert(cert, bUseLocal, null);
    }

    @Override
    public X509Certificate findCaForCert(X509Certificate cert, boolean bUseLocal, Date dtSigning) {
        Principal caP = cert.getIssuerDN();
        String caDn = cert.getIssuerDN().getName();
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Search CA: " + caDn);
        }
        for (int i = 0; this.m_tsls != null && i < this.m_tsls.size(); ++i) {
            X509Certificate ca;
            TrustServiceStatusList tsl = (TrustServiceStatusList)this.m_tsls.get(i);
            if ((!tsl.isLocal() || !bUseLocal) && tsl.isLocal() || (ca = this.findCaForCertInTsl(tsl, cert, dtSigning)) == null) continue;
            return ca;
        }
        return null;
    }

    @Override
    public X509Certificate[] findOcspsByCNAndNr(String cn, boolean bUseLocal, String serialNr) {
        X509Certificate[] lcert = null;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Search OCSP: " + cn + " use-local: " + bUseLocal + " serial: " + serialNr);
        }
        for (int i = 0; this.m_tsls != null && lcert == null && i < this.m_tsls.size(); ++i) {
            TrustServiceStatusList tsl = (TrustServiceStatusList)this.m_tsls.get(i);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("TSL: " + tsl.getSchemeInformation().getSchemeName(0) + " local: " + tsl.isLocal());
            }
            if ((!tsl.isLocal() || !bUseLocal) && tsl.isLocal()) continue;
            lcert = this.findOcspsInTsl(tsl, cn, serialNr);
            X509Certificate x509Certificate = this.findOcspInTsl(tsl, cn);
        }
        return lcert;
    }
}

