/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.SignedDoc;
import org.digidoc4j.ddoc.tsl.MultiLangString;
import org.digidoc4j.ddoc.utils.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertUtils {
    private static final String m_dateFormat = "yyyy.MM.dd'T'HH:mm:ss'Z'";
    private static final String m_dateFormatXAdES = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String m_dateFormatIso8601 = "yyyy.MM.dd'T'HH:mm:ss";
    private static final String m_dateFormatSSS = "yyyy.MM.dd'T'HH:mm:ss.SSS'Z'";
    private static final String m_dateFormatXAdESSSS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static Logger m_logger = LoggerFactory.getLogger(ConvertUtils.class);
    public static final String X509_NAME_RFC = "RFC2253";
    private static final byte[] sha1AlgPrefix13Bad = new byte[]{48, 31, 48, 7, 6, 5, 43, 14, 3, 2, 26, 4, 20, 0};
    private static final byte[] sha1AlgPrefix15Bad = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20, 0};
    private static final byte[] sha1AlgPrefix1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] sha1AlgPrefix2 = new byte[]{48, 31, 48, 7, 6, 5, 43, 14, 3, 2, 26, 4, 20};

    public static String date2string(Date d, SignedDoc ddoc) throws DigiDocException {
        String str = null;
        String sF = null;
        try {
            if (d != null) {
                sF = ddoc.getVersion().equals("1.3") ? m_dateFormatXAdES : m_dateFormat;
                SimpleDateFormat f = new SimpleDateFormat(sF);
                f.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
                str = f.format(d);
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 45);
        }
        return str;
    }

    public static String convX509Name(X500Principal principal) {
        String sName = principal.getName(X509_NAME_RFC);
        return sName;
    }

    public static String getTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean compareBytes(byte[] srch, byte[] from, int idx1) {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Find: '" + SignedDoc.bin2hex(srch) + "' int: '" + SignedDoc.bin2hex(from) + "' starting: " + idx1);
        }
        if (srch != null && from != null && idx1 >= 0 && idx1 + srch.length < from.length) {
            for (int i = idx1; i < idx1 + srch.length; ++i) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Pos: " + i + " " + from[i] + " - " + srch[i - idx1]);
                }
                if (from[i] == srch[i - idx1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String findDigType(byte[] digest) {
        if (ConvertUtils.compareBytes(sha1AlgPrefix13Bad, digest, 0) && digest.length == 34 || ConvertUtils.compareBytes(sha1AlgPrefix15Bad, digest, 0) && digest.length == 36) {
            return "SHA-1-00";
        }
        if (ConvertUtils.compareBytes(sha1AlgPrefix1, digest, 0) || ConvertUtils.compareBytes(sha1AlgPrefix2, digest, 0)) {
            return "SHA-1";
        }
        return null;
    }

    public static byte[] removePrefix(byte[] digest) {
        int nLen = 0;
        if (ConvertUtils.compareBytes(sha1AlgPrefix1, digest, 0)) {
            nLen = sha1AlgPrefix1.length;
        } else if (ConvertUtils.compareBytes(sha1AlgPrefix2, digest, 0)) {
            nLen = sha1AlgPrefix2.length;
        }
        if (nLen > 0) {
            byte[] ndig = new byte[digest.length - nLen];
            System.arraycopy(digest, digest.length - ndig.length, ndig, 0, ndig.length);
            return ndig;
        }
        return null;
    }

    public static Date string2date(String str, SignedDoc ddoc) throws DigiDocException {
        Date d = null;
        String sF = null;
        try {
            sF = ddoc.getVersion().equals("1.3") ? m_dateFormatXAdES : (ddoc.getFormat().equals("SK-XML") ? m_dateFormatIso8601 : m_dateFormat);
            SimpleDateFormat f = new SimpleDateFormat(sF);
            if (!ddoc.getFormat().equals("SK-XML")) {
                f.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            }
            if (str != null && str.length() > 0) {
                d = f.parse(str.trim());
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 45);
        }
        return d;
    }

    public static Date str2date(String str) {
        Date d = null;
        try {
            SimpleDateFormat f = new SimpleDateFormat(m_dateFormatXAdES);
            if (str != null && str.length() >= 20 && str.charAt(10) == 'T') {
                if (str.charAt(4) == '-' && str.charAt(7) == '-') {
                    f = str.length() > 20 ? new SimpleDateFormat(m_dateFormatXAdESSSS) : new SimpleDateFormat(m_dateFormatXAdES);
                }
                if (str.charAt(4) == '.' && str.charAt(7) == '.') {
                    f = str.length() > 20 ? (str.charAt(20) == '-' ? new SimpleDateFormat(m_dateFormatIso8601) : new SimpleDateFormat(m_dateFormatSSS)) : new SimpleDateFormat(m_dateFormat);
                }
                f.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
                d = f.parse(str.trim());
            }
        }
        catch (Exception ex) {
            m_logger.error("Error parsing date: " + str + " - " + ex);
        }
        return d;
    }

    public static BigInteger string2bigint(String str) throws DigiDocException {
        BigInteger b = null;
        try {
            if (str != null && str.length() > 0) {
                b = new BigInteger(str.trim());
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 77);
        }
        return b;
    }

    public static byte[] data2utf8(byte[] data, String codepage) throws DigiDocException {
        byte[] bdata = null;
        try {
            String str = new String(data, codepage);
            bdata = str.getBytes("UTF-8");
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 73);
        }
        return bdata;
    }

    public static byte[] str2data(String str) throws DigiDocException {
        return ConvertUtils.str2data(str, "UTF-8");
    }

    public static byte[] str2data(String str, String codepage) throws DigiDocException {
        byte[] bdata = null;
        try {
            bdata = str.getBytes(codepage);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 73);
        }
        return bdata;
    }

    public static String data2str(byte[] data, String codepage) throws DigiDocException {
        String str = null;
        try {
            str = new String(data, codepage);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 73);
        }
        return str;
    }

    public static boolean isKnownOCSPCert(String cn) {
        int nOcsps = ConfigManager.instance().getIntProperty("DIGIDOC_OCSP_COUNT", 0);
        for (int i = 0; i < nOcsps; ++i) {
            String s = ConfigManager.instance().getProperty("DIGIDOC_OCSP" + (i + 1) + "_CN");
            if (s == null || !s.equals(cn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownTSACert(String cn) {
        int nTsas = ConfigManager.instance().getIntProperty("DIGIDOC_TSA_COUNT", 0);
        for (int i = 0; i < nTsas; ++i) {
            String s = ConfigManager.instance().getProperty("DIGIDOC_TSA" + (i + 1) + "_CN");
            if (s == null || !s.equals(cn)) continue;
            return true;
        }
        return false;
    }

    public static String getCommonName(String dn) {
        int idx1;
        String name = null;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("DN: " + dn);
        }
        if (dn != null && (idx1 = dn.indexOf("CN=")) != -1) {
            int idx2;
            idx1 += 2;
            while (idx1 < dn.length() && !Character.isLetter(dn.charAt(idx1))) {
                ++idx1;
            }
            for (idx2 = idx1; idx2 < dn.length() && dn.charAt(idx2) != '\"' && dn.charAt(idx2) != '\\' && dn.charAt(idx2) != ',' && dn.charAt(idx2) != '/'; ++idx2) {
            }
            name = dn.substring(idx1, idx2);
        }
        return name;
    }

    public static String bin2hex(byte[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            String str = Integer.toHexString(arr[i]);
            if (str.length() == 2) {
                sb.append(str);
            }
            if (str.length() < 2) {
                sb.append("0");
                sb.append(str);
            }
            if (str.length() <= 2) continue;
            sb.append(str.substring(str.length() - 2));
        }
        return sb.toString();
    }

    public static String uriDecode(String s1) {
        if (s1 == null || s1.length() == 0) {
            return s1;
        }
        try {
            String s = s1;
            s = ConvertUtils.replaceStr(s, '+', "%2B");
            s = URLDecoder.decode(s, "UTF-8");
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("URI: " + s1 + " decoded: " + s);
            }
            return s;
        }
        catch (Exception ex) {
            m_logger.error("Error decoding bytes: " + ex);
            return null;
        }
    }

    private static String replaceStr(String src, char c1, String rep) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; src != null && i < src.length(); ++i) {
            char c2 = src.charAt(i);
            if (c2 == c1) {
                sb.append(rep);
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    public static String uriEncodePath(String s1) {
        try {
            String s = s1;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("Before uri-path-enc: " + s);
            }
            s = URLEncoder.encode(s, "UTF-8");
            s = ConvertUtils.replaceStr(s, '+', "%20");
            s = s.replaceAll("%7E", "~");
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("URI path: " + s1 + " encoded: " + s);
            }
            return s;
        }
        catch (Exception ex) {
            m_logger.error("Error encoding path: " + ex);
            return null;
        }
    }

    public static String escapeXmlSymbols(String s1) {
        if (s1 == null || s1.length() == 0) {
            return s1;
        }
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < s1.length(); ++i) {
                char c1 = s1.charAt(i);
                if (c1 == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c1 == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c1 == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c1 == '\r') {
                    sb.append("&#xD;");
                    continue;
                }
                if (c1 == '\'') {
                    sb.append("&apos;");
                    continue;
                }
                if (c1 == '\"') {
                    sb.append("&quot;");
                    continue;
                }
                sb.append(c1);
            }
        }
        catch (Exception ex) {
            m_logger.error("Error converting bytes: " + ex);
        }
        return sb.toString();
    }

    public static String escapeTextNode(String s1) {
        if (s1 == null || s1.length() == 0) {
            return s1;
        }
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < s1.length(); ++i) {
                char c1 = s1.charAt(i);
                if (c1 == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c1 == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c1 == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c1 == '\r') {
                    sb.append("&#xD;");
                    continue;
                }
                sb.append(c1);
            }
        }
        catch (Exception ex) {
            m_logger.error("Error converting bytes: " + ex);
        }
        return sb.toString();
    }

    public static String unescapeXmlSymbols(String s1) {
        String s2 = s1.replaceAll("&lt;", "<");
        s2 = s2.replaceAll("&gt;", ">");
        s2 = s2.replaceAll("&gt;", ">");
        s2 = s2.replaceAll("&#xD;", "\r");
        s2 = s2.replaceAll("&apos;", "'");
        s2 = s2.replaceAll("&quot;", "\"");
        s2 = s2.replaceAll("&amp;", "&");
        s2 = s2.replaceAll("&#xA;", "\n");
        return s2;
    }

    public static String intElemToString(String name, int value) {
        StringBuffer sb = new StringBuffer();
        if (value != 0) {
            sb.append("(");
            sb.append(name);
            sb.append("=");
            sb.append(value);
            sb.append(")");
        }
        return sb.toString();
    }

    public static String stringElemToString(String name, String value) {
        StringBuffer sb = new StringBuffer();
        if (value != null) {
            sb.append("(");
            sb.append(name);
            sb.append("=");
            sb.append(value);
            sb.append(")");
        }
        return sb.toString();
    }

    public static String dateElemToString(String name, Date value) {
        StringBuffer sb = new StringBuffer();
        if (value != null) {
            sb.append("(");
            sb.append(name);
            sb.append("=");
            Calendar cal = Calendar.getInstance();
            cal.setTime(value);
            sb.append(cal.get(5));
            sb.append(".");
            sb.append(cal.get(2) + 1);
            sb.append(".");
            sb.append(cal.get(1));
            sb.append(")");
        }
        return sb.toString();
    }

    public static MultiLangString[] list2mls(List l) {
        MultiLangString[] arr = null;
        if (l != null && l.size() > 0) {
            arr = new MultiLangString[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                arr[i] = (MultiLangString)l.get(i);
            }
        }
        return arr;
    }

    public static Date[] list2dates(List l) {
        Date[] arr = null;
        if (l != null && l.size() > 0) {
            arr = new Date[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                arr[i] = (Date)l.get(i);
            }
        }
        return arr;
    }

    public static String[] list2strings(List l) {
        String[] arr = null;
        if (l != null && l.size() > 0) {
            arr = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                arr[i] = (String)l.get(i);
            }
        }
        return arr;
    }

    public static List addObject(List l, Object o) {
        if (l == null) {
            l = new ArrayList<Object>();
        }
        l.add(o);
        return l;
    }

    public static MultiLangString getListObj(List l, int n) {
        if (l != null && n >= 0 && n < l.size()) {
            return (MultiLangString)l.get(n);
        }
        return null;
    }

    public static String getListString(List l, int n) {
        if (l != null && n >= 0 && n < l.size()) {
            return (String)l.get(n);
        }
        return null;
    }
}

