/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64InputStream;
import org.digidoc4j.ddoc.Base64Util;
import org.digidoc4j.ddoc.DataFileAttribute;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.ManifestFileEntry;
import org.digidoc4j.ddoc.Reference;
import org.digidoc4j.ddoc.SignedDoc;
import org.digidoc4j.ddoc.factory.CanonicalizationFactory;
import org.digidoc4j.ddoc.utils.ConfigManager;
import org.digidoc4j.ddoc.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class DataFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_contentType;
    private String m_fileName;
    private String m_id;
    private String m_mimeType;
    private String m_comment;
    private long m_size;
    private byte[] m_digestSha1;
    private byte[] m_digestAlt;
    private byte[] m_origDigestValue;
    private ArrayList m_attributes;
    private byte[] m_body;
    private String m_codepage;
    private SignedDoc m_sigDoc;
    public static final String CONTENT_EMBEDDED_BASE64 = "EMBEDDED_BASE64";
    public static final String CONTENT_BINARY = "BINARY";
    public static final String CONTENT_HASHCODE = "HASHCODE";
    public static final String DIGEST_TYPE_SHA1 = "sha1";
    private static int block_size = 2048;
    private static Logger m_logger = LoggerFactory.getLogger(DataFile.class);
    private transient File m_fDfCache = null;
    private boolean m_bodyIsBase64;
    private Date m_lModDt = null;

    public DataFile(String id, String contentType, String fileName, String mimeType, SignedDoc sdoc) throws DigiDocException {
        this.m_sigDoc = sdoc;
        this.setId(id);
        this.setContentType(contentType);
        this.setFileName(fileName);
        this.setMimeType(mimeType);
        this.m_size = 0L;
        this.m_digestSha1 = null;
        this.m_attributes = null;
        this.m_body = null;
        this.m_codepage = "UTF-8";
        this.m_origDigestValue = null;
        this.m_fDfCache = null;
        this.m_bodyIsBase64 = false;
        this.m_comment = null;
    }

    public File getDfCacheFile() {
        return this.m_fDfCache;
    }

    public void cleanupDfCache() {
        if (this.m_fDfCache != null) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("Removing cache file for df: " + this.m_fDfCache.getAbsolutePath());
            }
            this.m_fDfCache.delete();
        }
        this.m_fDfCache = null;
    }

    public byte[] getBody() throws DigiDocException {
        if (this.m_fDfCache != null) {
            try {
                byte[] data = SignedDoc.readFile(this.m_fDfCache);
                if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                    data = Base64Util.decode(data);
                }
                return data;
            }
            catch (Exception ex) {
                DigiDocException.handleException(ex, 10);
            }
        }
        return this.m_body;
    }

    public void setBody(byte[] data) throws DigiDocException {
        try {
            this.m_body = data;
            if (data != null) {
                this.m_size = data.length;
                this.storeInTempFile();
                if (this.m_contentType != null) {
                    if (this.m_contentType.equals(CONTENT_BINARY)) {
                        if (!this.isDigestsCalculated()) {
                            if (this.m_body != null) {
                                this.calcHashes(new ByteArrayInputStream(this.m_body));
                            } else if (this.m_fDfCache != null) {
                                this.calcHashes(new FileInputStream(this.m_fDfCache));
                            }
                        }
                        if (this.m_mimeType != null) {
                            String sFile = this.m_fileName;
                            if (sFile != null && sFile.indexOf(47) != -1 || sFile.indexOf(92) != -1) {
                                File fT = new File(sFile);
                                sFile = fT.getName();
                            }
                            if (this.m_sigDoc.findManifestEntryByPath(sFile) == null) {
                                ManifestFileEntry fe = new ManifestFileEntry(this.m_mimeType, sFile);
                                this.m_sigDoc.getManifest().addFileEntry(fe);
                            }
                        }
                    }
                    if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64) && !this.isDigestsCalculated()) {
                        this.m_size = data.length;
                        this.m_body = Base64Util.encode(data).getBytes();
                        this.m_bodyIsBase64 = true;
                    }
                }
            }
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 11);
        }
    }

    public void setBase64Body(byte[] data) {
        if (data != null) {
            this.m_size = data.length;
            this.m_body = Base64Util.encode(data).getBytes();
            this.m_bodyIsBase64 = true;
        }
    }

    public void setBodyAsData(byte[] data, boolean b64, long len) {
        if (data != null) {
            this.m_size = len;
            this.m_body = data;
            this.m_bodyIsBase64 = b64;
        }
    }

    public boolean getBodyIsBase64() {
        return this.m_bodyIsBase64;
    }

    public void setBodyIsBase64(boolean b) {
        this.m_bodyIsBase64 = b;
    }

    public Date getLastModDt() {
        return this.m_lModDt;
    }

    public void setLastModDt(Date d) {
        this.m_lModDt = d;
    }

    public void setBodyFromStream(InputStream is) throws DigiDocException {
        if (is == null) {
            return;
        }
        try {
            File fCacheDir = new File(ConfigManager.instance().getStringProperty("DIGIDOC_DF_CACHE_DIR", System.getProperty("java.io.tmpdir")));
            String dfId = new Long(System.currentTimeMillis()).toString();
            this.m_fDfCache = File.createTempFile(dfId, ".df", fCacheDir);
            FileOutputStream fos = new FileOutputStream(this.m_fDfCache);
            this.m_body = null;
            byte[] data = new byte[2048];
            int nRead = 0;
            this.m_size = 0L;
            do {
                if ((nRead = is.read(data)) <= 0) continue;
                fos.write(data, 0, nRead);
                this.m_size += (long)nRead;
            } while (nRead > 0);
            fos.close();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("DF: " + this.m_id + " size: " + this.m_size + " cache-file: " + this.m_fDfCache.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 11);
        }
    }

    public boolean isDigestsCalculated() {
        return this.m_digestSha1 != null;
    }

    private void calcHashesAndWriteToStream(InputStream is, OutputStream os) throws DigiDocException {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] data = new byte[2048];
            int nRead = 0;
            this.m_size = 0L;
            do {
                if ((nRead = is.read(data)) <= 0) continue;
                sha1.update(data, 0, nRead);
                if (os != null) {
                    os.write(data, 0, nRead);
                }
                this.m_size += (long)nRead;
            } while (nRead > 0);
            this.m_origDigestValue = sha1.digest();
            this.m_digestSha1 = this.m_origDigestValue;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("DF: " + this.m_id + " size: " + this.m_size + " dig-sha1: " + Base64Util.encode(this.m_digestSha1));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
    }

    public void calcHashes(InputStream is) throws DigiDocException {
        this.calcHashesAndWriteToStream(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calcHashOfType(String digType) throws DigiDocException {
        byte[] dig = null;
        InputStream is = null;
        try {
            if (digType == null || !digType.equals("SHA-1")) {
                throw new DigiDocException(20, "Invalid digest type: " + digType, null);
            }
            if (this.m_sigDoc.getFormat().equals("SK-XML") || this.m_sigDoc.getFormat().equals("DIGIDOC-XML")) {
                byte[] byArray = this.getDigest();
                return byArray;
            }
            MessageDigest sha = MessageDigest.getInstance(digType);
            byte[] data = new byte[2048];
            int nRead = 0;
            int nTotal = 0;
            is = this.getBodyAsStream();
            do {
                if ((nRead = is.read(data)) <= 0) continue;
                sha.update(data, 0, nRead);
                nTotal += nRead;
            } while (nRead > 0);
            dig = sha.digest();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("DF: " + this.m_id + " size: " + nTotal + " digest: " + digType + " = " + Base64Util.encode(dig));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                m_logger.error("Error closing stream: " + ex);
            }
        }
        return dig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrCacheBodyAndCalcHashes(InputStream is) throws DigiDocException {
        OutputStream os = null;
        try {
            this.m_fDfCache = this.createCacheFile();
            os = this.m_fDfCache != null ? new FileOutputStream(this.m_fDfCache) : new ByteArrayOutputStream();
            this.calcHashesAndWriteToStream(is, os);
            if (this.m_fDfCache == null) {
                this.m_body = ((ByteArrayOutputStream)os).toByteArray();
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("DF: " + this.m_id + " size: " + this.m_size + " cache: " + (this.m_fDfCache != null ? this.m_fDfCache.getAbsolutePath() : "MEMORY") + " dig-sha1: " + Base64Util.encode(this.m_digestSha1));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 11);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception ex) {
                m_logger.error("Error closing stream: " + ex);
            }
        }
    }

    public String getBodyAsString() throws DigiDocException {
        String str = null;
        if (this.m_fDfCache != null) {
            try {
                byte[] data = SignedDoc.readFile(this.m_fDfCache);
                if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                    str = ConvertUtils.data2str(Base64Util.decode(data), this.m_codepage);
                }
            }
            catch (Exception ex) {
                DigiDocException.handleException(ex, 10);
            }
        } else if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
            str = ConvertUtils.data2str(Base64Util.decode(this.m_body), this.m_codepage);
        }
        return str;
    }

    public byte[] getBodyAsData() throws DigiDocException {
        byte[] data = null;
        if (this.m_fDfCache != null) {
            try {
                data = SignedDoc.readFile(this.m_fDfCache);
                if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                    data = Base64Util.decode(data);
                }
            }
            catch (Exception ex) {
                DigiDocException.handleException(ex, 10);
            }
        } else if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
            data = Base64Util.decode(this.m_body);
        }
        return data;
    }

    public boolean hasAccessToDataFile() {
        if (this.m_fDfCache != null || this.m_body != null) {
            return true;
        }
        StringBuffer sbFil = new StringBuffer();
        File fT = new File(this.m_fileName);
        return fT.isFile() && fT.canRead();
    }

    public InputStream getBodyAsStream() throws DigiDocException {
        Object strm = null;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("get body as stream f-cache: " + (this.m_fDfCache != null ? this.m_fDfCache.getAbsolutePath() : "NULL") + " file: " + (this.m_fileName != null ? this.m_fileName : "NULL") + " content: " + this.m_contentType + " body: " + (this.m_body != null ? this.m_body.length : 0) + " is-b64: " + this.m_bodyIsBase64);
        }
        if (this.m_fDfCache != null || this.m_fileName != null) {
            try {
                if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                    if (this.m_fDfCache != null) {
                        strm = new Base64InputStream((InputStream)new FileInputStream(this.m_fDfCache));
                    } else if (this.m_body != null) {
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug(" body: " + (this.m_body != null ? this.m_body.length : 0) + " data: \n---\n" + new String(this.m_body) + "\n--\n");
                        }
                        strm = new Base64InputStream((InputStream)new ByteArrayInputStream(this.m_body));
                    }
                } else if (this.m_contentType.equals(CONTENT_BINARY)) {
                    if (this.m_fDfCache != null) {
                        strm = new FileInputStream(this.m_fDfCache);
                    } else if (this.m_body != null) {
                        strm = new ByteArrayInputStream(this.m_body);
                    } else if (this.m_fileName != null) {
                        strm = new FileInputStream(this.m_fileName);
                    }
                }
            }
            catch (Exception ex) {
                DigiDocException.handleException(ex, 10);
            }
        } else if (this.m_body != null) {
            // empty if block
        }
        return strm;
    }

    public boolean schouldUseTempFile() {
        long lMaxDfCached = ConfigManager.instance().getLongProperty("DIGIDOC_MAX_DATAFILE_CACHED", Long.MAX_VALUE);
        return lMaxDfCached > 0L && (this.m_size == 0L || this.m_size > lMaxDfCached && (this.m_contentType == null || this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)));
    }

    public File createCacheFile() throws IOException {
        if (this.m_fDfCache == null && this.schouldUseTempFile()) {
            File fCacheDir = new File(ConfigManager.instance().getStringProperty("DIGIDOC_DF_CACHE_DIR", System.getProperty("java.io.tmpdir")));
            String dfId = new Long(System.currentTimeMillis()).toString();
            this.m_fDfCache = File.createTempFile(dfId, ".df", fCacheDir);
        }
        return this.m_fDfCache;
    }

    public void setCacheFile(File d) {
        this.m_fDfCache = d;
    }

    private void storeInTempFile() throws IOException {
        File f = this.createCacheFile();
        if (f != null) {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(this.m_body);
            fos.close();
            this.m_body = null;
        }
    }

    public void setBody(byte[] data, String codepage) throws DigiDocException {
        try {
            this.m_body = data;
            this.m_codepage = codepage;
            this.m_size = this.m_body.length;
            this.storeInTempFile();
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 11);
        }
    }

    public void setBody(Node xml) throws DigiDocException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(xml);
            StreamResult result = new StreamResult(bos);
            transformer.transform(source, result);
            this.m_body = bos.toByteArray();
            this.m_codepage = "UTF-8";
            this.m_size = this.m_body.length;
            this.storeInTempFile();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 89);
        }
    }

    public String getInitialCodepage() {
        return this.m_codepage;
    }

    public void setInitialCodepage(String data) {
        this.m_codepage = data;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public void setContentType(String str) throws DigiDocException {
        DigiDocException ex = this.validateContentType(str);
        if (ex != null) {
            throw ex;
        }
        this.m_contentType = str;
    }

    private DigiDocException validateContentType(String str) {
        DigiDocException ex = null;
        boolean bUseHashcode = ConfigManager.instance().getBooleanProperty("DATAFILE_HASHCODE_MODE", false);
        if (this.m_sigDoc != null && (str == null || !str.equals(CONTENT_EMBEDDED_BASE64) && !str.equals(CONTENT_HASHCODE) || str.equals(CONTENT_HASHCODE) && !bUseHashcode)) {
            ex = new DigiDocException(105, "Currently supports only content types EMBEDDED_BASE64 for DDOC format", null);
        }
        return ex;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String str) throws DigiDocException {
        DigiDocException ex = this.validateFileName(str);
        if (ex != null) {
            throw ex;
        }
        this.m_fileName = str;
    }

    private DigiDocException validateFileName(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(28, "Filename is a required attribute", null);
        }
        return ex;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) throws DigiDocException {
        DigiDocException ex = this.validateId(str, false);
        if (ex != null) {
            throw ex;
        }
        this.m_id = str;
    }

    private DigiDocException validateId(String str, boolean bStrong) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(29, "Id is a required attribute", null);
        }
        if (str != null && bStrong && this.m_sigDoc.getFormat() != null && (str.charAt(0) != 'D' || !Character.isDigit(str.charAt(1)) && str.charAt(1) != 'O')) {
            ex = new DigiDocException(29, "Id attribute value has to be in form D<number> or DO", null);
        }
        return ex;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public void setMimeType(String str) throws DigiDocException {
        DigiDocException ex = this.validateMimeType(str);
        if (ex != null) {
            throw ex;
        }
        this.m_mimeType = str;
    }

    private DigiDocException validateMimeType(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(30, "MimeType is a required attribute", null);
        }
        return ex;
    }

    public long getSize() {
        return this.m_size;
    }

    public void setSize(long l) throws DigiDocException {
        DigiDocException ex = this.validateSize(l);
        if (ex != null) {
            throw ex;
        }
        this.m_size = l;
    }

    private DigiDocException validateSize(long l) {
        DigiDocException ex = null;
        if (l < 0L) {
            ex = new DigiDocException(31, "Size must be greater or equal to zero", null);
        }
        return ex;
    }

    public String getDigestType() {
        if (this.m_sigDoc != null && this.m_sigDoc.countSignatures() > 0) {
            Reference ref = this.m_sigDoc.getSignature(0).getSignedInfo().getReferenceForDataFile(this);
            if (ref != null) {
                return ref.getDigestAlgorithm();
            }
            return "SHA-1";
        }
        return null;
    }

    private DigiDocException validateDigestType(String str) {
        DigiDocException ex = null;
        if (str != null && !str.equals(DIGEST_TYPE_SHA1) && !str.equals("SHA-1")) {
            ex = new DigiDocException(32, "The only supported digest types are sha1", null);
        }
        return ex;
    }

    public byte[] getDigestValueOfType(String digType) throws DigiDocException {
        if (digType != null && (digType.equals("SHA-1") || digType.equals(DIGEST_TYPE_SHA1))) {
            if (this.m_digestSha1 == null && this.m_origDigestValue == null) {
                this.m_origDigestValue = this.calcHashOfType("SHA-1");
                this.m_digestSha1 = this.m_origDigestValue;
            }
            return this.m_digestSha1 != null ? this.m_digestSha1 : this.m_origDigestValue;
        }
        return this.m_digestSha1;
    }

    public void setDigestValue(byte[] data) throws DigiDocException {
        DigiDocException ex = this.validateDigestValue(data);
        if (ex != null) {
            throw ex;
        }
        if (data.length == 20) {
            this.m_digestSha1 = data;
        }
    }

    public byte[] getDigest() throws DigiDocException {
        if (this.m_origDigestValue == null) {
            this.calculateFileSizeAndDigest(null);
        }
        return this.m_origDigestValue;
    }

    public void setDigest(byte[] data) throws DigiDocException {
        DigiDocException ex = this.validateDigestValue(data);
        if (ex != null) {
            throw ex;
        }
        this.m_origDigestValue = data;
    }

    public byte[] getAltDigest() {
        return this.m_digestAlt;
    }

    public void setAltDigest(byte[] b) {
        this.m_digestAlt = b;
    }

    private DigiDocException validateDigestValue(byte[] data) {
        DigiDocException ex = null;
        if (data != null && data.length != 20) {
            ex = new DigiDocException(33, "SHA1 digest value must be 20 bytes - is: " + data.length, null);
        }
        return ex;
    }

    public int countAttributes() {
        return this.m_attributes == null ? 0 : this.m_attributes.size();
    }

    public void addAttribute(DataFileAttribute attr) {
        if (this.m_attributes == null) {
            this.m_attributes = new ArrayList();
        }
        this.m_attributes.add(attr);
    }

    public DataFileAttribute getAttribute(int idx) {
        return (DataFileAttribute)this.m_attributes.get(idx);
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String s) {
        this.m_comment = s;
    }

    public ArrayList validate(boolean bStrong) {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateContentType(this.m_contentType);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateFileName(this.m_fileName)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateId(this.m_id, bStrong)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateMimeType(this.m_mimeType)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateSize(this.m_size)) != null) {
            errs.add(ex);
        }
        for (int i = 0; i < this.countAttributes(); ++i) {
            DataFileAttribute attr = this.getAttribute(i);
            ArrayList e = attr.validate();
            if (e.isEmpty()) continue;
            errs.addAll(e);
        }
        return errs;
    }

    private byte[] canonicalizeXml(byte[] data) {
        try {
            CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
            byte[] tmp = canFac.canonicalize(data, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            return tmp;
        }
        catch (Exception ex) {
            m_logger.error("Canonicalizing exception: " + ex);
            return null;
        }
    }

    private int calculateAndWriteBase64Block(OutputStream os, MessageDigest digest, byte[] b64leftover, int b64left, byte[] data, int dLen, boolean bLastBlock) throws DigiDocException {
        byte[] b64input = null;
        int nLeft = 0;
        int nInLen = 0;
        StringBuffer b64data = new StringBuffer();
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("os: " + (os != null ? "Y" : "N") + " b64left: " + b64left + " input: " + dLen + " last: " + (bLastBlock ? "Y" : "N"));
        }
        try {
            if (b64left > 0) {
                if (dLen > 0) {
                    b64input = new byte[dLen + b64left];
                    nInLen = b64input.length;
                    System.arraycopy(b64leftover, 0, b64input, 0, b64left);
                    System.arraycopy(data, 0, b64input, b64left, dLen);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("use left: " + b64left + " from 0 and add " + dLen);
                    }
                } else {
                    b64input = b64leftover;
                    nInLen = b64left;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("use left: " + b64left + " with no new data");
                    }
                }
            } else {
                b64input = data;
                nInLen = dLen;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("use: " + nInLen + " from 0");
                }
            }
            int b64Used = Base64Util.encodeToBlock(b64input, nInLen, b64data, bLastBlock);
            nLeft = nInLen - b64Used;
            byte[] encdata = b64data.toString().getBytes();
            if (os != null) {
                os.write(encdata);
            }
            digest.update(encdata);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("Leaving: " + nLeft + " of: " + b64input.length);
            }
            if (nLeft > 0) {
                System.arraycopy(b64input, b64input.length - nLeft, b64leftover, 0, nLeft);
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("left: " + nLeft + " bytes for the next run");
        }
        return nLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateFileSizeAndDigest(OutputStream os) throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("calculateFileSizeAndDigest(" + this.getId() + ") body: " + (this.m_body != null ? "OK" : "NULL") + " base64: " + this.m_bodyIsBase64 + " DF cache: " + (this.m_fDfCache != null ? this.m_fDfCache.getAbsolutePath() : "NULL"));
        }
        FileInputStream fis = null;
        if (this.m_contentType.equals(CONTENT_BINARY)) {
            InputStream is = null;
            try {
                if (this.getDfCacheFile() != null) {
                    is = this.getBodyAsStream();
                } else if (is == null && this.m_body != null) {
                    is = new ByteArrayInputStream(this.m_body);
                } else if (is == null && this.m_fileName != null) {
                    is = new FileInputStream(this.m_fileName);
                }
                if (is != null) {
                    this.calcHashes(is);
                }
            }
            catch (FileNotFoundException ex) {
                throw new DigiDocException(10, "Cannot read file: " + this.m_fileName, null);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    m_logger.error("Error closing stream: " + ex);
                }
            }
            return;
        }
        MessageDigest sha = null;
        boolean bUse64ByteLines = true;
        String use64Flag = ConfigManager.instance().getProperty("DATAFILE_USE_64BYTE_LINES");
        if (use64Flag != null && use64Flag.equalsIgnoreCase("FALSE")) {
            bUse64ByteLines = false;
        }
        try {
            sha = MessageDigest.getInstance("SHA-1");
            if (this.m_origDigestValue != null && this.m_body != null && os != null) {
                os.write(this.xmlHeader());
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("write df header1: " + this.xmlHeader());
                }
                os.write(this.m_body);
                os.write(this.xmlTrailer());
                return;
            }
            String longFileName = this.m_fileName;
            File fIn = new File(this.m_fileName);
            this.m_fileName = fIn.getName();
            if (fIn.canRead() && this.m_fDfCache == null) {
                fis = new FileInputStream(longFileName);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Read file: " + longFileName);
                }
            } else if (this.m_fDfCache != null) {
                fis = new FileInputStream(this.m_fDfCache);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Read cache: " + this.m_fDfCache);
                }
            }
            byte[] tmp1 = null;
            byte[] tmp2 = null;
            byte[] tmp3 = null;
            ByteArrayOutputStream sbDig = new ByteArrayOutputStream();
            sbDig.write(this.xmlHeader());
            tmp3 = this.xmlTrailer();
            sbDig.write(tmp3);
            tmp1 = this.canonicalizeXml(sbDig.toByteArray());
            if (tmp1 != null) {
                tmp2 = new byte[tmp1.length - tmp3.length];
                System.arraycopy(tmp1, 0, tmp2, 0, tmp2.length);
                sha.update(tmp2);
                if (os != null) {
                    os.write(this.xmlHeader());
                }
            }
            sbDig = new ByteArrayOutputStream();
            tmp3 = null;
            tmp2 = null;
            tmp1 = null;
            if (this.m_body == null) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Reading input file: " + (fIn.canRead() && this.m_fDfCache == null ? longFileName : (this.m_fDfCache != null ? this.m_fDfCache.getAbsolutePath() : "no-cache")));
                }
                byte[] buf = new byte[block_size];
                byte[] b64leftover = null;
                int fRead = 0;
                int b64left = 0;
                ByteArrayOutputStream content = null;
                if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64) && this.m_fDfCache == null) {
                    if (bUse64ByteLines) {
                        b64leftover = new byte[65];
                    } else {
                        content = new ByteArrayOutputStream();
                    }
                }
                while ((fRead = fis.read(buf)) > 0 || b64left > 0) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("read: " + fRead + " bytes of input data");
                    }
                    if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                        if (this.m_fDfCache != null) {
                            if (os != null) {
                                os.write(buf, 0, fRead);
                            }
                            sha.update(buf, 0, fRead);
                        } else if (bUse64ByteLines) {
                            b64left = this.calculateAndWriteBase64Block(os, sha, b64leftover, b64left, buf, fRead, fRead < block_size);
                        } else {
                            content.write(buf, 0, fRead);
                        }
                    } else {
                        if (fRead < buf.length) {
                            tmp2 = new byte[fRead];
                            System.arraycopy(buf, 0, tmp2, 0, fRead);
                            tmp1 = ConvertUtils.data2utf8(tmp2, this.m_codepage);
                        } else {
                            tmp1 = ConvertUtils.data2utf8(buf, this.m_codepage);
                        }
                        sbDig.write(tmp1);
                    }
                    if (!m_logger.isDebugEnabled()) continue;
                    m_logger.debug("End using block: " + fRead + " in: " + (fis != null ? fis.available() : 0));
                }
                if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                    if (!bUse64ByteLines && this.m_fDfCache == null) {
                        sbDig.write(Base64Util.encode(content.toByteArray(), 0).getBytes());
                    }
                    content = null;
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("End reading content");
                }
            } else {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Using mem content, len: " + (this.m_body != null ? this.m_body.length : 0) + " b64: " + this.m_bodyIsBase64);
                }
                if (this.m_body != null) {
                    if (bUse64ByteLines && this.m_contentType.equals(CONTENT_EMBEDDED_BASE64) && !this.m_bodyIsBase64) {
                        this.calculateAndWriteBase64Block(os, sha, null, 0, this.m_body, this.m_body.length, true);
                        this.m_body = Base64Util.encode(this.m_body).getBytes();
                    } else {
                        tmp1 = this.m_contentType.equals(CONTENT_EMBEDDED_BASE64) && !this.m_bodyIsBase64 ? Base64Util.encode(this.m_body).getBytes() : (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64) && this.m_bodyIsBase64 ? ConvertUtils.data2utf8(this.m_body, this.m_codepage) : ConvertUtils.data2utf8(this.m_body, this.m_codepage));
                        sbDig.write(tmp1);
                    }
                }
            }
            tmp1 = null;
            if (this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                if (!bUse64ByteLines && this.m_fDfCache == null) {
                    tmp2 = sbDig.toByteArray();
                    if (tmp2 != null && tmp2.length > 0) {
                        sha.update(tmp2);
                        if (os != null) {
                            os.write(tmp2);
                        }
                    }
                } else if (this.m_body != null && sbDig.size() > 0 && (tmp2 = sbDig.toByteArray()) != null && tmp2.length > 0) {
                    sha.update(tmp2);
                    if (os != null) {
                        os.write(tmp2);
                    }
                }
            } else {
                tmp2 = sbDig.toByteArray();
                if (tmp2 != null && tmp2.length > 0) {
                    if (tmp2[0] == 60) {
                        tmp2 = this.canonicalizeXml(tmp2);
                    }
                    if (tmp2 != null && tmp2.length > 0) {
                        sha.update(tmp2);
                        if (os != null) {
                            os.write(tmp2);
                        }
                    }
                }
            }
            tmp2 = null;
            sbDig = null;
            tmp1 = this.xmlTrailer();
            sha.update(tmp1);
            if (os != null) {
                os.write(tmp1);
            }
            byte[] digest = sha.digest();
            this.setDigest(digest);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("DataFile: '" + this.getId() + "' length: " + this.getSize() + " digest: " + Base64Util.encode(digest));
            }
            this.m_fileName = longFileName;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                m_logger.error("Error closing file: " + ex);
            }
        }
    }

    public void writeToFile(OutputStream fos) throws DigiDocException {
        try {
            this.calculateFileSizeAndDigest(fos);
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
    }

    private byte[] xmlHeader() throws DigiDocException {
        StringBuffer sb = new StringBuffer("<DataFile");
        if (this.m_codepage != null && !this.m_codepage.equals("UTF-8")) {
            sb.append(" Codepage=\"");
            sb.append(this.m_codepage);
            sb.append("\"");
        }
        sb.append(" ContentType=\"");
        sb.append(this.m_contentType);
        sb.append("\" Filename=\"");
        String fileName = new File(this.m_fileName).getName();
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("DF fname: " + ConvertUtils.escapeXmlSymbols(fileName));
        }
        sb.append(ConvertUtils.escapeXmlSymbols(fileName));
        sb.append("\" Id=\"");
        sb.append(this.m_id);
        sb.append("\" MimeType=\"");
        sb.append(this.m_mimeType);
        sb.append("\" Size=\"");
        sb.append(new Long(this.m_size).toString());
        sb.append("\"");
        if (this.m_digestSha1 != null && this.getDigestType() != null) {
            sb.append(" DigestType=\"");
            if ("SHA-1".equalsIgnoreCase(this.getDigestType())) {
                sb.append(DIGEST_TYPE_SHA1);
            } else {
                sb.append(this.getDigestType());
            }
            sb.append("\" DigestValue=\"");
            sb.append(Base64Util.encode(this.m_digestSha1, 0));
            sb.append("\"");
        }
        for (int i = 0; i < this.countAttributes(); ++i) {
            DataFileAttribute attr = this.getAttribute(i);
            sb.append(" ");
            sb.append(attr.toXML());
        }
        if (this.m_sigDoc != null && this.m_sigDoc.getVersion().equals("1.3")) {
            sb.append(" xmlns=\"");
            sb.append(SignedDoc.xmlns_digidoc13);
            sb.append("\"");
        }
        sb.append(">");
        return ConvertUtils.str2data(sb.toString(), "UTF-8");
    }

    private byte[] xmlTrailer() throws DigiDocException {
        return ConvertUtils.str2data("</DataFile>", "UTF-8");
    }

    public byte[] toXML() throws DigiDocException {
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        try {
            sb.write(this.xmlHeader());
            if (this.m_body != null && this.m_contentType.equals(CONTENT_EMBEDDED_BASE64)) {
                sb.write(this.m_body);
            }
            sb.write(this.xmlTrailer());
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 74);
        }
        return sb.toByteArray();
    }

    public String toString() {
        String str = null;
        try {
            str = new String(this.toXML(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

