/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature.asice;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.asic.signature.asice.AbstractManifestBuilder;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESArchiveManifestBuilder
extends AbstractManifestBuilder {
    private final List<DSSDocument> signatures;
    private final List<DSSDocument> documents;
    private final List<DSSDocument> manifests;
    private final DigestAlgorithm digestAlgorithm;
    private final String timestampUri;

    public ASiCEWithCAdESArchiveManifestBuilder(List<DSSDocument> signatures, List<DSSDocument> documents, List<DSSDocument> manifests, DigestAlgorithm digestAlgorithm, String timestampUri) {
        this.signatures = signatures;
        this.documents = documents;
        this.manifests = manifests;
        this.digestAlgorithm = digestAlgorithm;
        this.timestampUri = timestampUri;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = documentDom.createElementNS("http://uri.etsi.org/02918/v1.2.1#", "asic:ASiCManifest");
        documentDom.appendChild(asicManifestDom);
        this.addSigReference(documentDom, asicManifestDom, this.timestampUri, MimeType.TST);
        for (DSSDocument signature : this.signatures) {
            this.addDataObjectReference(documentDom, asicManifestDom, signature, this.digestAlgorithm);
        }
        for (DSSDocument document : this.documents) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        for (DSSDocument manifest : this.manifests) {
            this.addDataObjectReference(documentDom, asicManifestDom, manifest, this.digestAlgorithm);
        }
        return documentDom;
    }
}

