/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature.asice;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.asic.signature.asice.AbstractManifestBuilder;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESManifestBuilder
extends AbstractManifestBuilder {
    private final List<DSSDocument> documents;
    private final DigestAlgorithm digestAlgorithm;
    private final String signatureUri;

    public ASiCEWithCAdESManifestBuilder(List<DSSDocument> documents, DigestAlgorithm digestAlgorithm, String signatureUri) {
        this.documents = documents;
        this.digestAlgorithm = digestAlgorithm;
        this.signatureUri = signatureUri;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = documentDom.createElementNS("http://uri.etsi.org/02918/v1.2.1#", "asic:ASiCManifest");
        documentDom.appendChild(asicManifestDom);
        this.addSigReference(documentDom, asicManifestDom, this.signatureUri, MimeType.PKCS7);
        for (DSSDocument document : this.documents) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        return documentDom;
    }
}

