/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature.asice;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.MimeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractManifestBuilder {
    protected void addSigReference(Document documentDom, Element asicManifestDom, String uri, MimeType mimeType) {
        Element sigReferenceDom = DomUtils.addElement((Document)documentDom, (Element)asicManifestDom, (String)"http://uri.etsi.org/02918/v1.2.1#", (String)"asic:SigReference");
        sigReferenceDom.setAttribute("URI", uri);
        sigReferenceDom.setAttribute("MimeType", mimeType.getMimeTypeString());
    }

    protected void addDataObjectReference(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceDom = DomUtils.addElement((Document)documentDom, (Element)asicManifestDom, (String)"http://uri.etsi.org/02918/v1.2.1#", (String)"asic:DataObjectReference");
        dataObjectReferenceDom.setAttribute("URI", document.getName());
        MimeType mimeType = document.getMimeType();
        if (mimeType != null) {
            dataObjectReferenceDom.setAttribute("MimeType", mimeType.getMimeTypeString());
        }
        Element digestMethodDom = DomUtils.addElement((Document)documentDom, (Element)dataObjectReferenceDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"DigestMethod");
        digestMethodDom.setAttribute("Algorithm", digestAlgorithm.getXmlId());
        Element digestValueDom = DomUtils.addElement((Document)documentDom, (Element)dataObjectReferenceDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"DigestValue");
        Text textNode = documentDom.createTextNode(document.getDigest(digestAlgorithm));
        digestValueDom.appendChild(textNode);
    }
}

