/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.validation;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.validation.ASiCEWithCAdESManifestParser;
import eu.europa.esig.dss.asic.validation.ASiCEWithCAdESManifestValidator;
import eu.europa.esig.dss.asic.validation.ASiCEWithCAdESTimestampValidator;
import eu.europa.esig.dss.asic.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.asic.validation.CMSDocumentForASiCValidator;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.TimestampType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCContainerWithCAdESValidator
extends AbstractASiCContainerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCContainerWithCAdESValidator.class);

    private ASiCContainerWithCAdESValidator() {
        super(null);
    }

    public ASiCContainerWithCAdESValidator(DSSDocument asicContainer) {
        super(asicContainer);
        this.analyseEntries();
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return ASiCUtils.isASiCContainer((DSSDocument)dssDocument) && ASiCUtils.isArchiveContainsCorrectSignatureExtension((DSSDocument)dssDocument, (String)".p7s");
    }

    AbstractASiCContainerExtractor getArchiveExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.document);
    }

    List<DocumentValidator> getValidators() {
        if (this.validators == null) {
            this.validators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                CMSDocumentForASiCValidator cadesValidator = new CMSDocumentForASiCValidator(signature);
                cadesValidator.setCertificateVerifier(this.certificateVerifier);
                cadesValidator.setProcessExecutor(this.processExecutor);
                cadesValidator.setSignaturePolicyProvider(this.signaturePolicyProvider);
                cadesValidator.setValidationCertPool(this.validationCertPool);
                cadesValidator.setDetachedContents(this.getSignedDocuments(signature));
                this.validators.add(cadesValidator);
            }
        }
        return this.validators;
    }

    protected void attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        ASiCContainerType type = this.getContainerType();
        if (ASiCContainerType.ASiC_E == type) {
            List<ASiCEWithCAdESTimestampValidator> currentTimestampValidators = this.getTimestampValidators();
            for (ASiCEWithCAdESTimestampValidator tspValidator : currentTimestampValidators) {
                List<String> coveredFilenames = tspValidator.getCoveredFilenames();
                TimestampToken timestamp = tspValidator.getTimestamp();
                if (!timestamp.isSignatureValid()) continue;
                for (AdvancedSignature advancedSignature : allSignatures) {
                    if (!coveredFilenames.contains(advancedSignature.getSignatureFilename())) continue;
                    CAdESSignature cadesSig = (CAdESSignature)advancedSignature;
                    ArrayList cadesTimestamps = new ArrayList();
                    cadesTimestamps.addAll(cadesSig.getContentTimestamps());
                    cadesTimestamps.addAll(cadesSig.getSignatureTimestamps());
                    cadesTimestamps.addAll(cadesSig.getTimestampsX1());
                    cadesTimestamps.addAll(cadesSig.getTimestampsX2());
                    timestamp.setTimestampedReferences(cadesSig.getTimestampReferencesForArchiveTimestamp(cadesTimestamps));
                    advancedSignature.addExternalTimestamp(timestamp);
                }
            }
        }
    }

    private List<ASiCEWithCAdESTimestampValidator> getTimestampValidators() {
        ArrayList<ASiCEWithCAdESTimestampValidator> timestampValidators = new ArrayList<ASiCEWithCAdESTimestampValidator>();
        for (DSSDocument timestamp : this.getTimestampDocuments()) {
            DSSDocument archiveManifest = this.getTimestampedArchiveManifest(timestamp);
            if (archiveManifest != null) {
                ASiCEWithCAdESManifestParser parser = new ASiCEWithCAdESManifestParser(archiveManifest);
                ManifestFile manifestContent = parser.getDescription();
                ASiCEWithCAdESTimestampValidator timestampValidator = new ASiCEWithCAdESTimestampValidator(timestamp, TimestampType.ARCHIVE_TIMESTAMP, manifestContent.getEntries());
                timestampValidator.setCertificateVerifier(this.certificateVerifier);
                timestampValidator.setTimestampedData(archiveManifest);
                timestampValidators.add(timestampValidator);
                continue;
            }
            LOG.warn("Timestamp " + timestamp.getName() + " is skipped (no linked archive manifest found)");
        }
        return timestampValidators;
    }

    private List<DSSDocument> getSignedDocuments(DSSDocument signature) {
        ASiCContainerType type = this.getContainerType();
        if (ASiCContainerType.ASiC_S == type) {
            return this.getSignedDocuments();
        }
        if (ASiCContainerType.ASiC_E == type) {
            ASiCEWithCAdESManifestValidator manifestValidator = new ASiCEWithCAdESManifestValidator(signature, this.getManifestDocuments(), this.getSignedDocuments());
            DSSDocument linkedManifest = manifestValidator.getLinkedManifest();
            if (linkedManifest != null) {
                return Arrays.asList(linkedManifest);
            }
            return Collections.emptyList();
        }
        LOG.warn("Unknown asic container type (returns all signed documents)");
        return this.getSignedDocuments();
    }

    private DSSDocument getTimestampedArchiveManifest(DSSDocument timestamp) {
        ArrayList<DSSDocument> signedDocs = new ArrayList<DSSDocument>();
        signedDocs.addAll(this.getSignedDocuments());
        signedDocs.addAll(this.getManifestDocuments());
        signedDocs.addAll(this.getSignatureDocuments());
        ASiCEWithCAdESManifestValidator manifestValidator = new ASiCEWithCAdESManifestValidator(timestamp, this.getArchiveManifestDocuments(), signedDocs);
        return manifestValidator.getLinkedManifest();
    }

    protected List<ManifestFile> getManifestFilesDecriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List manifestDocuments = this.getManifestDocuments();
        for (DSSDocument manifestDocument : manifestDocuments) {
            ASiCEWithCAdESManifestParser parser = new ASiCEWithCAdESManifestParser(manifestDocument);
            descriptions.add(parser.getDescription());
        }
        List archiveManifestDocuments = this.getArchiveManifestDocuments();
        for (DSSDocument manifestDocument : archiveManifestDocuments) {
            ASiCEWithCAdESManifestParser parser = new ASiCEWithCAdESManifestParser(manifestDocument);
            descriptions.add(parser.getDescription());
        }
        return descriptions;
    }
}

