/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.DataToSignASiCEWithCAdESFromArchive;
import eu.europa.esig.dss.asic.cades.signature.asice.DataToSignASiCEWithCAdESFromFiles;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromArchive;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromFiles;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCDataToSignHelperBuilder;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ASiCWithCAdESDataToSignHelperBuilder
extends AbstractASiCDataToSignHelperBuilder {
    public GetDataToSignASiCWithCAdESHelper build(SigningOperation operation, List<DSSDocument> documents, ASiCWithCAdESCommonParameters parameters) {
        List filenames;
        DSSDocument archiveDocument;
        if (Utils.isCollectionNotEmpty(documents) && documents.size() == 1 && ASiCUtils.isZip((DSSDocument)(archiveDocument = documents.get(0))) && ASiCUtils.isAsicFileContent((List)(filenames = ZipUtils.getInstance().extractEntryNames(archiveDocument)))) {
            return this.fromZipArchive(operation, archiveDocument, parameters);
        }
        return this.fromFiles(operation, documents, parameters);
    }

    private GetDataToSignASiCWithCAdESHelper fromZipArchive(SigningOperation operation, DSSDocument archiveDoc, ASiCWithCAdESCommonParameters parameters) {
        ASiCWithCAdESContainerExtractor extractor = new ASiCWithCAdESContainerExtractor(archiveDoc);
        ASiCExtractResult result = extractor.extract();
        ASiCWithCAdESDataToSignHelperBuilder.assertContainerTypeValid(result);
        if (Utils.isCollectionNotEmpty((Collection)result.getSignatureDocuments()) || Utils.isCollectionNotEmpty((Collection)result.getTimestampDocuments())) {
            ASiCContainerType currentContainerType = ASiCUtils.getContainerType((DSSDocument)archiveDoc, (DSSDocument)result.getMimeTypeDocument(), (String)result.getZipComment(), (List)result.getSignedDocuments());
            boolean asice = ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC());
            if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                return new DataToSignASiCEWithCAdESFromArchive(operation, result, parameters);
            }
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                return new DataToSignASiCSWithCAdESFromArchive(result, parameters.aSiC());
            }
            throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", currentContainerType, parameters.aSiC().getContainerType()));
        }
        return this.fromFiles(operation, Arrays.asList(archiveDoc), parameters);
    }

    private GetDataToSignASiCWithCAdESHelper fromFiles(SigningOperation operation, List<DSSDocument> documents, ASiCWithCAdESCommonParameters parameters) {
        this.assertDocumentNamesDefined(documents);
        if (ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC())) {
            return new DataToSignASiCEWithCAdESFromFiles(operation, documents, parameters);
        }
        return new DataToSignASiCSWithCAdESFromFiles(documents, parameters.getZipCreationDate(), parameters.aSiC());
    }

    private static void assertContainerTypeValid(ASiCExtractResult result) {
        if (ASiCUtils.areFilesContainSignatures((List)DSSUtils.getDocumentNames((List)result.getAllDocuments())) && Utils.isCollectionEmpty((Collection)result.getSignatureDocuments())) {
            throw new UnsupportedOperationException("Container type doesn't match");
        }
    }
}

