/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractDataToSignASiCEWithCAdES {
    private static final String ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE = "META-INF/signature001.p7s";
    private static final String ZIP_ENTRY_ASICE_METAINF_TIMESTAMP = "META-INF/timestamp001.tst";
    private final SigningOperation operation;
    private final ASiCWithCAdESCommonParameters parameters;

    protected AbstractDataToSignASiCEWithCAdES(SigningOperation operation, ASiCWithCAdESCommonParameters parameters) {
        this.operation = operation;
        this.parameters = parameters;
    }

    protected DSSDocument getASiCManifest(List<DSSDocument> documents, List<DSSDocument> signatures, List<DSSDocument> timestamps, List<DSSDocument> manifests) {
        String uri = null;
        uri = SigningOperation.SIGN == this.operation ? this.getSignatureFileName(signatures) : this.getTimestampFileName(timestamps);
        ASiCEWithCAdESManifestBuilder manifestBuilder = new ASiCEWithCAdESManifestBuilder(this.operation, documents, this.parameters.getDigestAlgorithm(), uri);
        String newManifestName = ASiCUtils.getNextASiCEManifestName((String)"ASiCManifest", manifests);
        return DomUtils.createDssDocumentFromDomDocument((Document)manifestBuilder.build(), (String)newManifestName);
    }

    protected String getSignatureFileName(List<DSSDocument> existingSignatures) {
        if (Utils.isStringNotBlank((String)this.parameters.aSiC().getSignatureFileName())) {
            return "META-INF/" + this.parameters.aSiC().getSignatureFileName();
        }
        int num = Utils.collectionSize(existingSignatures) + 1;
        return ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE.replace("001", ASiCUtils.getPadNumber((int)num));
    }

    protected String getTimestampFileName(List<DSSDocument> existingTimestamps) {
        int num = Utils.collectionSize(existingTimestamps) + 1;
        return ZIP_ENTRY_ASICE_METAINF_TIMESTAMP.replace("001", ASiCUtils.getPadNumber((int)num));
    }
}

