/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESSignatureExtension;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESArchiveManifestBuilder;
import eu.europa.esig.dss.asic.cades.validation.ASiCContainerWithCAdESValidator;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CMSSignedDataBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;

public class ASiCWithCAdESLevelBaselineLTA
extends ASiCWithCAdESSignatureExtension {
    private static final long serialVersionUID = 5337864432054920568L;
    private final ASiCWithCAdESFilenameFactory asicFilenameFactory;

    public ASiCWithCAdESLevelBaselineLTA(CertificateVerifier certificateVerifier, TSPSource tspSource) {
        this(certificateVerifier, tspSource, new DefaultASiCWithCAdESFilenameFactory());
    }

    public ASiCWithCAdESLevelBaselineLTA(CertificateVerifier certificateVerifier, TSPSource tspSource, ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        super(certificateVerifier, tspSource);
        this.asicFilenameFactory = asicFilenameFactory;
    }

    @Override
    public ASiCContent extend(ASiCContent asicContent, CAdESSignatureParameters parameters) {
        asicContent = super.extend(asicContent, parameters);
        return this.extend(asicContent, this.getReferenceDigestAlgorithmOrDefault(parameters), parameters.getArchiveTimestampParameters().getDigestAlgorithm());
    }

    public ASiCContent extend(ASiCContent asicContent, DigestAlgorithm digestAlgorithm) {
        asicContent = super.extend(asicContent, this.getEmptyLTLevelSignatureParameters());
        return this.extend(asicContent, digestAlgorithm, digestAlgorithm);
    }

    private ASiCContent extend(ASiCContent asicContent, DigestAlgorithm manifestDigestAlgorithm, DigestAlgorithm tstDigestAlgorithm) {
        List timestampDocuments;
        String timestampFilename = this.asicFilenameFactory.getTimestampFilename(asicContent);
        ManifestFile lastManifestFile = this.getLastManifestFile(asicContent.getAllManifestDocuments());
        DSSDocument lastTimestamp = this.getLastTimestampDocument(lastManifestFile, timestampDocuments = asicContent.getTimestampDocuments());
        if (lastTimestamp != null) {
            ASiCContainerWithCAdESValidator validator = new ASiCContainerWithCAdESValidator(asicContent);
            validator.setCertificateVerifier(this.certificateVerifier);
            List allSignatures = validator.getAllSignatures();
            List detachedTimestamps = validator.getDetachedTimestamps();
            ValidationDataContainer validationDataContainer = validator.getValidationData(allSignatures, detachedTimestamps);
            ValidationData allValidationData = validationDataContainer.getAllValidationData();
            for (AdvancedSignature signature : allSignatures) {
                allValidationData.excludeCertificateTokens((Collection)signature.getCompleteCertificateSource().getCertificates());
                allValidationData.excludeCRLTokens((Collection)signature.getCompleteCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens((Collection)signature.getCompleteOCSPSource().getAllRevocationBinaries());
            }
            for (TimestampToken timestampToken : detachedTimestamps) {
                allValidationData.excludeCertificateTokens((Collection)timestampToken.getCertificateSource().getCertificates());
                allValidationData.excludeCRLTokens((Collection)timestampToken.getCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens((Collection)timestampToken.getOCSPSource().getAllRevocationBinaries());
            }
            DSSDocument extendedTimestamp = this.extendTimestamp(lastTimestamp, allValidationData);
            ASiCUtils.addOrReplaceDocument((List)asicContent.getTimestampDocuments(), (DSSDocument)extendedTimestamp);
        }
        DSSDocument lastArchiveManifest = null;
        if (lastManifestFile != null && this.isLastArchiveManifest(lastManifestFile.getFilename())) {
            lastArchiveManifest = lastManifestFile.getDocument();
            lastArchiveManifest.setName(this.asicFilenameFactory.getArchiveManifestFilename(asicContent));
        }
        ASiCEWithCAdESArchiveManifestBuilder builder = new ASiCEWithCAdESArchiveManifestBuilder(asicContent, lastArchiveManifest, manifestDigestAlgorithm, timestampFilename);
        DSSDocument archiveManifest = builder.build();
        asicContent.getArchiveManifestDocuments().add(archiveManifest);
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(tstDigestAlgorithm, DSSUtils.digest((DigestAlgorithm)tstDigestAlgorithm, (DSSDocument)archiveManifest));
        InMemoryDocument timestamp = new InMemoryDocument(DSSASN1Utils.getDEREncoded((TimestampBinary)timeStampResponse), timestampFilename, (MimeType)MimeTypeEnum.TST);
        asicContent.getTimestampDocuments().add(timestamp);
        return asicContent;
    }

    private ManifestFile getLastManifestFile(List<DSSDocument> manifests) {
        DSSDocument lastManifest = this.getLastArchiveManifest(manifests);
        if (lastManifest == null) {
            lastManifest = DSSUtils.getDocumentWithLastName(manifests);
        }
        if (lastManifest != null) {
            return ASiCManifestParser.getManifestFile((DSSDocument)lastManifest);
        }
        return null;
    }

    private DSSDocument getLastArchiveManifest(List<DSSDocument> manifests) {
        if (Utils.isCollectionNotEmpty(manifests)) {
            for (DSSDocument manifest : manifests) {
                if (!this.isLastArchiveManifest(manifest.getName())) continue;
                return manifest;
            }
        }
        return null;
    }

    private boolean isLastArchiveManifest(String fileName) {
        return "META-INF/ASiCArchiveManifest.xml".equals(fileName);
    }

    private DSSDocument getLastTimestampDocument(ManifestFile lastManifestFile, List<DSSDocument> timestamps) {
        if (lastManifestFile != null) {
            return DSSUtils.getDocumentWithName(timestamps, (String)lastManifestFile.getSignatureFilename());
        }
        return DSSUtils.getDocumentWithLastName(timestamps);
    }

    private DSSDocument extendTimestamp(DSSDocument archiveTimestamp, ValidationData validationDataForInclusion) {
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)archiveTimestamp);
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder().setOriginalCMSSignedData(cmsSignedData);
        CMSSignedData extendedCMSSignedData = cmsSignedDataBuilder.extendCMSSignedData((Collection)validationDataForInclusion.getCertificateTokens(), (Collection)validationDataForInclusion.getCrlTokens(), (Collection)validationDataForInclusion.getOcspTokens());
        return new InMemoryDocument(DSSASN1Utils.getEncoded((CMSSignedData)extendedCMSSignedData), archiveTimestamp.getName(), (MimeType)MimeTypeEnum.TST);
    }

    private CAdESSignatureParameters getEmptyLTLevelSignatureParameters() {
        CAdESSignatureParameters parameters = new CAdESSignatureParameters();
        parameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        return parameters;
    }

    @Override
    protected boolean extensionRequired(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        return !coveredByManifest;
    }

    @Override
    protected void assertExtendSignaturePossible(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        if (coveredByManifest) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already covered by an archive manifest.", parameters.getSignatureLevel()));
        }
    }
}

