/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.asic.manifest.definition.ASiCManifestAttribute;
import eu.europa.esig.asic.manifest.definition.ASiCManifestElement;
import eu.europa.esig.asic.manifest.definition.ASiCManifestNamespace;
import eu.europa.esig.dss.asic.cades.signature.manifest.AbstractManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESArchiveManifestBuilder
extends AbstractManifestBuilder {
    private final ASiCContent asicContent;
    private final DSSDocument lastArchiveManifest;
    private final DigestAlgorithm digestAlgorithm;
    private final String timestampFileUri;

    public ASiCEWithCAdESArchiveManifestBuilder(ASiCContent asicContent, DSSDocument lastArchiveManifest, DigestAlgorithm digestAlgorithm, String timestampFileUri) {
        this.asicContent = asicContent;
        this.lastArchiveManifest = lastArchiveManifest;
        this.digestAlgorithm = digestAlgorithm;
        this.timestampFileUri = timestampFileUri;
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)ASiCManifestNamespace.NS, (DSSElement)ASiCManifestElement.ASIC_MANIFEST);
        documentDom.appendChild(asicManifestDom);
        this.addSigReference(documentDom, asicManifestDom, this.timestampFileUri, (MimeType)MimeTypeEnum.TST);
        for (DSSDocument signature : this.asicContent.getSignatureDocuments()) {
            this.addDataObjectReference(documentDom, asicManifestDom, signature, this.digestAlgorithm);
        }
        for (DSSDocument timestamp : this.asicContent.getTimestampDocuments()) {
            this.addDataObjectReference(documentDom, asicManifestDom, timestamp, this.digestAlgorithm);
        }
        for (DSSDocument manifest : this.asicContent.getAllManifestDocuments()) {
            if (this.lastArchiveManifest == manifest) {
                this.addDataObjectReferenceForRootArchiveManifest(documentDom, asicManifestDom, this.lastArchiveManifest, this.digestAlgorithm);
                continue;
            }
            this.addDataObjectReference(documentDom, asicManifestDom, manifest, this.digestAlgorithm);
        }
        for (DSSDocument document : this.asicContent.getSignedDocuments()) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        return DomUtils.createDssDocumentFromDomDocument((Document)documentDom, (String)"META-INF/ASiCArchiveManifest.xml");
    }

    private Element addDataObjectReferenceForRootArchiveManifest(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceElement = this.addDataObjectReference(documentDom, asicManifestDom, document, digestAlgorithm);
        dataObjectReferenceElement.setAttribute(ASiCManifestAttribute.ROOTFILE.getAttributeName(), "true");
        return dataObjectReferenceElement;
    }
}

