/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESTimestampValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestValidator;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampSource;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampValidatorComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCContainerWithCAdESValidator
extends AbstractASiCContainerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCContainerWithCAdESValidator.class);

    ASiCContainerWithCAdESValidator() {
    }

    public ASiCContainerWithCAdESValidator(DSSDocument asicContainer) {
        super(asicContainer);
    }

    public ASiCContainerWithCAdESValidator(ASiCContent asicContent) {
        super(asicContent);
    }

    public boolean isSupported(DSSDocument dssDocument) {
        if (ASiCUtils.isZip((DSSDocument)dssDocument)) {
            List filenames = ZipUtils.getInstance().extractEntryNames(dssDocument);
            if (ASiCUtils.isASiCWithCAdES((List)filenames)) {
                return true;
            }
            return !ASiCUtils.isASiCWithXAdES((List)filenames) && (!ASiCUtils.areFilesContainMimetype((List)filenames) || !ASiCUtils.isContainerOpenDocument((DSSDocument)dssDocument));
        }
        return false;
    }

    public boolean isSupported(ASiCContent asicContent) {
        List entryNames = DSSUtils.getDocumentNames((List)asicContent.getAllDocuments());
        return !ASiCUtils.isASiCWithXAdES((List)entryNames) && (!ASiCUtils.areFilesContainMimetype((List)entryNames) || !ASiCUtils.isOpenDocument((DSSDocument)asicContent.getMimeTypeDocument()));
    }

    protected AbstractASiCContainerExtractor getContainerExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.document);
    }

    protected List<DocumentValidator> getSignatureValidators() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                DSSDocument signatureManifest;
                CMSDocumentValidator cadesValidator = new CMSDocumentValidator(signature);
                cadesValidator.setCertificateVerifier(this.certificateVerifier);
                cadesValidator.setProcessExecutor(this.processExecutor);
                cadesValidator.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                cadesValidator.setContainerContents(this.getArchiveDocuments());
                DSSDocument signedDocument = ASiCWithCAdESUtils.getSignedDocument(this.asicContent, signature.getName());
                if (signedDocument != null) {
                    cadesValidator.setDetachedContents(Collections.singletonList(signedDocument));
                }
                if ((signatureManifest = ASiCManifestParser.getLinkedManifest((List)this.getAllManifestDocuments(), (String)signature.getName())) != null) {
                    ManifestFile manifestFile = this.getValidatedManifestFile(signatureManifest);
                    cadesValidator.setManifestFile(manifestFile);
                }
                this.signatureValidators.add(cadesValidator);
            }
        }
        return this.signatureValidators;
    }

    protected List<DetachedTimestampValidator> getTimestampValidators() {
        if (this.timestampValidators == null) {
            this.timestampValidators = new ArrayList();
            for (DSSDocument timestamp : this.getTimestampDocuments()) {
                ASiCWithCAdESTimestampValidator timestampValidator = this.getTimestampValidator(timestamp);
                if (timestampValidator == null) continue;
                this.timestampValidators.add(timestampValidator);
            }
            this.timestampValidators.sort(new TimestampValidatorComparator());
        }
        return this.timestampValidators;
    }

    private ASiCWithCAdESTimestampValidator getTimestampValidator(DSSDocument timestampDocument) {
        DSSDocument timestampedDocument;
        ManifestFile manifestFile = null;
        ArchiveTimestampType archiveTimestampType = null;
        DSSDocument archiveManifest = ASiCManifestParser.getLinkedManifest((List)this.getAllManifestDocuments(), (String)timestampDocument.getName());
        if (archiveManifest != null) {
            timestampedDocument = archiveManifest;
            manifestFile = this.getValidatedManifestFile(archiveManifest);
            if (manifestFile != null) {
                archiveTimestampType = this.isArchiveTimeStamp(manifestFile) ? ArchiveTimestampType.CAdES_DETACHED : null;
            } else {
                LOG.warn("A linked manifest is not found for a timestamp with name [{}]!", (Object)archiveManifest.getName());
            }
        } else {
            List rootLevelSignedDocuments = ASiCUtils.getRootLevelSignedDocuments((ASiCContent)this.asicContent);
            if (Utils.collectionSize((Collection)rootLevelSignedDocuments) == 1) {
                timestampedDocument = (DSSDocument)rootLevelSignedDocuments.get(0);
            } else {
                LOG.warn("Timestamp {} is skipped (no linked archive manifest found / unique file)", (Object)timestampDocument.getName());
                return null;
            }
        }
        ASiCWithCAdESTimestampValidator timestampValidator = new ASiCWithCAdESTimestampValidator(timestampDocument, TimestampType.CONTAINER_TIMESTAMP);
        timestampValidator.setTimestampedData(timestampedDocument);
        timestampValidator.setManifestFile(manifestFile);
        timestampValidator.setArchiveTimestampType(archiveTimestampType);
        timestampValidator.setOriginalDocuments(this.getAllDocuments());
        timestampValidator.setArchiveDocuments(this.getArchiveDocuments());
        timestampValidator.setCertificateVerifier(this.certificateVerifier);
        return timestampValidator;
    }

    protected List<TimestampToken> buildDetachedTimestamps() {
        DetachedTimestampSource detachedTimestampSource = new DetachedTimestampSource();
        for (DetachedTimestampValidator timestampValidator : this.getTimestampValidators()) {
            detachedTimestampSource.addExternalTimestamp(timestampValidator.getTimestamp());
        }
        return detachedTimestampSource.getDetachedTimestamps();
    }

    public List<DSSDocument> getArchiveDocuments() {
        List archiveContents = super.getArchiveDocuments();
        if (Utils.isCollectionNotEmpty((Collection)this.getManifestDocuments())) {
            for (DSSDocument document : this.getAllDocuments()) {
                if (archiveContents.contains(document)) continue;
                archiveContents.add(document);
            }
        }
        return archiveContents;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        ArrayList<TimestampToken> externalTimestamps = new ArrayList<TimestampToken>();
        List<DetachedTimestampValidator> currentTimestampValidators = this.getTimestampValidators();
        for (DetachedTimestampValidator tspValidator : currentTimestampValidators) {
            TimestampToken timestamp = this.getExternalTimestamp((TimestampValidator)tspValidator, allSignatures);
            if (timestamp == null) continue;
            externalTimestamps.add(timestamp);
        }
        return externalTimestamps;
    }

    private TimestampToken getExternalTimestamp(TimestampValidator tspValidator, List<AdvancedSignature> allSignatures) {
        if (tspValidator instanceof ASiCWithCAdESTimestampValidator) {
            ManifestFile coveredManifest;
            ASiCWithCAdESTimestampValidator timestampValidator = (ASiCWithCAdESTimestampValidator)tspValidator;
            TimestampToken timestamp = timestampValidator.getTimestamp();
            if (timestamp.getTimeStampType().isContainerTimestamp() && (coveredManifest = timestampValidator.getCoveredManifest()) != null) {
                for (ManifestEntry entry : coveredManifest.getEntries()) {
                    CAdESSignature cadesSignature = this.getCAdESSignatureFromFileName(allSignatures, entry.getFileName());
                    if (cadesSignature == null) continue;
                    cadesSignature.addExternalTimestamp(timestamp);
                }
            }
            return timestamp;
        }
        return null;
    }

    private CAdESSignature getCAdESSignatureFromFileName(List<AdvancedSignature> signatures, String fileName) {
        for (AdvancedSignature advancedSignature : signatures) {
            if (!Utils.areStringsEqual((String)fileName, (String)advancedSignature.getSignatureFilename()) || advancedSignature.isCounterSignature()) continue;
            return (CAdESSignature)advancedSignature;
        }
        return null;
    }

    private boolean isArchiveTimeStamp(ManifestFile manifestFile) {
        return ASiCUtils.coversSignature((ManifestFile)manifestFile);
    }

    protected List<ManifestFile> getManifestFilesDescriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List manifestDocuments = this.getManifestDocuments();
        for (Object manifestDocument : manifestDocuments) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile((DSSDocument)manifestDocument);
            if (manifestFile == null) continue;
            ASiCManifestValidator asiceWithCAdESManifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List archiveManifestDocuments = this.getArchiveManifestDocuments();
        for (DSSDocument manifestDocument : archiveManifestDocuments) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile((DSSDocument)manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setManifestType(ASiCManifestTypeEnum.ARCHIVE_MANIFEST);
            ASiCManifestValidator asiceWithCAdESManifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List evidenceRecordManifestDocuments = this.getEvidenceRecordManifestDocuments();
        for (DSSDocument manifestDocument : evidenceRecordManifestDocuments) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile((DSSDocument)manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setManifestType(ASiCManifestTypeEnum.EVIDENCE_RECORD);
            ASiCManifestValidator asiceWithCAdESManifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        if (advancedSignature.isCounterSignature()) {
            CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
            return Collections.singletonList(cadesSignature.getOriginalDocument());
        }
        List retrievedDocs = advancedSignature.getDetachedContents();
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        DSSDocument linkedManifest = ASiCManifestParser.getLinkedManifest((List)this.getManifestDocuments(), (String)advancedSignature.getSignatureFilename());
        if (linkedManifest == null) {
            return Collections.emptyList();
        }
        ManifestFile manifestFile = ASiCManifestParser.getManifestFile((DSSDocument)linkedManifest);
        if (manifestFile == null) {
            return Collections.emptyList();
        }
        return this.getManifestedDocuments(manifestFile);
    }

    private List<DSSDocument> getManifestedDocuments(ManifestFile manifestFile) {
        List entries = manifestFile.getEntries();
        List signedDocuments = this.getAllDocuments();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ManifestEntry entry : entries) {
            for (DSSDocument signedDocument : signedDocuments) {
                if (!Utils.areStringsEqual((String)entry.getFileName(), (String)signedDocument.getName())) continue;
                result.add(signedDocument);
            }
        }
        return result;
    }

    protected ASiCWithCAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new ASiCWithCAdESDiagnosticDataBuilder();
    }
}

