/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.validation.scope.ASiCWithCAdESTimestampScopeFinder;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import java.util.List;

public class ASiCWithCAdESTimestampValidator
extends DetachedTimestampValidator {
    private List<DSSDocument> originalDocuments;
    private List<DSSDocument> archiveDocuments;
    private ArchiveTimestampType archiveTimestampType;

    public ASiCWithCAdESTimestampValidator(DSSDocument timestamp) {
        super(timestamp);
    }

    public ASiCWithCAdESTimestampValidator(DSSDocument timestamp, TimestampType type) {
        super(timestamp, type);
    }

    public ManifestFile getCoveredManifest() {
        return this.manifestFile;
    }

    public void setOriginalDocuments(List<DSSDocument> originalDocuments) {
        this.originalDocuments = originalDocuments;
    }

    public void setArchiveDocuments(List<DSSDocument> archiveDocuments) {
        this.archiveDocuments = archiveDocuments;
    }

    public void setArchiveTimestampType(ArchiveTimestampType archiveTimestampType) {
        this.archiveTimestampType = archiveTimestampType;
    }

    protected TimestampToken createTimestampToken() {
        TimestampToken timestamp = super.createTimestampToken();
        if (this.manifestFile != null) {
            timestamp.setManifestFile(this.manifestFile);
        }
        if (this.archiveTimestampType != null) {
            timestamp.setArchiveTimestampType(this.archiveTimestampType);
        }
        return timestamp;
    }

    protected List<SignatureScope> getTimestampScopes(TimestampToken timestampToken) {
        ASiCWithCAdESTimestampScopeFinder timestampScopeFinder = new ASiCWithCAdESTimestampScopeFinder();
        timestampScopeFinder.setContainerDocuments(this.originalDocuments);
        timestampScopeFinder.setArchiveDocuments(this.archiveDocuments);
        timestampScopeFinder.setTimestampedData(this.getTimestampedData());
        return timestampScopeFinder.findTimestampScope(timestampToken);
    }

    protected boolean addReference(SignatureScope signatureScope) {
        String fileName = signatureScope.getDocumentName();
        return fileName == null || !ASiCUtils.isSignature((String)fileName) && !ASiCUtils.isTimestamp((String)fileName) && !ASiCUtils.isEvidenceRecord((String)fileName);
    }
}

