/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.ASiCCounterSignatureHelper;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.validation.DocumentValidator;
import java.util.Collections;
import java.util.List;

public class ASiCWithCAdESCounterSignatureHelper
extends ASiCCounterSignatureHelper {
    protected ASiCWithCAdESCounterSignatureHelper(DSSDocument asicContainer) {
        super(asicContainer);
    }

    protected AbstractASiCContainerExtractor getASiCContainerExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.asicContainer);
    }

    protected DocumentValidator getDocumentValidator(DSSDocument signatureDocument) {
        return new CMSDocumentValidator(signatureDocument);
    }

    protected List<DSSDocument> getDetachedDocuments(String signatureFilename) {
        DSSDocument signedDocument = ASiCWithCAdESUtils.getSignedDocument(this.getAsicContent(), signatureFilename);
        if (signedDocument != null) {
            return Collections.singletonList(signedDocument);
        }
        return Collections.emptyList();
    }

    public ManifestFile getManifestFile(String signatureFilename) {
        DSSDocument signatureManifest = ASiCManifestParser.getLinkedManifest((List)this.getAsicContent().getAllManifestDocuments(), (String)signatureFilename);
        if (signatureManifest != null) {
            return ASiCManifestParser.getManifestFile((DSSDocument)signatureManifest);
        }
        return null;
    }

    protected void checkCounterSignaturePossible(DSSDocument signatureDocument) {
        super.checkCounterSignaturePossible(signatureDocument);
        if (ASiCWithCAdESUtils.isCoveredByManifest(this.getAsicContent().getAllManifestDocuments(), signatureDocument.getName())) {
            throw new IllegalInputException(String.format("The counter signature is not possible! Reason : a signature with a filename '%s' is covered by another manifest.", signatureDocument.getName()));
        }
    }
}

