/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.DataToSignASiCEWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromArchive;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromFiles;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCDataToSignHelperBuilder;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.Collections;

public abstract class ASiCWithCAdESDataToSignHelperBuilder
extends AbstractASiCDataToSignHelperBuilder {
    protected final ASiCWithCAdESFilenameFactory asicFilenameFactory;

    protected ASiCWithCAdESDataToSignHelperBuilder(ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        this.asicFilenameFactory = asicFilenameFactory;
    }

    public GetDataToSignASiCWithCAdESHelper build(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        if (Utils.isCollectionNotEmpty((Collection)(asicContent = ASiCUtils.ensureMimeTypeAndZipComment((ASiCContent)asicContent, (ASiCParameters)parameters.aSiC())).getSignatureDocuments()) || Utils.isCollectionNotEmpty((Collection)asicContent.getTimestampDocuments())) {
            ASiCContainerType currentContainerType = asicContent.getContainerType();
            boolean asice = ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC());
            if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                DSSDocument manifestDocument = this.createManifestDocument(asicContent, parameters);
                return new DataToSignASiCEWithCAdESHelper(asicContent, manifestDocument);
            }
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                if (Utils.isCollectionNotEmpty((Collection)asicContent.getSignatureDocuments()) || Utils.isCollectionNotEmpty((Collection)asicContent.getTimestampDocuments())) {
                    return new DataToSignASiCSWithCAdESFromArchive(asicContent);
                }
                return new DataToSignASiCSWithCAdESFromFiles(asicContent);
            }
            throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", currentContainerType, parameters.aSiC().getContainerType()));
        }
        return this.fromFiles(asicContent, parameters);
    }

    private GetDataToSignASiCWithCAdESHelper fromFiles(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        if (ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC())) {
            asicContent.setContainerType(ASiCContainerType.ASiC_E);
            DSSDocument manifestDocument = this.createManifestDocument(asicContent, parameters);
            return new DataToSignASiCEWithCAdESHelper(asicContent, manifestDocument);
        }
        asicContent.setContainerType(ASiCContainerType.ASiC_S);
        DSSDocument asicsSignedDocument = this.getASiCSSignedDocument(asicContent.getSignedDocuments(), parameters.getZipCreationDate());
        asicContent.setSignedDocuments(Collections.singletonList(asicsSignedDocument));
        return new DataToSignASiCSWithCAdESFromFiles(asicContent);
    }

    private DSSDocument createManifestDocument(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        return this.getManifestBuilder(asicContent, parameters).build();
    }

    protected abstract ASiCEWithCAdESManifestBuilder getManifestBuilder(ASiCContent var1, ASiCWithCAdESCommonParameters var2);

    protected String getDataPackageName(ASiCContent asicContent) {
        return this.asicFilenameFactory.getDataPackageFilename(asicContent);
    }
}

