/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asics;

import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.AbstractGetDataToSignASiCSWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.List;

public class DataToSignASiCSWithCAdESFromArchive
extends AbstractGetDataToSignASiCSWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    public DataToSignASiCSWithCAdESFromArchive(ASiCContent asicContent) {
        super(asicContent);
    }

    @Override
    public DSSDocument getToBeSigned() {
        List embeddedSignatures = this.asicContent.getSignatureDocuments();
        int nbEmbeddedSignatures = Utils.collectionSize((Collection)embeddedSignatures);
        if (nbEmbeddedSignatures != 1) {
            throw new DSSException("Unable to select the embedded signature (nb found:" + nbEmbeddedSignatures + ")");
        }
        return (DSSDocument)embeddedSignatures.get(0);
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        List embeddedSignedFiles = this.asicContent.getSignedDocuments();
        int nbSignedFiles = Utils.collectionSize((Collection)embeddedSignedFiles);
        if (nbSignedFiles != 1) {
            throw new DSSException("Unable to select the document to be signed (nb found:" + nbSignedFiles + ")");
        }
        return embeddedSignedFiles;
    }
}

