/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.asic.manifest.definition.ASiCManifestAttribute;
import eu.europa.esig.asic.manifest.definition.ASiCManifestElement;
import eu.europa.esig.asic.manifest.definition.ASiCManifestNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xmldsig.definition.XMLDSigAttribute;
import eu.europa.esig.xmldsig.definition.XMLDSigElement;
import eu.europa.esig.xmldsig.definition.XMLDSigNamespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractManifestBuilder {
    protected AbstractManifestBuilder() {
    }

    protected void addSigReference(Document documentDom, Element asicManifestDom, String uri, MimeType mimeType) {
        Element sigReferenceDom = DomUtils.addElement((Document)documentDom, (Element)asicManifestDom, (DSSNamespace)ASiCManifestNamespace.NS, (DSSElement)ASiCManifestElement.SIG_REFERENCE);
        sigReferenceDom.setAttribute(ASiCManifestAttribute.URI.getAttributeName(), DSSUtils.encodeURI((String)uri));
        sigReferenceDom.setAttribute(ASiCManifestAttribute.MIME_TYPE.getAttributeName(), mimeType.getMimeTypeString());
    }

    protected Element addDataObjectReference(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceDom = DomUtils.addElement((Document)documentDom, (Element)asicManifestDom, (DSSNamespace)ASiCManifestNamespace.NS, (DSSElement)ASiCManifestElement.DATA_OBJECT_REFERENCE);
        dataObjectReferenceDom.setAttribute(ASiCManifestAttribute.URI.getAttributeName(), DSSUtils.encodeURI((String)document.getName()));
        MimeType mimeType = document.getMimeType();
        if (mimeType != null) {
            dataObjectReferenceDom.setAttribute(ASiCManifestAttribute.MIME_TYPE.getAttributeName(), mimeType.getMimeTypeString());
        }
        Element digestMethodDom = DomUtils.addElement((Document)documentDom, (Element)dataObjectReferenceDom, (DSSNamespace)XMLDSigNamespace.NS, (DSSElement)XMLDSigElement.DIGEST_METHOD);
        digestMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), digestAlgorithm.getUri());
        Element digestValueDom = DomUtils.addElement((Document)documentDom, (Element)dataObjectReferenceDom, (DSSNamespace)XMLDSigNamespace.NS, (DSSElement)XMLDSigElement.DIGEST_VALUE);
        Text textNode = documentDom.createTextNode(document.getDigest(digestAlgorithm));
        digestValueDom.appendChild(textNode);
        return dataObjectReferenceDom;
    }
}

