/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASiCCounterSignatureHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCCounterSignatureHelper.class);
    protected final DSSDocument asicContainer;
    private final ASiCContent asicContent;

    protected ASiCCounterSignatureHelper(DSSDocument asicContainer) {
        this.asicContainer = asicContainer;
        this.asicContent = this.extractAsicContent();
    }

    private ASiCContent extractAsicContent() {
        AbstractASiCContainerExtractor extractor = this.getASiCContainerExtractor();
        return extractor.extract();
    }

    public ASiCContent getAsicContent() {
        return this.asicContent;
    }

    public DSSDocument extractSignatureDocument(String signatureId) {
        if (!ASiCUtils.isZip(this.asicContainer)) {
            throw new IllegalInputException("The provided file shall be an ASiC container with signatures inside!");
        }
        List<DSSDocument> signatureDocuments = this.asicContent.getSignatureDocuments();
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new IllegalInputException("No signatures found to be extended!");
        }
        for (DSSDocument signatureDocument : signatureDocuments) {
            if (!this.containsSignatureToBeCounterSigned(signatureDocument, signatureId)) continue;
            this.checkCounterSignaturePossible(signatureDocument);
            return signatureDocument;
        }
        throw new IllegalArgumentException(String.format("A signature with id '%s' has not been found!", signatureId));
    }

    protected abstract List<DSSDocument> getDetachedDocuments(String var1);

    public ManifestFile getManifestFile(String signatureFilename) {
        return null;
    }

    protected abstract AbstractASiCContainerExtractor getASiCContainerExtractor();

    protected abstract DocumentValidator getDocumentValidator(DSSDocument var1);

    private boolean containsSignatureToBeCounterSigned(DSSDocument signatureDocument, String signatureId) {
        try {
            DocumentValidator validator = this.getDocumentValidator(signatureDocument);
            validator.setDetachedContents(this.getDetachedDocuments(signatureDocument.getName()));
            validator.setManifestFile(this.getManifestFile(signatureDocument.getName()));
            List signatures = validator.getSignatures();
            for (AdvancedSignature signature : signatures) {
                if (!this.containsSignatureToBeCounterSigned(signature, signatureId)) continue;
                return true;
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to verify a file with name '{}'. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, new Object[]{signatureDocument.getName(), e.getMessage(), e});
            }
            LOG.warn(errorMessage, (Object)signatureDocument.getName(), (Object)e.getMessage());
        }
        return false;
    }

    private boolean containsSignatureToBeCounterSigned(AdvancedSignature signature, String signatureId) {
        if (signatureId.equals(signature.getId()) || signatureId.equals(signature.getDAIdentifier())) {
            return true;
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            if (!this.containsSignatureToBeCounterSigned(counterSignature, signatureId)) continue;
            return true;
        }
        return false;
    }

    protected void checkCounterSignaturePossible(DSSDocument signatureDocument) {
    }
}

