/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.ASiCContainerDiagnosticDataBuilder;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractASiCContainerValidator
extends SignedDocumentValidator {
    protected ASiCContent asicContent;
    protected List<DocumentValidator> signatureValidators;
    protected List<DetachedTimestampValidator> timestampValidators;
    private List<ManifestFile> manifestFiles;

    protected AbstractASiCContainerValidator() {
    }

    protected AbstractASiCContainerValidator(DSSDocument document) {
        this(document, null);
    }

    protected AbstractASiCContainerValidator(ASiCContent asicContent) {
        this(asicContent, null);
    }

    protected AbstractASiCContainerValidator(DSSDocument document, SignatureScopeFinder<?> signatureScopeFinder) {
        super(signatureScopeFinder);
        this.document = document;
        this.asicContent = this.extractEntries();
    }

    protected AbstractASiCContainerValidator(ASiCContent asicContent, SignatureScopeFinder<?> signatureScopeFinder) {
        super(signatureScopeFinder);
        this.document = asicContent.getAsicContainer();
        this.asicContent = asicContent;
    }

    public abstract boolean isSupported(ASiCContent var1);

    private ASiCContent extractEntries() {
        AbstractASiCContainerExtractor extractor = this.getContainerExtractor();
        return extractor.extract();
    }

    protected abstract AbstractASiCContainerExtractor getContainerExtractor();

    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext, List<AdvancedSignature> signatures) {
        ASiCContainerDiagnosticDataBuilder builder = (ASiCContainerDiagnosticDataBuilder)super.createDiagnosticDataBuilder(validationContext, signatures);
        builder.containerInfo(this.getContainerInfo());
        return builder;
    }

    protected ASiCContainerDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new ASiCContainerDiagnosticDataBuilder();
    }

    protected ContainerInfo getContainerInfo() {
        List<DSSDocument> originalSignedDocuments;
        ContainerInfo containerInfo = new ContainerInfo();
        containerInfo.setContainerType(this.asicContent.getContainerType());
        containerInfo.setZipComment(this.asicContent.getZipComment());
        DSSDocument mimeTypeDocument = this.asicContent.getMimeTypeDocument();
        if (mimeTypeDocument != null) {
            String mimeTypeContent = new String(DSSUtils.toByteArray((DSSDocument)mimeTypeDocument));
            containerInfo.setMimeTypeContent(mimeTypeContent);
        }
        if (Utils.isCollectionNotEmpty(originalSignedDocuments = this.asicContent.getSignedDocuments())) {
            ArrayList<String> signedDocumentFilenames = new ArrayList<String>();
            for (DSSDocument dssDocument : originalSignedDocuments) {
                signedDocumentFilenames.add(dssDocument.getName());
            }
            containerInfo.setSignedDocumentFilenames(signedDocumentFilenames);
        }
        containerInfo.setManifestFiles(this.getManifestFiles());
        return containerInfo;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        return Collections.emptyList();
    }

    protected abstract List<ManifestFile> getManifestFilesDescriptions();

    public List<AdvancedSignature> getAllSignatures() {
        List allSignatureList = super.getAllSignatures();
        this.attachExternalTimestamps(allSignatureList);
        return allSignatureList;
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatureList = new ArrayList<AdvancedSignature>();
        for (DocumentValidator validator : this.getSignatureValidators()) {
            signatureList.addAll(validator.getSignatures());
        }
        return signatureList;
    }

    protected abstract List<DocumentValidator> getSignatureValidators();

    public ASiCContainerType getContainerType() {
        return this.asicContent.getContainerType();
    }

    public List<DSSDocument> getAllDocuments() {
        return this.asicContent.getAllDocuments();
    }

    public List<DSSDocument> getSignatureDocuments() {
        return this.asicContent.getSignatureDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.asicContent.getSignedDocuments();
    }

    public List<DSSDocument> getManifestDocuments() {
        return this.asicContent.getManifestDocuments();
    }

    public List<DSSDocument> getTimestampDocuments() {
        return this.asicContent.getTimestampDocuments();
    }

    public List<DSSDocument> getArchiveManifestDocuments() {
        return this.asicContent.getArchiveManifestDocuments();
    }

    public List<DSSDocument> getAllManifestDocuments() {
        return this.asicContent.getAllManifestDocuments();
    }

    public List<DSSDocument> getArchiveDocuments() {
        return this.asicContent.getContainerDocuments();
    }

    public DSSDocument getMimeTypeDocument() {
        return this.asicContent.getMimeTypeDocument();
    }

    public List<DSSDocument> getUnsupportedDocuments() {
        return this.asicContent.getUnsupportedDocuments();
    }

    public List<ManifestFile> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = this.getManifestFilesDescriptions();
        }
        return this.manifestFiles;
    }

    protected List<DSSDocument> getSignedDocumentsASiCS(List<DSSDocument> retrievedDocs) {
        List<DSSDocument> containerDocuments = this.asicContent.getContainerDocuments();
        if (Utils.isCollectionNotEmpty(containerDocuments)) {
            return containerDocuments;
        }
        return retrievedDocs;
    }
}

