/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.asic.ASiCExtractResult;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASiCContainerExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractASiCContainerExtractor.class);
    private static final String MIME_TYPE = "mimetype";
    protected static final String META_INF_FOLDER = "META-INF/";
    private final DSSDocument asicContainer;

    protected AbstractASiCContainerExtractor(DSSDocument asicContainer) {
        this.asicContainer = asicContainer;
    }

    public ASiCExtractResult extract() {
        ASiCExtractResult result = new ASiCExtractResult();
        try (InputStream is = this.asicContainer.openStream();
             ZipInputStream asicInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = asicInputStream.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (this.isMetaInfFolder(entryName)) {
                    if (this.isAllowedSignature(entryName)) {
                        result.getSignatureDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream));
                        continue;
                    }
                    if (this.isAllowedManifest(entryName)) {
                        result.getManifestDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream));
                        continue;
                    }
                    if (this.isAllowedArchiveManifest(entryName)) {
                        result.getArchiveManifestDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream));
                        continue;
                    }
                    if (this.isAllowedTimestamp(entryName)) {
                        result.getTimestampDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream));
                        continue;
                    }
                    if (this.isFolder(entryName)) continue;
                    result.getUnsupportedDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream));
                    continue;
                }
                if (this.isFolder(entryName)) continue;
                if (this.isMimetype(entryName)) {
                    result.setMimeTypeDocument(ASiCUtils.getCurrentDocument(entryName, asicInputStream));
                    continue;
                }
                result.getSignedDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream));
            }
            if (Utils.isCollectionNotEmpty(result.getUnsupportedDocuments())) {
                LOG.warn("Unsupported files : {}", result.getUnsupportedDocuments());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to parse the container {}", (Object)e.getMessage());
        }
        result.setZipComment(this.getZipComment());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getZipComment() {
        try (InputStream is = this.asicContainer.openStream();){
            byte[] buffer = Utils.toByteArray((InputStream)is);
            int len = buffer.length;
            byte[] magicDirEnd = new byte[]{80, 75, 5, 6};
            int ii = len - magicDirEnd.length - 22;
            while (ii >= 0) {
                boolean isMagicStart = true;
                for (int jj = 0; jj < magicDirEnd.length; ++jj) {
                    if (buffer[ii + jj] == magicDirEnd[jj]) continue;
                    isMagicStart = false;
                    break;
                }
                if (isMagicStart) {
                    int commentLen = buffer[ii + 20] + buffer[ii + 21] * 256;
                    int realLen = len - ii - 22;
                    if (commentLen != realLen) {
                        LOG.warn("WARNING! ZIP comment size mismatch: directory says len is {}, but file ends after {} bytes!", (Object)commentLen, (Object)realLen);
                    }
                    String string = new String(buffer, ii + 22, realLen);
                    return string;
                }
                --ii;
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Unable to extract the ZIP comment : {}", (Object)e.getMessage());
        }
        return null;
    }

    private boolean isMimetype(String entryName) {
        return MIME_TYPE.equals(entryName);
    }

    private boolean isMetaInfFolder(String entryName) {
        return entryName.startsWith(META_INF_FOLDER);
    }

    private boolean isFolder(String entryName) {
        return entryName.endsWith("/");
    }

    abstract boolean isAllowedManifest(String var1);

    abstract boolean isAllowedArchiveManifest(String var1);

    abstract boolean isAllowedTimestamp(String var1);

    abstract boolean isAllowedSignature(String var1);
}

