/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature;

import eu.europa.esig.dss.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.asic.ASiCExtractResult;
import eu.europa.esig.dss.asic.ASiCParameters;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.TimestampToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractASiCSignatureService<SP extends AbstractSignatureParameters>
extends AbstractSignatureService<SP>
implements MultipleDocumentsSignatureService<SP> {
    private static final long serialVersionUID = 243114076381526665L;
    private static final String ZIP_ENTRY_DETACHED_FILE = "detached-file";
    private static final String ZIP_ENTRY_MIMETYPE = "mimetype";
    protected ASiCExtractResult archiveContent = new ASiCExtractResult();

    protected AbstractASiCSignatureService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    abstract String getExpectedSignatureExtension();

    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, SP parameters) {
        return this.getContentTimestamp(Arrays.asList(toSignDocument), (AbstractSerializableSignatureParameters)parameters);
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, SP parameters) {
        return this.getDataToSign(Arrays.asList(toSignDocument), (AbstractSerializableSignatureParameters)parameters);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, SP parameters, SignatureValue signatureValue) {
        return (DSSDocument)this.signDocument(Arrays.asList(toSignDocument), (AbstractSerializableSignatureParameters)parameters, signatureValue);
    }

    protected void extractCurrentArchive(DSSDocument archive) {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor(archive);
        this.archiveContent = extractor.extract();
    }

    abstract AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument var1);

    protected List<DSSDocument> getEmbeddedSignatures() {
        return this.archiveContent.getSignatureDocuments();
    }

    protected List<DSSDocument> getEmbeddedManifests() {
        return this.archiveContent.getManifestDocuments();
    }

    protected List<DSSDocument> getEmbeddedArchiveManifests() {
        return this.archiveContent.getArchiveManifestDocuments();
    }

    protected List<DSSDocument> getEmbeddedTimestamps() {
        return this.archiveContent.getTimestampDocuments();
    }

    protected List<DSSDocument> getEmbeddedSignedDocuments() {
        return this.archiveContent.getSignedDocuments();
    }

    protected DSSDocument getEmbeddedMimetype() {
        return this.archiveContent.getMimeTypeDocument();
    }

    /*
     * Exception decompiling
     */
    protected DSSDocument mergeArchiveAndExtendedSignatures(DSSDocument archiveDocument, List<DSSDocument> signaturesToAdd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyArchiveContentWithoutSignatures(DSSDocument archiveDocument, ZipOutputStream zos) throws IOException {
        try (InputStream is = archiveDocument.openStream();
             ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                ZipEntry newEntry = new ZipEntry(name);
                if (this.isSignatureFilename(name)) continue;
                zos.putNextEntry(newEntry);
                Utils.copy((InputStream)zis, (OutputStream)zos);
            }
        }
    }

    abstract boolean isSignatureFilename(String var1);

    /*
     * Exception decompiling
     */
    protected DSSDocument buildASiCContainer(List<DSSDocument> documentsToBeSigned, List<DSSDocument> signatures, List<DSSDocument> manifestDocuments, ASiCParameters asicParameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void storeDocuments(List<DSSDocument> documents, ZipOutputStream zos) throws IOException {
        for (DSSDocument doc : documents) {
            ZipEntry entrySignature = new ZipEntry(doc.getName());
            zos.putNextEntry(entrySignature);
            doc.writeTo((OutputStream)zos);
        }
    }

    private void storeSignedFiles(List<DSSDocument> detachedDocuments, ZipOutputStream zos) throws IOException {
        for (DSSDocument detachedDocument : detachedDocuments) {
            InputStream is = detachedDocument.openStream();
            Throwable throwable = null;
            try {
                String detachedDocumentName = detachedDocument.getName();
                String name = detachedDocumentName != null ? detachedDocumentName : ZIP_ENTRY_DETACHED_FILE;
                ZipEntry entryDocument = new ZipEntry(name);
                zos.setLevel(8);
                zos.putNextEntry(entryDocument);
                Utils.copy((InputStream)is, (OutputStream)zos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private void storeMimetype(ASiCParameters asicParameters, ZipOutputStream zos) throws IOException {
        byte[] mimeTypeBytes = ASiCUtils.getMimeTypeString(asicParameters).getBytes("UTF-8");
        ZipEntry entryMimetype = this.getZipEntryMimeType(mimeTypeBytes);
        zos.putNextEntry(entryMimetype);
        Utils.write((byte[])mimeTypeBytes, (OutputStream)zos);
    }

    private ZipEntry getZipEntryMimeType(byte[] mimeTypeBytes) {
        ZipEntry entryMimetype = new ZipEntry(ZIP_ENTRY_MIMETYPE);
        entryMimetype.setMethod(0);
        entryMimetype.setSize(mimeTypeBytes.length);
        entryMimetype.setCompressedSize(mimeTypeBytes.length);
        CRC32 crc = new CRC32();
        crc.update(mimeTypeBytes);
        entryMimetype.setCrc(crc.getValue());
        return entryMimetype;
    }

    protected void storeZipComment(ASiCParameters asicParameters, ZipOutputStream zos) {
        if (asicParameters.isZipComment()) {
            zos.setComment("mimetype=" + ASiCUtils.getMimeTypeString(asicParameters));
        }
    }
}

