/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.CounterSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public abstract class AbstractASiCSignatureService<SP extends SerializableSignatureParameters, TP extends SerializableTimestampParameters, CSP extends SerializableCounterSignatureParameters>
extends AbstractSignatureService<SP, TP>
implements MultipleDocumentsSignatureService<SP, TP>,
CounterSignatureService<CSP> {
    private static final long serialVersionUID = 243114076381526665L;
    protected ASiCExtractResult archiveContent = new ASiCExtractResult();

    protected AbstractASiCSignatureService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    protected abstract String getExpectedSignatureExtension();

    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, SP parameters) {
        return this.getContentTimestamp(Arrays.asList(toSignDocument), (SerializableSignatureParameters)parameters);
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, SP parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        return this.getDataToSign(Arrays.asList(toSignDocument), (SerializableSignatureParameters)parameters);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, SP parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        return this.signDocument(Arrays.asList(toSignDocument), (SerializableSignatureParameters)parameters, signatureValue);
    }

    public DSSDocument timestamp(DSSDocument toTimestampDocument, TP parameters) {
        Objects.requireNonNull(toTimestampDocument, "toTimestampDocument cannot be null!");
        return this.timestamp(Arrays.asList(toTimestampDocument), (SerializableTimestampParameters)parameters);
    }

    protected void extractCurrentArchive(DSSDocument archive) {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor(archive);
        this.archiveContent = extractor.extract();
    }

    protected abstract AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument var1);

    protected List<DSSDocument> getEmbeddedSignatures() {
        return this.archiveContent.getSignatureDocuments();
    }

    protected List<DSSDocument> getEmbeddedManifests() {
        return this.archiveContent.getManifestDocuments();
    }

    protected List<DSSDocument> getEmbeddedArchiveManifests() {
        return this.archiveContent.getArchiveManifestDocuments();
    }

    protected List<DSSDocument> getEmbeddedTimestamps() {
        return this.archiveContent.getTimestampDocuments();
    }

    protected List<DSSDocument> getEmbeddedSignedDocuments() {
        return this.archiveContent.getSignedDocuments();
    }

    protected DSSDocument getEmbeddedMimetype() {
        return this.archiveContent.getMimeTypeDocument();
    }

    protected DSSDocument mergeArchiveAndExtendedSignatures(DSSDocument archiveDocument, List<DSSDocument> filesToAdd, Date creationTime, String zipComment) {
        List<DSSDocument> containerEntriesList = this.getListOfArchiveDocumentToAdd(archiveDocument, filesToAdd);
        DSSDocument zipArchive = ZipUtils.getInstance().createZipArchive(containerEntriesList, creationTime, zipComment);
        zipArchive.setMimeType(archiveDocument.getMimeType());
        return zipArchive;
    }

    private List<DSSDocument> getListOfArchiveDocumentToAdd(DSSDocument archiveDocument, List<DSSDocument> filesToAdd) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        List filesToAddNames = DSSUtils.getDocumentNames(filesToAdd);
        List<DSSDocument> containerContent = ZipUtils.getInstance().extractContainerContent(archiveDocument);
        for (DSSDocument entry : containerContent) {
            if (filesToAddNames.contains(entry.getName())) continue;
            result.add(entry);
        }
        result.addAll(filesToAdd);
        return result;
    }

    protected DSSDocument buildASiCContainer(List<DSSDocument> documentsToBeSigned, List<DSSDocument> signatures, List<DSSDocument> metaInfFolderDocuments, ASiCParameters asicParameters, Date creationTime) {
        List<DSSDocument> containerEntriesList = this.getListOfArchiveDocumentToAdd(documentsToBeSigned, signatures, metaInfFolderDocuments, asicParameters);
        DSSDocument zipArchive = ZipUtils.getInstance().createZipArchive(containerEntriesList, creationTime, ASiCUtils.getZipComment(asicParameters));
        zipArchive.setMimeType(ASiCUtils.getMimeType(asicParameters));
        return zipArchive;
    }

    private List<DSSDocument> getListOfArchiveDocumentToAdd(List<DSSDocument> documentsToBeSigned, List<DSSDocument> signatures, List<DSSDocument> metaInfFolderDocuments, ASiCParameters asicParameters) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        result.add(this.getMimetypeDocument(asicParameters));
        result.addAll(documentsToBeSigned);
        if (ASiCUtils.isASiCE(asicParameters)) {
            result.addAll(metaInfFolderDocuments);
        }
        result.addAll(signatures);
        return result;
    }

    private DSSDocument getMimetypeDocument(ASiCParameters asicParameters) {
        byte[] mimeTypeBytes = ASiCUtils.getMimeTypeString(asicParameters).getBytes(StandardCharsets.UTF_8);
        return new InMemoryDocument(mimeTypeBytes, "mimetype");
    }

    protected void assertCounterSignatureParametersValid(CSP parameters) {
        if (Utils.isStringEmpty((String)parameters.getSignatureIdToCounterSign())) {
            throw new DSSException("The Id of a signature to be counter signed shall be defined! Please use SerializableCounterSignatureParameters.setSignatureIdToCounterSign(signatureId) method.");
        }
    }

    protected void assertAddSignaturePolicyStorePossible() {
        if (Utils.isCollectionEmpty(this.getEmbeddedSignatures())) {
            throw new UnsupportedOperationException("Signature documents of the expected format are not found in the provided ASiC Container! Add a SignaturePolicyStore is not possible!");
        }
    }

    protected String getFinalArchiveName(DSSDocument originalFile, SigningOperation operation, MimeType containerMimeType) {
        return this.getFinalDocumentName(originalFile, operation, null, containerMimeType);
    }
}

