/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.SecureContainerHandler;
import eu.europa.esig.dss.asic.common.ZipContainerHandler;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public final class ZipUtils {
    private static ZipUtils singleton;
    private ZipContainerHandler zipContainerHandler = new SecureContainerHandler();

    private ZipUtils() {
    }

    public static ZipUtils getInstance() {
        if (singleton == null) {
            singleton = new ZipUtils();
        }
        return singleton;
    }

    public void setZipContainerHandler(ZipContainerHandler zipContainerHandler) {
        Objects.requireNonNull(zipContainerHandler, "zipContainerHandler shall be defined!");
        this.zipContainerHandler = zipContainerHandler;
    }

    public List<DSSDocument> extractContainerContent(DSSDocument zipPackage) {
        return this.zipContainerHandler.extractContainerContent(zipPackage);
    }

    public List<String> extractEntryNames(DSSDocument zipPackage) {
        return this.zipContainerHandler.extractEntryNames(zipPackage);
    }

    public DSSDocument createZipArchive(List<DSSDocument> containerEntries, Date creationTime, String zipComment) {
        return this.zipContainerHandler.createZipArchive(containerEntries, creationTime, zipComment);
    }
}

