/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.SecureContainerHandlerBuilder;
import eu.europa.esig.dss.asic.common.ZipContainerHandler;
import eu.europa.esig.dss.asic.common.ZipContainerHandlerBuilder;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZipUtils.class);
    private static ZipUtils singleton;
    private ZipContainerHandlerBuilder<?> zipContainerHandlerBuilder = new SecureContainerHandlerBuilder();

    private ZipUtils() {
    }

    public static ZipUtils getInstance() {
        if (singleton == null) {
            singleton = new ZipUtils();
        }
        return singleton;
    }

    public void setZipContainerHandlerBuilder(ZipContainerHandlerBuilder<?> zipContainerHandlerBuilder) {
        Objects.requireNonNull(zipContainerHandlerBuilder, "ZipContainerHandlerBuilder shall be defined!");
        this.zipContainerHandlerBuilder = zipContainerHandlerBuilder;
    }

    @Deprecated
    public void setZipContainerHandler(ZipContainerHandler zipContainerHandler) {
        Objects.requireNonNull(zipContainerHandler, "zipContainerHandler shall be defined!");
        LOG.warn("Use of deprecated method #setZipContainerHandler(zipContainerHandler)! Not thread-safe! Please use #setZipContainerHandlerBuilder(zipContainerHandlerBuilder) method instead.");
        this.zipContainerHandlerBuilder = () -> zipContainerHandler;
    }

    public List<DSSDocument> extractContainerContent(DSSDocument zipPackage) {
        return this.getZipContainerHandler().extractContainerContent(zipPackage);
    }

    public List<String> extractEntryNames(DSSDocument zipPackage) {
        return this.getZipContainerHandler().extractEntryNames(zipPackage);
    }

    public DSSDocument createZipArchive(List<DSSDocument> containerEntries, Date creationTime, String zipComment) {
        return this.getZipContainerHandler().createZipArchive(containerEntries, creationTime, zipComment);
    }

    public DSSDocument createZipArchive(ASiCContent asicContent) {
        return this.createZipArchive(asicContent, new Date());
    }

    public DSSDocument createZipArchive(ASiCContent asicContent, Date creationTime) {
        return this.createZipArchive(asicContent.getAllDocuments(), creationTime, asicContent.getZipComment());
    }

    private ZipContainerHandler getZipContainerHandler() {
        return this.zipContainerHandlerBuilder.build();
    }
}

