/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCManifestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCManifestValidator.class);
    private final ManifestFile manifest;
    private final List<DSSDocument> signedDocuments;

    public ASiCManifestValidator(ManifestFile manifest, List<DSSDocument> signedDocuments) {
        Objects.requireNonNull(manifest, "ManifestFile must be defined!");
        this.manifest = manifest;
        this.signedDocuments = signedDocuments;
    }

    public List<ManifestEntry> validateEntries() {
        List manifestEntries = this.manifest.getEntries();
        if (Utils.isCollectionEmpty(this.signedDocuments)) {
            return manifestEntries;
        }
        for (ManifestEntry entry : manifestEntries) {
            if (entry.getDigest() != null) {
                DSSDocument signedDocument = DSSUtils.getDocumentWithName(this.signedDocuments, (String)entry.getFileName());
                if (signedDocument != null) {
                    entry.setFound(true);
                    String computedDigest = signedDocument.getDigest(entry.getDigest().getAlgorithm());
                    if (Arrays.equals(entry.getDigest().getValue(), Utils.fromBase64((String)computedDigest))) {
                        entry.setIntact(true);
                    } else {
                        LOG.warn("Digest value doesn't match for signed data with name '{}'", (Object)entry.getFileName());
                        LOG.warn("Expected : '{}'", (Object)Utils.toBase64((byte[])entry.getDigest().getValue()));
                        LOG.warn("Computed : '{}'", (Object)computedDigest);
                    }
                }
            } else {
                LOG.warn("Digest is not defined for signed data with name '{}'", (Object)entry.getFileName());
            }
            if (entry.isFound()) continue;
            LOG.warn("Signed data with name '{}' not found", (Object)entry.getFileName());
        }
        return manifestEntries;
    }
}

