/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.BLevelParameters;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.Policy;
import eu.europa.esig.dss.SignerLocation;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignaturePolicyIdentifier;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineB {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineB.class);
    private final boolean padesUsage;

    public CAdESLevelBaselineB() {
        this(false);
    }

    public CAdESLevelBaselineB(boolean padesUsage) {
        this.padesUsage = padesUsage;
    }

    public AttributeTable getUnsignedAttributes() {
        return new AttributeTable(new Hashtable());
    }

    public AttributeTable getSignedAttributes(CAdESSignatureParameters parameters) {
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        this.addSigningCertificateAttribute(parameters, signedAttributes);
        this.addSigningTimeAttribute(parameters, signedAttributes);
        this.addSignerAttribute(parameters, signedAttributes);
        this.addSignaturePolicyId(parameters, signedAttributes);
        this.addContentHints(parameters, signedAttributes);
        this.addContentIdentifier(parameters, signedAttributes);
        this.addCommitmentType(parameters, signedAttributes);
        this.addSignerLocation(parameters, signedAttributes);
        this.addContentTimestamps(parameters, signedAttributes);
        AttributeTable signedAttributesTable = new AttributeTable(signedAttributes);
        return signedAttributesTable;
    }

    private void addSignerAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List claimedSignerRoles;
        if (!this.padesUsage && (claimedSignerRoles = parameters.bLevel().getClaimedSignerRoles()) != null) {
            ArrayList<Attribute> claimedAttributes = new ArrayList<Attribute>(claimedSignerRoles.size());
            for (String claimedSignerRole : claimedSignerRoles) {
                DERUTF8String roles = new DERUTF8String(claimedSignerRole);
                Attribute id_aa_ets_signerAttr = new Attribute(X509ObjectIdentifiers.id_at_name, (ASN1Set)new DERSet((ASN1Encodable)roles));
                claimedAttributes.add(id_aa_ets_signerAttr);
            }
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttribute(claimedAttributes.toArray(new Attribute[claimedAttributes.size()]))));
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSigningTimeAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        Date signingDate;
        if (!this.padesUsage && (signingDate = parameters.bLevel().getSigningDate()) != null) {
            DERSet attrValues = new DERSet((ASN1Encodable)new Time(signingDate));
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSignerLocation(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        SignerLocation signerLocationParameter;
        if (!this.padesUsage && (signerLocationParameter = parameters.bLevel().getSignerLocation()) != null) {
            DERUTF8String country = signerLocationParameter.getCountry() == null ? null : new DERUTF8String(signerLocationParameter.getCountry());
            DERUTF8String locality = signerLocationParameter.getLocality() == null ? null : new DERUTF8String(signerLocationParameter.getLocality());
            ASN1EncodableVector postalAddress = new ASN1EncodableVector();
            List postalAddressParameter = signerLocationParameter.getPostalAddress();
            if (postalAddressParameter != null) {
                for (String addressLine : postalAddressParameter) {
                    postalAddress.add((ASN1Encodable)new DERUTF8String(addressLine));
                }
            }
            DERSequence derSequencePostalAddress = new DERSequence(postalAddress);
            org.bouncycastle.asn1.esf.SignerLocation signerLocation = new org.bouncycastle.asn1.esf.SignerLocation(country, locality, (ASN1Sequence)derSequencePostalAddress);
            DERSet attrValues = new DERSet((ASN1Encodable)signerLocation);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addCommitmentType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        BLevelParameters bLevelParameters = parameters.bLevel();
        List commitmentTypeIndications = bLevelParameters.getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty((Collection)commitmentTypeIndications)) {
            int size = commitmentTypeIndications.size();
            ASN1Encodable[] asn1Encodables = new ASN1Encodable[size];
            for (int ii = 0; ii < size; ++ii) {
                String commitmentTypeId = (String)commitmentTypeIndications.get(ii);
                ASN1ObjectIdentifier objectIdentifier = new ASN1ObjectIdentifier(commitmentTypeId);
                asn1Encodables[ii] = new DERSequence((ASN1Encodable)objectIdentifier);
            }
            DERSet attrValues = new DERSet(asn1Encodables);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addContentTimestamps(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (parameters.getContentTimestamps() != null && !parameters.getContentTimestamps().isEmpty()) {
            List contentTimestamps = parameters.getContentTimestamps();
            for (TimestampToken contentTimestamp : contentTimestamps) {
                ASN1Primitive asn1Object = DSSASN1Utils.toASN1Primitive((byte[])contentTimestamp.getEncoded());
                DERSet attrValues = new DERSet((ASN1Encodable)asn1Object);
                org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp, (ASN1Set)attrValues);
                signedAttributes.add((ASN1Encodable)attribute);
            }
        }
    }

    private void addContentHints(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isStringNotBlank((String)parameters.getContentHintsType())) {
            ASN1ObjectIdentifier contentHintsType = new ASN1ObjectIdentifier(parameters.getContentHintsType());
            String contentHintsDescriptionString = parameters.getContentHintsDescription();
            DERUTF8String contentHintsDescription = Utils.isStringBlank((String)contentHintsDescriptionString) ? null : new DERUTF8String(contentHintsDescriptionString);
            ContentHints contentHints = new ContentHints(contentHintsType, contentHintsDescription);
            DERSet attrValues = new DERSet((ASN1Encodable)contentHints);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentHint, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addContentIdentifier(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        String contentIdentifierPrefix;
        if (!this.padesUsage && Utils.isStringNotBlank((String)(contentIdentifierPrefix = parameters.getContentIdentifierPrefix()))) {
            String contentIdentifierSuffix;
            if (Utils.isStringBlank((String)parameters.getContentIdentifierSuffix())) {
                Date now = new Date();
                String asn1GeneralizedTimeString = new ASN1GeneralizedTime(now).getTimeString();
                long randomNumber = new Random(now.getTime()).nextLong();
                contentIdentifierSuffix = asn1GeneralizedTimeString + randomNumber;
                parameters.setContentIdentifierSuffix(contentIdentifierSuffix);
            } else {
                contentIdentifierSuffix = parameters.getContentIdentifierSuffix();
            }
            String contentIdentifierString = contentIdentifierPrefix + contentIdentifierSuffix;
            ContentIdentifier contentIdentifier = new ContentIdentifier(contentIdentifierString.getBytes());
            DERSet attrValues = new DERSet((ASN1Encodable)contentIdentifier);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentIdentifier, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSignaturePolicyId(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        Policy policy = parameters.bLevel().getSignaturePolicy();
        if (policy != null) {
            String policyId = policy.getId();
            SignaturePolicyIdentifier sigPolicy = null;
            if (Utils.isStringEmpty((String)policyId)) {
                sigPolicy = new SignaturePolicyIdentifier();
            } else {
                ASN1ObjectIdentifier derOIPolicyId = new ASN1ObjectIdentifier(policyId);
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(policy.getDigestAlgorithm().getOid());
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(oid);
                OtherHashAlgAndValue otherHashAlgAndValue = new OtherHashAlgAndValue(algorithmIdentifier, (ASN1OctetString)new DEROctetString(policy.getDigestValue()));
                if (Utils.isStringNotEmpty((String)policy.getSpuri())) {
                    SigPolicyQualifierInfo policyQualifierInfo = new SigPolicyQualifierInfo(PKCSObjectIdentifiers.id_spq_ets_uri, (ASN1Encodable)new DERUTF8String(policy.getSpuri()));
                    SigPolicyQualifierInfo[] qualifierInfos = new SigPolicyQualifierInfo[]{policyQualifierInfo};
                    SigPolicyQualifiers qualifiers = new SigPolicyQualifiers(qualifierInfos);
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue, qualifiers));
                } else {
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue));
                }
            }
            DERSet attrValues = new DERSet((ASN1Encodable)sigPolicy);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSigningCertificateAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) throws DSSException {
        DigestAlgorithm digestAlgorithm = parameters.getDigestAlgorithm();
        CertificateToken signingToken = parameters.getSigningCertificate();
        byte[] certHash = signingToken.getDigest(digestAlgorithm);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Certificate Hash {} with algorithm {}", (Object)Utils.toHex((byte[])certHash), (Object)digestAlgorithm.getName());
        }
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial((CertificateToken)parameters.getSigningCertificate());
        org.bouncycastle.asn1.cms.Attribute attribute = null;
        if (digestAlgorithm == DigestAlgorithm.SHA1) {
            ESSCertID essCertID = new ESSCertID(certHash, issuerSerial);
            SigningCertificate signingCertificate = new SigningCertificate(essCertID);
            attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)signingCertificate));
        } else {
            ESSCertIDv2 essCertIdv2 = new ESSCertIDv2(DSSASN1Utils.getAlgorithmIdentifier((DigestAlgorithm)digestAlgorithm), certHash, issuerSerial);
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(essCertIdv2);
            attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)signingCertificateV2));
        }
        signedAttributes.add((ASN1Encodable)attribute);
    }
}

