/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class CAdESLevelBaselineLT
extends CAdESSignatureExtension {
    private final CertificateVerifier certificateVerifier;
    private final CAdESLevelBaselineT cadesProfileT;

    public CAdESLevelBaselineLT(TSPSource signatureTsa, CertificateVerifier certificateVerifier, boolean onlyLastSigner) {
        super(signatureTsa, onlyLastSigner);
        this.certificateVerifier = certificateVerifier;
        this.cadesProfileT = new CAdESLevelBaselineT(signatureTsa, onlyLastSigner);
    }

    @Override
    protected SignerInformation extendCMSSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) throws DSSException {
        CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
        cadesSignature.setDetachedContents(parameters.getDetachedContents());
        if (!cadesSignature.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_T)) {
            signerInformation = this.cadesProfileT.extendCMSSignature(cmsSignedData, signerInformation, parameters);
        }
        return signerInformation;
    }

    @Override
    protected CMSSignedData postExtendCMSSignedData(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
        cadesSignature.setDetachedContents(parameters.getDetachedContents());
        ValidationContext validationContext = cadesSignature.getSignatureValidationContext(this.certificateVerifier);
        Store certificatesStore = cmsSignedData.getCertificates();
        Set certificates = cadesSignature.getCertificatesForInclusion(validationContext);
        HashSet<X509CertificateHolder> newCertificateStore = new HashSet<X509CertificateHolder>(certificatesStore.getMatches(null));
        for (CertificateToken certificateToken : certificates) {
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)certificateToken);
            newCertificateStore.add(x509CertificateHolder);
        }
        certificatesStore = new CollectionStore(newCertificateStore);
        Store crlsStore = cmsSignedData.getCRLs();
        HashSet<X509CRLHolder> newCrlsStore = new HashSet<X509CRLHolder>(crlsStore.getMatches(null));
        DefaultAdvancedSignature.RevocationDataForInclusion revocationDataForInclusion = cadesSignature.getRevocationDataForInclusion(validationContext);
        for (CRLToken crlToken : revocationDataForInclusion.crlTokens) {
            X509CRLHolder x509CRLHolder = this.getX509CrlHolder(crlToken);
            newCrlsStore.add(x509CRLHolder);
        }
        crlsStore = new CollectionStore(newCrlsStore);
        Store otherRevocationInfoFormatStoreBasic = cmsSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        HashSet<ASN1Primitive> newOtherRevocationInfoFormatStore = new HashSet<ASN1Primitive>(otherRevocationInfoFormatStoreBasic.getMatches(null));
        for (OCSPToken ocspToken : revocationDataForInclusion.ocspTokens) {
            BasicOCSPResp basicOCSPResp = ocspToken.getBasicOCSPResp();
            if (basicOCSPResp == null) continue;
            newOtherRevocationInfoFormatStore.add(DSSASN1Utils.toASN1Primitive((byte[])DSSASN1Utils.getEncoded((BasicOCSPResp)basicOCSPResp)));
        }
        otherRevocationInfoFormatStoreBasic = new CollectionStore(newOtherRevocationInfoFormatStore);
        Store attributeCertificatesStore = cmsSignedData.getAttributeCertificates();
        Store otherRevocationInfoFormatStoreOcsp = cmsSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        cmsSignedData = cmsSignedDataBuilder.regenerateCMSSignedData(cmsSignedData, parameters, certificatesStore, attributeCertificatesStore, crlsStore, otherRevocationInfoFormatStoreBasic, otherRevocationInfoFormatStoreOcsp);
        return cmsSignedData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509CRLHolder getX509CrlHolder(CRLToken crlToken) {
        try (InputStream is = crlToken.getCRLStream();){
            X509CRLHolder x509CRLHolder = new X509CRLHolder(is);
            return x509CRLHolder;
        }
        catch (IOException e) {
            throw new DSSException("Unable to convert X509CRL to X509CRLHolder", (Throwable)e);
        }
    }
}

