/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.OID;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineLTA
extends CAdESSignatureExtension {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineLTA.class);
    private final CAdESLevelBaselineLT cadesProfileLT;
    private final CertificateVerifier certificateVerifier;

    public CAdESLevelBaselineLTA(TSPSource signatureTsa, CertificateVerifier certificateVerifier, boolean onlyLastSigner) {
        super(signatureTsa, onlyLastSigner);
        this.cadesProfileLT = new CAdESLevelBaselineLT(signatureTsa, certificateVerifier, onlyLastSigner);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    protected CMSSignedData preExtendCMSSignedData(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        return this.cadesProfileLT.extendCMSSignatures(cmsSignedData, parameters);
    }

    @Override
    protected SignerInformation extendCMSSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) throws DSSException {
        CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
        cadesSignature.setDetachedContents(parameters.getDetachedContents());
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        unsignedAttributes = this.addArchiveTimestampV3Attribute(cadesSignature, cmsSignedData, signerInformation, parameters, unsignedAttributes);
        SignerInformation newSignerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
        return newSignerInformation;
    }

    private AttributeTable addArchiveTimestampV3Attribute(CAdESSignature cadesSignature, CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters, AttributeTable unsignedAttributes) throws DSSException {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(cadesSignature);
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        byte[] originalDocumentDigest = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (InputStream)cadesSignature.getOriginalDocumentStream());
        Attribute atsHashIndexAttribute = timestampExtractor.getAtsHashIndex(signerInformation, timestampDigestAlgorithm);
        byte[] encodedToTimestamp = timestampExtractor.getArchiveTimestampDataV3(signerInformation, atsHashIndexAttribute, originalDocumentDigest);
        ASN1Object timeStampAttributeValue = CAdESLevelBaselineLTA.getTimeStampAttributeValue(this.signatureTsa, encodedToTimestamp, timestampDigestAlgorithm, atsHashIndexAttribute);
        AttributeTable newUnsignedAttributes = unsignedAttributes.add(OID.id_aa_ets_archiveTimestampV3, (ASN1Encodable)timeStampAttributeValue);
        return newUnsignedAttributes;
    }
}

