/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSConfigurationException;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CAdESSignatureExtension
implements SignatureExtension<CAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignatureExtension.class);
    protected final TSPSource signatureTsa;
    private final boolean onlyLastCMSSignature;

    public CAdESSignatureExtension(TSPSource signatureTsa, boolean onlyLastCMSSignature) {
        this.signatureTsa = signatureTsa;
        this.onlyLastCMSSignature = onlyLastCMSSignature;
        if (signatureTsa == null) {
            throw new DSSConfigurationException(DSSConfigurationException.MSG.CONFIGURE_TSP_SERVER);
        }
    }

    public TSPSource getSignatureTsa() {
        return this.signatureTsa;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMSSignedDocument extendSignatures(DSSDocument signatureToExtend, CAdESSignatureParameters parameters) throws DSSException {
        LOG.info("EXTEND SIGNATURES.");
        try (InputStream inputStream = signatureToExtend.openStream();){
            CMSSignedDocument cmsSignedDocument;
            CMSSignedData cmsSignedData = new CMSSignedData(inputStream);
            CMSSignedData extendCMSSignedData = this.extendCMSSignatures(cmsSignedData, parameters);
            CMSSignedDocument cMSSignedDocument = cmsSignedDocument = new CMSSignedDocument(extendCMSSignedData);
            return cMSSignedDocument;
        }
        catch (IOException | CMSException e) {
            throw new DSSException("Cannot parse CMS data", e);
        }
    }

    public CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        CMSSignedData extendCMSSignedData = this.onlyLastCMSSignature ? this.extendLastCMSSignature(cmsSignedData, parameters) : this.extendAllCMSSignatures(cmsSignedData, parameters);
        return extendCMSSignedData;
    }

    private CMSSignedData extendAllCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        LOG.info("EXTEND ALL CMS SIGNATURES.");
        cmsSignedData = this.preExtendCMSSignedData(cmsSignedData, parameters);
        Collection signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationCollection) {
            CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
            cadesSignature.setDetachedContents(parameters.getDetachedContents());
            this.assertSignatureValid(cadesSignature, parameters);
            SignerInformation newSignerInformation = this.extendCMSSignature(cmsSignedData, signerInformation, parameters);
            newSignerInformationList.add(newSignerInformation);
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        cmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)newSignerStore);
        signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        for (SignerInformation signerInformation : signerInformationCollection) {
            cmsSignedData = this.postExtendCMSSignedData(cmsSignedData, signerInformation, parameters);
        }
        return cmsSignedData;
    }

    private CMSSignedData extendLastCMSSignature(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        LOG.info("EXTEND LAST CMS SIGNATURES.");
        cmsSignedData = this.preExtendCMSSignedData(cmsSignedData, parameters);
        Collection signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        SignerInformation lastSignerInformation = this.getFirstSigner(cmsSignedData);
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationCollection) {
            if (lastSignerInformation == signerInformation) {
                CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
                cadesSignature.setDetachedContents(parameters.getDetachedContents());
                this.assertSignatureValid(cadesSignature, parameters);
                SignerInformation newSignerInformation = this.extendCMSSignature(cmsSignedData, signerInformation, parameters);
                newSignerInformationList.add(newSignerInformation);
                continue;
            }
            newSignerInformationList.add(signerInformation);
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        cmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)newSignerStore);
        lastSignerInformation = this.getFirstSigner(cmsSignedData);
        cmsSignedData = this.postExtendCMSSignedData(cmsSignedData, lastSignerInformation, parameters);
        return cmsSignedData;
    }

    private SignerInformation getFirstSigner(CMSSignedData cmsSignedData) {
        SignerInformation lastSignerInformation;
        block0: {
            SignerInformation signerInformation;
            Collection signers = cmsSignedData.getSignerInfos().getSigners();
            lastSignerInformation = null;
            Iterator iterator = signers.iterator();
            if (!iterator.hasNext()) break block0;
            lastSignerInformation = signerInformation = (SignerInformation)iterator.next();
        }
        return lastSignerInformation;
    }

    private void assertSignatureValid(CAdESSignature cadesSignature, CAdESSignatureParameters parameters) {
        SignatureCryptographicVerification signatureCryptographicVerification;
        if (!SignatureForm.PAdES.equals((Object)parameters.getSignatureLevel().getSignatureForm()) && !(signatureCryptographicVerification = cadesSignature.getSignatureCryptographicVerification()).isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    protected abstract SignerInformation extendCMSSignature(CMSSignedData var1, SignerInformation var2, CAdESSignatureParameters var3) throws DSSException;

    protected CMSSignedData preExtendCMSSignedData(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        return cmsSignedData;
    }

    protected CMSSignedData postExtendCMSSignedData(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        return cmsSignedData;
    }

    protected ASN1Object getTimeStampAttributeValue(TSPSource tspSource, byte[] message, CAdESSignatureParameters parameters) {
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        ASN1Object signatureTimeStampValue = CAdESSignatureExtension.getTimeStampAttributeValue(tspSource, message, timestampDigestAlgorithm, new Attribute[0]);
        return signatureTimeStampValue;
    }

    public static ASN1Object getTimeStampAttributeValue(TSPSource tspSource, byte[] messageToTimestamp, DigestAlgorithm timestampDigestAlgorithm, Attribute ... attributesForTimestampToken) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message to timestamp is: " + Utils.toHex((byte[])messageToTimestamp));
            }
            byte[] timestampDigest = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])messageToTimestamp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Digested ({}) message to timestamp is {}", new Object[]{timestampDigestAlgorithm, Utils.toHex((byte[])timestampDigest)});
            }
            TimeStampToken timeStampToken = tspSource.getTimeStampResponse(timestampDigestAlgorithm, timestampDigest);
            CMSSignedData cmsSignedDataTimeStampToken = timeStampToken.toCMSSignedData();
            if (attributesForTimestampToken != null) {
                SignerInformation signerInformation = (SignerInformation)cmsSignedDataTimeStampToken.getSignerInfos().getSigners().iterator().next();
                AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
                for (Attribute attributeToAdd : attributesForTimestampToken) {
                    ASN1ObjectIdentifier attrType = attributeToAdd.getAttrType();
                    ASN1Encodable objectAt = attributeToAdd.getAttrValues().getObjectAt(0);
                    unsignedAttributes = unsignedAttributes.add(attrType, objectAt);
                }
                if (unsignedAttributes.size() == 0) {
                    unsignedAttributes = null;
                }
                SignerInformation newSignerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
                ArrayList<SignerInformation> signerInformationList = new ArrayList<SignerInformation>();
                signerInformationList.add(newSignerInformation);
                SignerInformationStore newSignerStore = new SignerInformationStore(signerInformationList);
                cmsSignedDataTimeStampToken = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedDataTimeStampToken, (SignerInformationStore)newSignerStore);
            }
            byte[] newTimeStampTokenBytes = cmsSignedDataTimeStampToken.getEncoded();
            return DSSASN1Utils.toASN1Primitive((byte[])newTimeStampTokenBytes);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }
}

