/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.OID;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CadesLevelBaselineLTATimestampExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(CadesLevelBaselineLTATimestampExtractor.class);
    public static final DigestAlgorithm DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO = DigestAlgorithm.SHA256;
    private static final boolean OMIT_ALGORITHM_IDENTIFIER_IF_DEFAULT = true;
    private DigestAlgorithm hashIndexDigestAlgorithm;
    private final Set<ASN1ObjectIdentifier> excludedAttributesFromAtsHashIndex = new HashSet<ASN1ObjectIdentifier>();
    private CAdESSignature cadesSignature;

    public CadesLevelBaselineLTATimestampExtractor(CAdESSignature cadesSignature) {
        this.cadesSignature = cadesSignature;
        this.excludedAttributesFromAtsHashIndex.add(PKCSObjectIdentifiers.id_aa_ets_certValues);
        this.excludedAttributesFromAtsHashIndex.add(PKCSObjectIdentifiers.id_aa_ets_revocationValues);
    }

    public Attribute getAtsHashIndex(SignerInformation signerInformation, DigestAlgorithm hashIndexDigestAlgorithm) throws DSSException {
        this.hashIndexDigestAlgorithm = hashIndexDigestAlgorithm;
        AlgorithmIdentifier algorithmIdentifier = this.getHashIndexDigestAlgorithmIdentifier();
        ASN1Sequence certificatesHashIndex = this.getCertificatesHashIndex();
        ASN1Sequence crLsHashIndex = this.getCRLsHashIndex();
        ASN1Sequence unsignedAttributesHashIndex = this.getUnsignedAttributesHashIndex(signerInformation);
        return this.getComposedAtsHashIndex(algorithmIdentifier, certificatesHashIndex, crLsHashIndex, unsignedAttributesHashIndex);
    }

    public Attribute getVerifiedAtsHashIndex(SignerInformation signerInformation, TimestampToken timestampToken) throws DSSException {
        AlgorithmIdentifier derObjectAlgorithmIdentifier = this.getAlgorithmIdentifier(timestampToken);
        ASN1Sequence certificatesHashIndex = this.getVerifiedCertificatesHashIndex(timestampToken);
        ASN1Sequence crLsHashIndex = this.getVerifiedCRLsHashIndex(timestampToken);
        ASN1Sequence unsignedAttributesHashIndex = this.getVerifiedUnsignedAttributesHashIndex(signerInformation, timestampToken);
        return this.getComposedAtsHashIndex(derObjectAlgorithmIdentifier, certificatesHashIndex, crLsHashIndex, unsignedAttributesHashIndex);
    }

    private Attribute getComposedAtsHashIndex(AlgorithmIdentifier algorithmIdentifiers, ASN1Sequence certificatesHashIndex, ASN1Sequence crLsHashIndex, ASN1Sequence unsignedAttributesHashIndex) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (algorithmIdentifiers != null) {
            vector.add((ASN1Encodable)algorithmIdentifiers);
        }
        vector.add((ASN1Encodable)certificatesHashIndex);
        vector.add((ASN1Encodable)crLsHashIndex);
        vector.add((ASN1Encodable)unsignedAttributesHashIndex);
        DERSequence derSequence = new DERSequence(vector);
        return new Attribute(OID.id_aa_ATSHashIndex, (ASN1Set)new DERSet((ASN1Encodable)derSequence));
    }

    private ASN1Sequence getCertificatesHashIndex() throws DSSException {
        ASN1EncodableVector certificatesHashIndexVector = new ASN1EncodableVector();
        List certificateTokens = this.cadesSignature.getCertificates();
        for (CertificateToken certificateToken : certificateTokens) {
            byte[] digest = certificateToken.getDigest(this.hashIndexDigestAlgorithm);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding to CertificatesHashIndex DSS-Identifier: {} with hash {}", (Object)certificateToken.getDSSId(), (Object)Utils.toHex((byte[])digest));
            }
            DEROctetString derOctetStringDigest = new DEROctetString(digest);
            certificatesHashIndexVector.add((ASN1Encodable)derOctetStringDigest);
        }
        return new DERSequence(certificatesHashIndexVector);
    }

    private ASN1Sequence getVerifiedCertificatesHashIndex(TimestampToken timestampToken) throws DSSException {
        ASN1Sequence certHashes = this.getCertificatesHashIndex(timestampToken);
        ArrayList certHashesList = new ArrayList();
        if (certHashes != null) {
            certHashesList.addAll(Collections.list(certHashes.getObjects()));
        }
        List certificates = this.cadesSignature.getCertificatesWithinSignatureAndTimestamps();
        for (CertificateToken certificateToken : certificates) {
            byte[] digest = certificateToken.getDigest(this.hashIndexDigestAlgorithm);
            DEROctetString derOctetStringDigest = new DEROctetString(digest);
            if (certHashesList.remove(derOctetStringDigest)) {
                LOG.debug("Cert {} present in timestamp", (Object)certificateToken.getAbbreviation());
                continue;
            }
            LOG.debug("Cert {} not present in timestamp", (Object)certificateToken.getAbbreviation());
        }
        if (!certHashesList.isEmpty()) {
            LOG.error("{} attribute hash in Cert Hashes have not been found in document attributes: {}", (Object)certHashesList.size(), certHashesList);
            return new DERSequence();
        }
        return certHashes;
    }

    private ASN1Sequence getCRLsHashIndex() throws DSSException {
        Enumeration crLs;
        ASN1EncodableVector crlsHashIndex = new ASN1EncodableVector();
        SignedData signedData = SignedData.getInstance((Object)this.cadesSignature.getCmsSignedData().toASN1Structure().getContent());
        ASN1Set signedDataCRLs = signedData.getCRLs();
        if (signedDataCRLs != null && (crLs = signedDataCRLs.getObjects()) != null) {
            while (crLs.hasMoreElements()) {
                ASN1Encodable asn1Encodable = (ASN1Encodable)crLs.nextElement();
                this.digestAndAddToList(crlsHashIndex, DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Encodable));
            }
        }
        return new DERSequence(crlsHashIndex);
    }

    private void digestAndAddToList(ASN1EncodableVector crlsHashIndex, byte[] encoded) {
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.hashIndexDigestAlgorithm, (byte[])encoded);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding to crlsHashIndex with hash {}", (Object)Utils.toHex((byte[])digest));
        }
        DEROctetString derOctetStringDigest = new DEROctetString(digest);
        crlsHashIndex.add((ASN1Encodable)derOctetStringDigest);
    }

    private ASN1Sequence getVerifiedCRLsHashIndex(TimestampToken timestampToken) throws DSSException {
        Enumeration crLs;
        SignedData signedData;
        ASN1Set signedDataCRLs;
        ASN1Sequence crlHashes = this.getCRLHashIndex(timestampToken);
        ArrayList<DEROctetString> crlHashesList = new ArrayList<DEROctetString>();
        if (crlHashes != null) {
            crlHashesList.addAll(Collections.list(crlHashes.getObjects()));
        }
        if ((signedDataCRLs = (signedData = SignedData.getInstance((Object)this.cadesSignature.getCmsSignedData().toASN1Structure().getContent())).getCRLs()) != null && (crLs = signedDataCRLs.getObjects()) != null) {
            while (crLs.hasMoreElements()) {
                ASN1Encodable asn1Encodable = (ASN1Encodable)crLs.nextElement();
                this.handleRevocationEncoded(crlHashesList, DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Encodable));
            }
        }
        if (!crlHashesList.isEmpty()) {
            LOG.error("{} attribute hash in CRL Hashes have not been found in document attributes: {}", (Object)crlHashesList.size(), crlHashesList);
            return new DERSequence();
        }
        return crlHashes;
    }

    private void handleRevocationEncoded(List<DEROctetString> crlHashesList, byte[] ocspHolderEncoded) {
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.hashIndexDigestAlgorithm, (byte[])ocspHolderEncoded);
        DEROctetString derOctetStringDigest = new DEROctetString(digest);
        if (crlHashesList.remove(derOctetStringDigest)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CRL/OCSP present in timestamp {}", (Object)DSSUtils.toHex((byte[])derOctetStringDigest.getOctets()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("CRL/OCSP not present in timestamp {}", (Object)DSSUtils.toHex((byte[])derOctetStringDigest.getOctets()));
        }
    }

    private boolean handleCrlEncoded(List<DEROctetString> crlHashesList, byte[] crlHolderEncoded) {
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.hashIndexDigestAlgorithm, (byte[])crlHolderEncoded);
        DEROctetString derOctetStringDigest = new DEROctetString(digest);
        return crlHashesList.remove(derOctetStringDigest);
    }

    private ASN1Sequence getUnsignedAttributesHashIndex(SignerInformation signerInformation) throws DSSException {
        ASN1EncodableVector unsignedAttributesHashIndex = new ASN1EncodableVector();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector asn1EncodableVector = unsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < asn1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)asn1EncodableVector.get(i);
            if (this.excludedAttributesFromAtsHashIndex.contains(attribute.getAttrType())) continue;
            DEROctetString derOctetStringDigest = this.getAttributeDerOctetStringHash(attribute);
            unsignedAttributesHashIndex.add((ASN1Encodable)derOctetStringDigest);
        }
        return new DERSequence(unsignedAttributesHashIndex);
    }

    private ASN1Sequence getVerifiedUnsignedAttributesHashIndex(SignerInformation signerInformation, TimestampToken timestampToken) throws DSSException {
        ASN1Sequence unsignedAttributesHashes = this.getUnsignedAttributesHashIndex(timestampToken);
        ArrayList timestampUnsignedAttributesHashesList = new ArrayList();
        if (unsignedAttributesHashes != null) {
            timestampUnsignedAttributesHashesList.addAll(Collections.list(unsignedAttributesHashes.getObjects()));
        }
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        ASN1EncodableVector asn1EncodableVector = unsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < asn1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)asn1EncodableVector.get(i);
            DEROctetString derOctetStringDigest = this.getAttributeDerOctetStringHash(attribute);
            ASN1ObjectIdentifier attrType = attribute.getAttrType();
            if (timestampUnsignedAttributesHashesList.remove(derOctetStringDigest)) {
                LOG.debug("Attribute {} present in timestamp", (Object)attrType.getId());
                continue;
            }
            LOG.debug("Attribute {} not present in timestamp", (Object)attrType.getId());
        }
        if (!timestampUnsignedAttributesHashesList.isEmpty()) {
            LOG.error("{} attribute hash in Timestamp have not been found in document attributes: {}", (Object)timestampUnsignedAttributesHashesList.size(), timestampUnsignedAttributesHashesList);
            return new DERSequence();
        }
        return unsignedAttributesHashes;
    }

    private DEROctetString getAttributeDerOctetStringHash(Attribute attribute) throws DSSException {
        byte[] attributeEncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute);
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.hashIndexDigestAlgorithm, (byte[])attributeEncoded);
        return new DEROctetString(digest);
    }

    private ASN1Sequence getUnsignedAttributesHashIndex(TimestampToken timestampToken) {
        ASN1Sequence timestampAttributeAtsHashIndexValue = this.getAtsHashIndex(timestampToken);
        if (timestampAttributeAtsHashIndexValue != null) {
            int unsignedAttributesIndex = 2;
            if (timestampAttributeAtsHashIndexValue.size() > 3) {
                ++unsignedAttributesIndex;
            }
            return (ASN1Sequence)timestampAttributeAtsHashIndexValue.getObjectAt(unsignedAttributesIndex).toASN1Primitive();
        }
        return null;
    }

    private ASN1Sequence getCRLHashIndex(TimestampToken timestampToken) {
        ASN1Sequence timestampAttributeAtsHashIndexValue = this.getAtsHashIndex(timestampToken);
        if (timestampAttributeAtsHashIndexValue != null) {
            int crlIndex = 1;
            if (timestampAttributeAtsHashIndexValue.size() > 3) {
                ++crlIndex;
            }
            return (ASN1Sequence)timestampAttributeAtsHashIndexValue.getObjectAt(crlIndex).toASN1Primitive();
        }
        return null;
    }

    private ASN1Sequence getCertificatesHashIndex(TimestampToken timestampToken) {
        ASN1Sequence timestampAttributeAtsHashIndexValue = this.getAtsHashIndex(timestampToken);
        if (timestampAttributeAtsHashIndexValue != null) {
            int certificateIndex = 0;
            if (timestampAttributeAtsHashIndexValue.size() > 3) {
                ++certificateIndex;
            }
            return (ASN1Sequence)timestampAttributeAtsHashIndexValue.getObjectAt(certificateIndex).toASN1Primitive();
        }
        return null;
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(TimestampToken timestampToken) {
        ASN1Sequence timestampAttributeAtsHashIndexValue = this.getAtsHashIndex(timestampToken);
        if (timestampAttributeAtsHashIndexValue != null && timestampAttributeAtsHashIndexValue.size() > 3) {
            boolean algorithmIndex = false;
            ASN1Encodable asn1Encodable = timestampAttributeAtsHashIndexValue.getObjectAt(0);
            if (asn1Encodable instanceof ASN1Sequence) {
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable;
                ASN1ObjectIdentifier asn1ObjectIdentifier = (ASN1ObjectIdentifier)asn1Sequence.getObjectAt(0);
                this.hashIndexDigestAlgorithm = DigestAlgorithm.forOID((String)asn1ObjectIdentifier.getId());
                return AlgorithmIdentifier.getInstance((Object)asn1Sequence);
            }
            if (asn1Encodable instanceof ASN1ObjectIdentifier) {
                ASN1ObjectIdentifier derObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)asn1Encodable);
                this.hashIndexDigestAlgorithm = DigestAlgorithm.forOID((String)derObjectIdentifier.getId());
                return new AlgorithmIdentifier(derObjectIdentifier);
            }
        }
        this.hashIndexDigestAlgorithm = DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
        return null;
    }

    private ASN1Sequence getAtsHashIndex(TimestampToken timestampToken) {
        ASN1Set attrValues;
        AttributeTable timestampTokenUnsignedAttributes = timestampToken.getUnsignedAttributes();
        Attribute atsHashIndexAttribute = timestampTokenUnsignedAttributes.get(OID.id_aa_ATSHashIndex);
        if (atsHashIndexAttribute != null && (attrValues = atsHashIndexAttribute.getAttrValues()) != null && attrValues.size() > 0) {
            return (ASN1Sequence)attrValues.getObjectAt(0).toASN1Primitive();
        }
        return null;
    }

    private AlgorithmIdentifier getHashIndexDigestAlgorithmIdentifier() {
        if (this.hashIndexDigestAlgorithm.getOid().equals(DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO.getOid())) {
            return null;
        }
        return DSSASN1Utils.getAlgorithmIdentifier((DigestAlgorithm)this.hashIndexDigestAlgorithm);
    }

    public byte[] getArchiveTimestampDataV3(SignerInformation signerInformation, Attribute atsHashIndexAttribute, byte[] originalDocumentDigest) throws DSSException {
        CMSSignedData cmsSignedData = this.cadesSignature.getCmsSignedData();
        byte[] encodedContentType = this.getEncodedContentType(cmsSignedData);
        byte[] signedDataDigest = originalDocumentDigest;
        byte[] encodedFields = this.getSignedFields(signerInformation);
        byte[] encodedAtsHashIndex = DSSASN1Utils.getDEREncoded((ASN1Encodable)atsHashIndexAttribute.getAttrValues().getObjectAt(0));
        byte[] dataToTimestamp = DSSUtils.concatenate((byte[][])new byte[][]{encodedContentType, signedDataDigest, encodedFields, encodedAtsHashIndex});
        if (LOG.isDebugEnabled()) {
            LOG.debug("eContentType={}", (Object)Utils.toHex((byte[])encodedContentType));
            LOG.debug("signedDataDigest={}", (Object)Utils.toHex((byte[])signedDataDigest));
            LOG.debug("encodedFields=see above");
            LOG.debug("encodedAtsHashIndex={}", (Object)Utils.toHex((byte[])encodedAtsHashIndex));
        }
        return dataToTimestamp;
    }

    private byte[] getEncodedContentType(CMSSignedData cmsSignedData) {
        ContentInfo contentInfo = cmsSignedData.toASN1Structure();
        SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
        return DSSASN1Utils.getDEREncoded((ASN1Encodable)signedData.getEncapContentInfo().getContentType());
    }

    private byte[] getSignedFields(SignerInformation signerInformation) {
        SignerInfo signerInfo = signerInformation.toASN1Structure();
        ASN1Integer version = signerInfo.getVersion();
        SignerIdentifier sid = signerInfo.getSID();
        AlgorithmIdentifier digestAlgorithm = signerInfo.getDigestAlgorithm();
        DERTaggedObject signedAttributes = CMSUtils.getDERSignedAttributes(signerInformation);
        AlgorithmIdentifier digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        ASN1OctetString encryptedDigest = signerInfo.getEncryptedDigest();
        byte[] derEncodedVersion = DSSASN1Utils.getDEREncoded((ASN1Encodable)version);
        byte[] derEncodedSid = DSSASN1Utils.getDEREncoded((ASN1Encodable)sid);
        byte[] derEncodedDigestAlgorithm = DSSASN1Utils.getDEREncoded((ASN1Encodable)digestAlgorithm);
        byte[] derEncodedSignedAttributes = DSSASN1Utils.getDEREncoded((ASN1Encodable)signedAttributes);
        byte[] derEncodedDigestEncryptionAlgorithm = DSSASN1Utils.getDEREncoded((ASN1Encodable)digestEncryptionAlgorithm);
        byte[] derEncodedEncryptedDigest = DSSASN1Utils.getDEREncoded((ASN1Encodable)encryptedDigest);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields Version={}", (Object)Utils.toBase64((byte[])derEncodedVersion));
            LOG.debug("getSignedFields Sid={}", (Object)Utils.toBase64((byte[])derEncodedSid));
            LOG.debug("getSignedFields DigestAlgorithm={}", (Object)Utils.toBase64((byte[])derEncodedDigestAlgorithm));
            LOG.debug("getSignedFields SignedAttributes={}", (Object)Utils.toBase64((byte[])derEncodedSignedAttributes));
            LOG.debug("getSignedFields DigestEncryptionAlgorithm={}", (Object)Utils.toBase64((byte[])derEncodedDigestEncryptionAlgorithm));
            LOG.debug("getSignedFields EncryptedDigest={}", (Object)Utils.toBase64((byte[])derEncodedEncryptedDigest));
        }
        byte[] concatenatedArrays = DSSUtils.concatenate((byte[][])new byte[][]{derEncodedVersion, derEncodedSid, derEncodedDigestAlgorithm, derEncodedSignedAttributes, derEncodedDigestEncryptionAlgorithm, derEncodedEncryptedDigest});
        return concatenatedArrays;
    }
}

