/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESOCSPSource.class);
    private CMSSignedData cmsSignedData;
    private SignerInformation signerInformation;

    public CAdESOCSPSource(CMSSignedData cms, SignerInformation signerInformation) {
        this.cmsSignedData = cms;
        this.signerInformation = signerInformation;
    }

    public List<BasicOCSPResp> getContainedOCSPResponses() {
        Attribute attribute;
        AttributeTable attributes;
        ArrayList<BasicOCSPResp> basicOCSPResps = new ArrayList<BasicOCSPResp>();
        this.addBasicOcspRespFrom_id_pkix_ocsp_basic(basicOCSPResps);
        this.addBasicOcspRespFrom_id_ri_ocsp_response(basicOCSPResps);
        if (this.signerInformation != null && (attributes = this.signerInformation.getUnsignedAttributes()) != null && (attribute = attributes.get(PKCSObjectIdentifiers.id_aa_ets_revocationValues)) != null) {
            ASN1Set attrValues = attribute.getAttrValues();
            ASN1Encodable attValue = attrValues.getObjectAt(0);
            RevocationValues revocationValues = RevocationValues.getInstance((Object)attValue);
            for (BasicOCSPResponse basicOCSPResponse : revocationValues.getOcspVals()) {
                BasicOCSPResp basicOCSPResp = new BasicOCSPResp(basicOCSPResponse);
                this.addBasicOcspResp(basicOCSPResps, basicOCSPResp);
            }
        }
        return basicOCSPResps;
    }

    private void addBasicOcspRespFrom_id_ri_ocsp_response(List<BasicOCSPResp> basicOCSPResps) {
        Store otherRevocationInfo = this.cmsSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        Collection otherRevocationInfoMatches = otherRevocationInfo.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof DERSequence) {
                BasicOCSPResp basicOCSPResp;
                DERSequence otherRevocationInfoMatch = (DERSequence)object;
                if (otherRevocationInfoMatch.size() == 4) {
                    basicOCSPResp = CMSUtils.getBasicOcspResp(otherRevocationInfoMatch);
                } else {
                    OCSPResp ocspResp = CMSUtils.getOcspResp(otherRevocationInfoMatch);
                    basicOCSPResp = CMSUtils.getBasicOCSPResp(ocspResp);
                }
                this.addBasicOcspResp(basicOCSPResps, basicOCSPResp);
                continue;
            }
            LOG.warn("Unsupported object type for id_ri_ocsp_response (SHALL be DER encoding) : " + object.getClass().getSimpleName());
        }
    }

    private void addBasicOcspRespFrom_id_pkix_ocsp_basic(List<BasicOCSPResp> basicOCSPResps) {
        Store otherRevocationInfo = this.cmsSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        Collection otherRevocationInfoMatches = otherRevocationInfo.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof DERSequence) {
                DERSequence otherRevocationInfoMatch = (DERSequence)object;
                BasicOCSPResp basicOCSPResp = CMSUtils.getBasicOcspResp(otherRevocationInfoMatch);
                this.addBasicOcspResp(basicOCSPResps, basicOCSPResp);
                continue;
            }
            LOG.warn("Unsupported object type for id_pkix_ocsp_basic (SHALL be DER encoding) : " + object.getClass().getSimpleName());
        }
    }

    private void addBasicOcspResp(List<BasicOCSPResp> basicOCSPResps, BasicOCSPResp basicOCSPResp) {
        if (basicOCSPResp != null) {
            basicOCSPResps.add(basicOCSPResp);
        }
    }
}

