/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.cades.SignedAssertion;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class SignedAssertions
extends ASN1Object {
    private final List<SignedAssertion> assertions;

    public static SignedAssertions getInstance(Object obj) {
        if (obj instanceof SignedAssertion) {
            return (SignedAssertions)((Object)obj);
        }
        if (obj != null) {
            return new SignedAssertions(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public SignedAssertions(List<SignedAssertion> assertions) {
        this.assertions = assertions;
    }

    private SignedAssertions(ASN1Sequence seq) {
        this.assertions = new ArrayList<SignedAssertion>(seq.size());
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            this.assertions.add(SignedAssertion.getInstance(e.nextElement()));
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (SignedAssertion sa : this.assertions) {
            v.add((ASN1Encodable)sa);
        }
        return new DERSequence(v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SignedAssertion sa : this.assertions) {
            sb.append(sa.toString()).append("\n");
        }
        return sb.toString();
    }

    public List<SignedAssertion> getAssertions() {
        return this.assertions;
    }
}

