/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineT
extends CAdESSignatureExtension {
    public CAdESLevelBaselineT(TSPSource tspSource, boolean onlyLastCMSSignature) {
        super(tspSource, onlyLastCMSSignature);
    }

    @Override
    protected SignerInformation extendCMSSignature(CMSSignedData signedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) throws DSSException {
        CAdESSignature cadesSignature = this.newCAdESSignature(signedData, signerInformation, parameters.getDetachedContents());
        this.assertExtendSignaturePossible(cadesSignature);
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        unsignedAttributes = this.addSignatureTimestampAttribute(signerInformation, unsignedAttributes, parameters);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
    }

    private void assertExtendSignaturePossible(CAdESSignature cadesSignature) throws DSSException {
        String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
        if (SignatureLevel.CAdES_BASELINE_LTA.equals((Object)cadesSignature.getDataFoundUpToLevel())) {
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "CAdES LTA"));
        }
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(cadesSignature.getSignerInformation());
        if (unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) != null) {
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.getId()));
        }
    }

    private AttributeTable addSignatureTimestampAttribute(SignerInformation signerInformation, AttributeTable unsignedAttributes, CAdESSignatureParameters parameters) {
        ASN1Object signatureTimeStamp = this.getTimeStampAttributeValue(signerInformation.getSignature(), parameters);
        return unsignedAttributes.add(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Encodable)signatureTimeStamp);
    }
}

