/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESSignedAttributes;
import eu.europa.esig.dss.cades.validation.CAdESTimestampDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CMSCRLSource;
import eu.europa.esig.dss.validation.CMSCertificateSource;
import eu.europa.esig.dss.validation.CMSOCSPSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampSource
extends AbstractTimestampSource<CAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampSource.class);
    protected final transient SignerInformation signerInformation;
    protected final transient CMSSignedData cmsSignedData;
    protected final transient List<DSSDocument> detachedDocuments;

    public CAdESTimestampSource(CAdESSignature signature) {
        super((AdvancedSignature)signature);
        this.cmsSignedData = signature.getCmsSignedData();
        this.detachedDocuments = signature.getDetachedContents();
        this.signerInformation = signature.getSignerInformation();
    }

    protected CAdESTimestampDataBuilder getTimestampDataBuilder() {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(this.cmsSignedData, this.certificateSource.getAllCertificateTokens());
        return new CAdESTimestampDataBuilder(this.cmsSignedData, this.signerInformation, this.detachedDocuments, timestampExtractor);
    }

    protected SignatureProperties<CAdESAttribute> getSignedSignatureProperties() {
        return CAdESSignedAttributes.build(this.signerInformation);
    }

    protected SignatureProperties<CAdESAttribute> getUnsignedSignatureProperties() {
        return CAdESUnsignedAttributes.build(this.signerInformation);
    }

    protected boolean isContentTimestamp(CAdESAttribute signedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_contentTimestamp.equals((ASN1Primitive)signedAttribute.getASN1Oid());
    }

    protected boolean isAllDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isIndividualDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isSignatureTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certificateRefs.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeCertificateRefsOid.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationRefs.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeRevocationRefsOid.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certValues.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationValues.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttrAuthoritiesCertValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return this.isArchiveTimestampV2(unsignedAttribute) || this.isArchiveTimestampV3(unsignedAttribute);
    }

    private boolean isArchiveTimestampV2(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV2.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    private boolean isArchiveTimestampV3(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV3.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isTimeStampValidationData(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected TimestampToken makeTimestampToken(CAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        TimeStampToken timestamp = signatureAttribute.toTimeStampToken();
        if (timestamp == null) {
            return null;
        }
        return new TimestampToken(timestamp, timestampType, references, TimestampLocation.CAdES);
    }

    protected List<TimestampedReference> getIndividualContentTimestampedReferences(CAdESAttribute signedAttribute) {
        throw new DSSException("Not applicable for CAdES!");
    }

    protected List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken timestampToken) {
        return this.getSignedDataReferences(timestampToken);
    }

    protected List<TimestampedReference> getSignedDataReferences(TimestampToken timestampToken) {
        if (ArchiveTimestampType.CAdES_V2.equals((Object)timestampToken.getArchiveTimestampType()) || ArchiveTimestampType.CAdES.equals((Object)timestampToken.getArchiveTimestampType())) {
            return this.getSignatureSignedDataReferences();
        }
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        ASN1Sequence atsHashIndex = DSSASN1Utils.getAtsHashIndex((AttributeTable)timestampToken.getUnsignedAttributes());
        if (atsHashIndex != null) {
            DigestAlgorithm digestAlgorithm = this.getHashIndexDigestAlgorithm(atsHashIndex);
            List<TimestampedReference> certificateReferences = this.getSignedDataCertificateReferences(atsHashIndex, digestAlgorithm, timestampToken.getDSSIdAsString());
            references.addAll(certificateReferences);
            List<TimestampedReference> revocationReferences = this.getSignedDataRevocationReferences(atsHashIndex, digestAlgorithm, timestampToken.getDSSIdAsString());
            references.addAll(revocationReferences);
        }
        return references;
    }

    private List<TimestampedReference> getSignedDataCertificateReferences(ASN1Sequence atsHashIndex, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureCertificateSource instanceof CMSCertificateSource) {
            ASN1Sequence certsHashIndex = DSSASN1Utils.getCertificatesHashIndex((ASN1Sequence)atsHashIndex);
            List certsHashList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)certsHashIndex);
            for (CertificateToken certificate : this.signatureCertificateSource.getSignedDataCertificates()) {
                if (this.isDigestValuePresent(certificate.getDigest(digestAlgorithm), certsHashList)) {
                    this.addReference(references, (Identifier)certificate.getDSSId(), TimestampedObjectType.CERTIFICATE);
                    continue;
                }
                LOG.warn("The certificate with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)certificate.getDSSIdAsString(), (Object)timestampId);
            }
        }
        return references;
    }

    private List<TimestampedReference> getSignedDataRevocationReferences(ASN1Sequence atsHashIndex, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        ASN1Sequence crlsHashIndex = DSSASN1Utils.getCRLHashIndex((ASN1Sequence)atsHashIndex);
        List crlsHashList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)crlsHashIndex);
        if (this.signatureCRLSource instanceof CMSCRLSource) {
            CMSCRLSource cmsCRLSource = (CMSCRLSource)this.signatureCRLSource;
            for (EncapsulatedRevocationTokenIdentifier token : cmsCRLSource.getCMSSignedDataRevocationBinaries()) {
                if (this.isDigestValuePresent(token.getDigestValue(digestAlgorithm), crlsHashList)) {
                    this.addReference(references, (Identifier)token, TimestampedObjectType.REVOCATION);
                    continue;
                }
                LOG.warn("The CRL Token with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)token.asXmlId(), (Object)timestampId);
            }
        }
        List<TimestampedReference> ocspReferences = this.getSignedDataOCSPReferences(crlsHashList, digestAlgorithm, timestampId);
        references.addAll(ocspReferences);
        return references;
    }

    private List<TimestampedReference> getSignedDataOCSPReferences(List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureOCSPSource instanceof CMSOCSPSource) {
            CMSOCSPSource cmsocspSource = (CMSOCSPSource)this.signatureOCSPSource;
            for (EncapsulatedRevocationTokenIdentifier token : cmsocspSource.getCMSSignedDataRevocationBinaries()) {
                OCSPResponseBinary binary = (OCSPResponseBinary)token;
                OtherRevocationInfoFormat otherRevocationInfoFormat = new OtherRevocationInfoFormat(binary.getAsn1ObjectIdentifier(), (ASN1Encodable)DSSASN1Utils.toASN1Primitive((byte[])binary.getBasicOCSPRespContent()));
                DERTaggedObject derTaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)otherRevocationInfoFormat);
                if (this.isDigestValuePresent(DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)derTaggedObject)), crlsHashList)) {
                    this.addReference(references, (Identifier)binary, TimestampedObjectType.REVOCATION);
                    continue;
                }
                LOG.warn("The OCSP Token with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)binary.asXmlId(), (Object)timestampId);
            }
        }
        return references;
    }

    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureCertificateSource instanceof CMSCertificateSource) {
            this.addReferences(references, this.createReferencesForCertificates(this.signatureCertificateSource.getSignedDataCertificates()));
        }
        if (this.signatureCRLSource instanceof CMSCRLSource) {
            for (EncapsulatedRevocationTokenIdentifier token : ((CMSCRLSource)this.signatureCRLSource).getCMSSignedDataRevocationBinaries()) {
                this.addReference(references, (Identifier)token, TimestampedObjectType.REVOCATION);
            }
        }
        if (this.signatureOCSPSource instanceof CMSOCSPSource) {
            for (EncapsulatedRevocationTokenIdentifier token : ((CMSOCSPSource)this.signatureOCSPSource).getCMSSignedDataRevocationBinaries()) {
                this.addReference(references, (Identifier)token, TimestampedObjectType.REVOCATION);
            }
        }
        return references;
    }

    private DigestAlgorithm getHashIndexDigestAlgorithm(ASN1Sequence atsHashIndex) {
        AlgorithmIdentifier algorithmIdentifier = DSSASN1Utils.getAlgorithmIdentifier((ASN1Sequence)atsHashIndex);
        return algorithmIdentifier != null ? DigestAlgorithm.forOID((String)algorithmIdentifier.getAlgorithm().getId()) : CMSUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
    }

    private boolean isDigestValuePresent(byte[] digestValue, List<DEROctetString> hashList) {
        return hashList.contains(new DEROctetString(digestValue));
    }

    protected List<CertificateRef> getCertificateRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> certRefs = new ArrayList<CertificateRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            OtherCertID otherCertId = OtherCertID.getInstance((Object)seq.getObjectAt(ii));
            certRefs.add(DSSASN1Utils.getCertificateRef((OtherCertID)otherCertId));
        }
        return certRefs;
    }

    protected List<CRLRef> getCRLRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CRLRef> refs = new ArrayList<CRLRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            CrlOcspRef otherRefId = CrlOcspRef.getInstance((Object)seq.getObjectAt(ii));
            CrlListID otherCrlIds = otherRefId.getCrlids();
            if (otherCrlIds == null) continue;
            for (CrlValidatedID id : otherCrlIds.getCrls()) {
                refs.add(new CRLRef(id));
            }
        }
        return refs;
    }

    protected List<OCSPRef> getOCSPRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<OCSPRef> refs = new ArrayList<OCSPRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int i = 0; i < seq.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance((Object)seq.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                refs.add(new OCSPRef(ocspResponsesID));
            }
        }
        return refs;
    }

    protected List<Identifier> getEncapsulatedCertificateIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            try {
                Certificate cs = Certificate.getInstance((Object)seq.getObjectAt(ii));
                CertificateToken certificateToken = DSSUtils.loadCertificate((byte[])cs.getEncoded());
                certificateIdentifiers.add((Identifier)certificateToken.getDSSId());
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    protected List<Identifier> getEncapsulatedCRLIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> crlBinaryIdentifiers = new ArrayList<Identifier>();
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues((ASN1Encodable)asn1Object);
        if (revocationValues != null) {
            for (CertificateList revValue : revocationValues.getCrlVals()) {
                try {
                    crlBinaryIdentifiers.add((Identifier)CRLUtils.buildCRLBinary((byte[])revValue.getEncoded()));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse CRL binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return crlBinaryIdentifiers;
    }

    protected List<Identifier> getEncapsulatedOCSPIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> ocspIdentifiers = new ArrayList<Identifier>();
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues((ASN1Encodable)asn1Object);
        if (revocationValues != null) {
            for (BasicOCSPResponse basicOCSPResponse : revocationValues.getOcspVals()) {
                try {
                    BasicOCSPResp basicOCSPResp = new BasicOCSPResp(basicOCSPResponse);
                    ocspIdentifiers.add((Identifier)OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse OCSP response binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return ocspIdentifiers;
    }

    protected ArchiveTimestampType getArchiveTimestampType(CAdESAttribute unsignedAttribute) {
        if (OID.id_aa_ets_archiveTimestampV2.equals((ASN1Primitive)unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V2;
        }
        if (OID.id_aa_ets_archiveTimestampV3.equals((ASN1Primitive)unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V3;
        }
        return ArchiveTimestampType.CAdES;
    }

    protected void addEncapsulatedValuesFromTimestamp(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        super.addEncapsulatedValuesFromTimestamp(references, timestampedTimestamp);
        TimestampCRLSource timeStampCRLSource = timestampedTimestamp.getCRLSource();
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampCRLSource.getAllRevocationBinaries()) {
            this.addReference(references, (Identifier)binary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampCRLSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, (Identifier)binary, TimestampedObjectType.REVOCATION);
        }
        TimestampOCSPSource timeStampOCSPSource = timestampedTimestamp.getOCSPSource();
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampOCSPSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, (Identifier)binary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampOCSPSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, (Identifier)binary, TimestampedObjectType.REVOCATION);
        }
    }
}

