/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignedAssertion;
import eu.europa.esig.dss.cades.SignedAssertions;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignaturePolicyIdentifier;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineB {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineB.class);
    private final boolean padesUsage;

    public CAdESLevelBaselineB() {
        this(false);
    }

    public CAdESLevelBaselineB(boolean padesUsage) {
        this.padesUsage = padesUsage;
    }

    public AttributeTable getUnsignedAttributes() {
        return new AttributeTable(new Hashtable());
    }

    public AttributeTable getSignedAttributes(CAdESSignatureParameters parameters) {
        if (Utils.isArrayNotEmpty((byte[])parameters.getSignedData())) {
            LOG.debug("Using explict SignedAttributes from parameter");
            return CMSUtils.getAttributesFromByteArray(parameters.getSignedData());
        }
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        this.addSigningCertificateAttribute(parameters, signedAttributes);
        this.addSigningTimeAttribute(parameters, signedAttributes);
        this.addSignerAttribute(parameters, signedAttributes);
        this.addSignaturePolicyId(parameters, signedAttributes);
        this.addContentHints(parameters, signedAttributes);
        this.addContentIdentifier(parameters, signedAttributes);
        this.addCommitmentType(parameters, signedAttributes);
        this.addSignerLocation(parameters, signedAttributes);
        this.addContentTimestamps(parameters, signedAttributes);
        return new AttributeTable(signedAttributes);
    }

    private void addSignerAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List claimedSignerRoles = parameters.bLevel().getClaimedSignerRoles();
        if (claimedSignerRoles != null) {
            ArrayList<Attribute> claimedAttributes = new ArrayList<Attribute>(claimedSignerRoles.size());
            for (String claimedSignerRole : claimedSignerRoles) {
                DERUTF8String roles = new DERUTF8String(claimedSignerRole);
                Attribute id_aa_ets_signerAttr = new Attribute(OID.id_at_role, (ASN1Set)new DERSet((ASN1Encodable)roles));
                claimedAttributes.add(id_aa_ets_signerAttr);
            }
            org.bouncycastle.asn1.cms.Attribute signerAttributes = !parameters.isEn319122() ? new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttribute(claimedAttributes.toArray(new Attribute[claimedAttributes.size()])))) : new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_signerAttrV2, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttributeV2(claimedAttributes.toArray(new Attribute[claimedAttributes.size()]))));
            signedAttributes.add((ASN1Encodable)signerAttributes);
            return;
        }
        List signedAssertions = parameters.bLevel().getSignedAssertions();
        if (signedAssertions != null && parameters.isEn319122()) {
            ArrayList<SignedAssertion> assertionsToAdd = new ArrayList<SignedAssertion>();
            for (String signedAssertion : signedAssertions) {
                SignedAssertion sa = new SignedAssertion(signedAssertion);
                assertionsToAdd.add(sa);
            }
            if (!assertionsToAdd.isEmpty()) {
                org.bouncycastle.asn1.cms.Attribute signerAttributes = new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_signerAttrV2, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttributeV2(new SignedAssertions(assertionsToAdd))));
                signedAttributes.add((ASN1Encodable)signerAttributes);
            }
        }
    }

    private void addSigningTimeAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        Date signingDate = parameters.bLevel().getSigningDate();
        if (signingDate != null) {
            DERSet attrValues = new DERSet((ASN1Encodable)new Time(signingDate));
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSignerLocation(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        eu.europa.esig.dss.model.SignerLocation signerLocationParameter = parameters.bLevel().getSignerLocation();
        if (signerLocationParameter != null && !signerLocationParameter.isEmpty()) {
            DERUTF8String country = signerLocationParameter.getCountry() == null ? null : new DERUTF8String(signerLocationParameter.getCountry());
            DERUTF8String locality = signerLocationParameter.getLocality() == null ? null : new DERUTF8String(signerLocationParameter.getLocality());
            DERSequence derSequencePostalAddress = this.getPostalAddressSequence(signerLocationParameter.getPostalAddress());
            SignerLocation signerLocation = new SignerLocation(country, locality, (ASN1Sequence)derSequencePostalAddress);
            DERSet attrValues = new DERSet((ASN1Encodable)signerLocation);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private DERSequence getPostalAddressSequence(List<String> postalAddressParameter) {
        DERSequence derSequencePostalAddress = null;
        if (Utils.isCollectionNotEmpty(postalAddressParameter)) {
            ASN1EncodableVector postalAddress = new ASN1EncodableVector();
            for (String addressLine : postalAddressParameter) {
                postalAddress.add((ASN1Encodable)new DERUTF8String(addressLine));
            }
            derSequencePostalAddress = new DERSequence(postalAddress);
        }
        return derSequencePostalAddress;
    }

    private void addCommitmentType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List commitmentTypeIndications = parameters.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty((Collection)commitmentTypeIndications)) {
            int size = commitmentTypeIndications.size();
            ASN1Encodable[] asn1Encodables = new ASN1Encodable[size];
            for (int ii = 0; ii < size; ++ii) {
                CommitmentType commitmentType = (CommitmentType)commitmentTypeIndications.get(ii);
                if (commitmentType.getOid() == null) {
                    throw new DSSException("The commitmentTypeIndication OID must be defined for CAdES creation!");
                }
                ASN1ObjectIdentifier objectIdentifier = new ASN1ObjectIdentifier(commitmentType.getOid());
                CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(objectIdentifier);
                asn1Encodables[ii] = commitmentTypeIndication.toASN1Primitive();
            }
            DERSet attrValues = new DERSet(asn1Encodables);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addContentTimestamps(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isCollectionNotEmpty((Collection)parameters.getContentTimestamps())) {
            List contentTimestamps = parameters.getContentTimestamps();
            for (TimestampToken contentTimestamp : contentTimestamps) {
                ASN1Primitive asn1Object = DSSASN1Utils.toASN1Primitive((byte[])contentTimestamp.getEncoded());
                DERSet attrValues = new DERSet((ASN1Encodable)asn1Object);
                org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp, (ASN1Set)attrValues);
                signedAttributes.add((ASN1Encodable)attribute);
            }
        }
    }

    private void addContentHints(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isStringNotBlank((String)parameters.getContentHintsType())) {
            ASN1ObjectIdentifier contentHintsType = new ASN1ObjectIdentifier(parameters.getContentHintsType());
            String contentHintsDescriptionString = parameters.getContentHintsDescription();
            DERUTF8String contentHintsDescription = Utils.isStringBlank((String)contentHintsDescriptionString) ? null : new DERUTF8String(contentHintsDescriptionString);
            ContentHints contentHints = new ContentHints(contentHintsType, contentHintsDescription);
            DERSet attrValues = new DERSet((ASN1Encodable)contentHints);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentHint, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addContentIdentifier(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        String contentIdentifierPrefix = parameters.getContentIdentifierPrefix();
        if (Utils.isStringNotBlank((String)contentIdentifierPrefix)) {
            if (Utils.isStringBlank((String)parameters.getContentIdentifierSuffix())) {
                StringBuilder suffixBuilder = new StringBuilder();
                suffixBuilder.append(new ASN1GeneralizedTime(new Date()).getTimeString());
                suffixBuilder.append(new SecureRandom().nextLong());
                parameters.setContentIdentifierSuffix(suffixBuilder.toString());
            }
            String contentIdentifierString = contentIdentifierPrefix + parameters.getContentIdentifierSuffix();
            ContentIdentifier contentIdentifier = new ContentIdentifier(contentIdentifierString.getBytes());
            DERSet attrValues = new DERSet((ASN1Encodable)contentIdentifier);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentIdentifier, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSignaturePolicyId(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        Policy policy = parameters.bLevel().getSignaturePolicy();
        if (policy != null) {
            String policyId = policy.getId();
            SignaturePolicyIdentifier sigPolicy = null;
            if (Utils.isStringEmpty((String)policyId)) {
                sigPolicy = new SignaturePolicyIdentifier();
            } else {
                ASN1ObjectIdentifier derOIPolicyId = new ASN1ObjectIdentifier(policyId);
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(policy.getDigestAlgorithm().getOid());
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(oid);
                OtherHashAlgAndValue otherHashAlgAndValue = new OtherHashAlgAndValue(algorithmIdentifier, (ASN1OctetString)new DEROctetString(policy.getDigestValue()));
                if (Utils.isStringNotEmpty((String)policy.getSpuri())) {
                    SigPolicyQualifierInfo policyQualifierInfo = new SigPolicyQualifierInfo(PKCSObjectIdentifiers.id_spq_ets_uri, (ASN1Encodable)new DERIA5String(policy.getSpuri()));
                    SigPolicyQualifierInfo[] qualifierInfos = new SigPolicyQualifierInfo[]{policyQualifierInfo};
                    SigPolicyQualifiers qualifiers = new SigPolicyQualifiers(qualifierInfos);
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue, qualifiers));
                } else {
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue));
                }
            }
            DERSet attrValues = new DERSet((ASN1Encodable)sigPolicy);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSigningCertificateAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (parameters.getSigningCertificate() == null && parameters.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signed attributes later");
            return;
        }
        CMSUtils.addSigningCertificateAttribute(signedAttributes, parameters.getDigestAlgorithm(), parameters.getSigningCertificate());
    }
}

