/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureBuilder;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLTA;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CAdESSignaturePolicyStoreBuilder;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.CounterSignatureService;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESService
extends AbstractSignatureService<CAdESSignatureParameters, CAdESTimestampParameters>
implements CounterSignatureService<CAdESCounterSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESService.class);

    public CAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ CAdESService created");
    }

    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, CAdESSignatureParameters parameters) {
        if (this.tspSource == null) {
            throw new DSSException("A TSPSource is required !");
        }
        DigestAlgorithm digestAlgorithm = parameters.getContentTimestampParameters().getDigestAlgorithm();
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, Utils.fromBase64((String)toSignDocument.getDigest(digestAlgorithm)));
        try {
            return new TimestampToken(timeStampResponse.getBytes(), TimestampType.CONTENT_TIMESTAMP);
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot create a content TimestampToken", e);
        }
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, CAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        SignaturePackaging packaging = parameters.getSignaturePackaging();
        this.assertSignaturePackaging(packaging);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        DigestCalculatorProvider dcp = CMSUtils.getDigestCalculatorProvider(toSignDocument, parameters.getReferenceDigestAlgorithm());
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = cmsSignedDataBuilder.getSignerInfoGeneratorBuilder(dcp, parameters, false);
        CMSSignedData originalCmsSignedData = this.getCmsSignedData(toSignDocument, parameters);
        CMSSignedDataGenerator cmsSignedDataGenerator = cmsSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, originalCmsSignedData);
        DSSDocument toSignData = this.getToSignData(toSignDocument, parameters, originalCmsSignedData);
        CMSTypedData content = CMSUtils.getContentToBeSigned(toSignData);
        boolean encapsulate = !SignaturePackaging.DETACHED.equals((Object)packaging);
        CMSUtils.generateCMSSignedData(cmsSignedDataGenerator, content, encapsulate);
        byte[] bytes = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(bytes);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, CAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        SignaturePackaging packaging = parameters.getSignaturePackaging();
        this.assertSignaturePackaging(packaging);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        DigestCalculatorProvider dcp = CMSUtils.getDigestCalculatorProvider(toSignDocument, parameters.getReferenceDigestAlgorithm());
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = cmsSignedDataBuilder.getSignerInfoGeneratorBuilder(dcp, parameters, true);
        CMSSignedData originalCmsSignedData = this.getCmsSignedData(toSignDocument, parameters);
        if (originalCmsSignedData == null && SignaturePackaging.DETACHED.equals((Object)packaging) && Utils.isCollectionEmpty((Collection)parameters.getDetachedContents())) {
            parameters.setDetachedContents(Arrays.asList(toSignDocument));
        }
        CMSSignedDataGenerator cmsSignedDataGenerator = cmsSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, originalCmsSignedData);
        DSSDocument toSignData = this.getToSignData(toSignDocument, parameters, originalCmsSignedData);
        CMSTypedData content = CMSUtils.getContentToBeSigned(toSignData);
        boolean encapsulate = !SignaturePackaging.DETACHED.equals((Object)packaging);
        CMSSignedData cmsSignedData = CMSUtils.generateCMSSignedData(cmsSignedDataGenerator, content, encapsulate);
        CMSSignedDocument signature = new CMSSignedDocument(cmsSignedData);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)signatureLevel)) {
            SignerInformation newSignerInformation = this.getNewSignerInformation(originalCmsSignedData, cmsSignedData);
            CAdESSignatureExtension extension = this.getExtensionProfile(parameters);
            CMSSignedData extendedCMSSignature = extension.extendCMSSignatures(cmsSignedData, newSignerInformation, parameters);
            signature = new CMSSignedDocument(extendedCMSSignature);
        }
        signature.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        parameters.reinitDeterministicId();
        return signature;
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, CAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        CAdESSignatureExtension extension = this.getExtensionProfile(parameters);
        CMSSignedDocument dssDocument = extension.extendSignatures(toExtendDocument, parameters);
        dssDocument.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
        return dssDocument;
    }

    private DSSDocument getToSignData(DSSDocument toSignDocument, CAdESSignatureParameters parameters, CMSSignedData originalCmsSignedData) {
        List detachedContents = parameters.getDetachedContents();
        if (Utils.isCollectionNotEmpty((Collection)detachedContents)) {
            return (DSSDocument)detachedContents.get(0);
        }
        if (originalCmsSignedData == null) {
            return toSignDocument;
        }
        return this.getSignedContent(originalCmsSignedData);
    }

    private DSSDocument getSignedContent(CMSSignedData cmsSignedData) {
        CMSTypedData signedContent = cmsSignedData.getSignedContent();
        if (signedContent == null) {
            throw new DSSException("Unknown SignedContent");
        }
        byte[] documentBytes = (byte[])signedContent.getContent();
        return new InMemoryDocument(documentBytes);
    }

    private SignerInformation getNewSignerInformation(CMSSignedData originalSignedData, CMSSignedData cmsSignedData) {
        Collection signers = cmsSignedData.getSignerInfos().getSigners();
        if (originalSignedData != null) {
            for (SignerInformation signerInformation : signers) {
                if (this.containsSignerInfo(originalSignedData, signerInformation)) continue;
                return signerInformation;
            }
        }
        return (SignerInformation)signers.iterator().next();
    }

    private boolean containsSignerInfo(CMSSignedData signedData, SignerInformation signerInformationToFind) {
        for (SignerInformation signerInformation : signedData.getSignerInfos()) {
            if (signerInformationToFind.toASN1Structure() != signerInformation.toASN1Structure()) continue;
            return true;
        }
        return false;
    }

    private CAdESSignatureExtension getExtensionProfile(CAdESSignatureParameters parameters) {
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        switch (signatureLevel) {
            case CAdES_BASELINE_T: {
                return new CAdESLevelBaselineT(this.tspSource);
            }
            case CAdES_BASELINE_LT: {
                return new CAdESLevelBaselineLT(this.tspSource, this.certificateVerifier);
            }
            case CAdES_BASELINE_LTA: {
                return new CAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier);
            }
        }
        throw new DSSException("Unsupported signature format : " + signatureLevel);
    }

    private CMSSignedData getCmsSignedData(DSSDocument dssDocument, CAdESSignatureParameters parameters) {
        CMSSignedData cmsSignedData = null;
        if (!(dssDocument instanceof DigestDocument) && DSSASN1Utils.isASN1SequenceTag((byte)DSSUtils.readFirstByte((DSSDocument)dssDocument))) {
            try {
                cmsSignedData = new CMSSignedData(DSSUtils.toByteArray((DSSDocument)dssDocument));
                if (SignaturePackaging.ENVELOPING == parameters.getSignaturePackaging() && cmsSignedData.getSignedContent().getContent() == null) {
                    cmsSignedData = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cmsSignedData;
    }

    private void assertSignaturePackaging(SignaturePackaging packaging) {
        if (packaging != SignaturePackaging.ENVELOPING && packaging != SignaturePackaging.DETACHED) {
            throw new DSSException("Unsupported signature packaging: " + packaging);
        }
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(document, "The document cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)document);
        CAdESSignaturePolicyStoreBuilder builder = new CAdESSignaturePolicyStoreBuilder();
        CMSSignedData newCmsSignedData = builder.addSignaturePolicyStore(cmsSignedData, signaturePolicyStore);
        CMSSignedDocument documentWithPolicyStore = new CMSSignedDocument(newCmsSignedData);
        documentWithPolicyStore.setName(this.getFinalFileName(document, SigningOperation.EXTEND, null));
        return documentWithPolicyStore;
    }

    public ToBeSigned getDataToBeCounterSigned(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        Objects.requireNonNull(parameters, "parameters cannot be null!");
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The signature to be counter-signed must be specified");
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        this.assertCounterSignaturePossible(parameters);
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        SignerInformation signerInfoToCounterSign = counterSignatureBuilder.getSignerInformationToBeCounterSigned(signatureDocument, parameters);
        return this.getDataToBeCounterSigned(signatureDocument, signerInfoToCounterSign, parameters);
    }

    public ToBeSigned getDataToBeCounterSigned(DSSDocument signatureDocument, SignerInformation signerInfoToCounterSign, CAdESSignatureParameters parameters) {
        InMemoryDocument toSignDocument = new InMemoryDocument(signerInfoToCounterSign.getSignature());
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        DigestCalculatorProvider dcp = CMSUtils.getDigestCalculatorProvider((DSSDocument)toSignDocument, parameters.getReferenceDigestAlgorithm());
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = cmsSignedDataBuilder.getSignerInfoGeneratorBuilder(dcp, parameters, false);
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)signatureDocument);
        CMSSignedDataGenerator cmsSignedDataGenerator = cmsSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, cmsSignedData);
        CMSUtils.generateCounterSigners(cmsSignedDataGenerator, signerInfoToCounterSign);
        return new ToBeSigned(customContentSigner.getOutputStream().toByteArray());
    }

    public DSSDocument counterSignSignature(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        Objects.requireNonNull(parameters, "parameters cannot be null!");
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The signature to be counter-signed must be specified");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        this.assertCounterSignaturePossible(parameters);
        CMSSignedData originalCMSSignedData = DSSUtils.toCMSSignedData((DSSDocument)signatureDocument);
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        CMSSignedDocument counterSigned = counterSignatureBuilder.addCounterSignature(originalCMSSignedData, parameters, signatureValue);
        counterSigned.setName(this.getFinalFileName(signatureDocument, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel()));
        counterSigned.setMimeType(signatureDocument.getMimeType());
        return counterSigned;
    }

    private void assertCounterSignaturePossible(CAdESCounterSignatureParameters parameters) {
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new DSSException(String.format("A counter signature with a level '%s' is not supported! Please, use CAdES-BASELINE-B", parameters.getSignatureLevel()));
        }
    }
}

