/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.x509.SignatureIntegrityValidator;
import java.security.PublicKey;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;

public class CAdESSignatureIntegrityValidator
extends SignatureIntegrityValidator {
    private final SignerInformation signerInformation;
    private final JcaSimpleSignerInfoVerifierBuilder verifier;

    public CAdESSignatureIntegrityValidator(SignerInformation signerInformation) {
        this.signerInformation = signerInformation;
        this.verifier = this.instantiateVerifier();
    }

    private JcaSimpleSignerInfoVerifierBuilder instantiateVerifier() {
        JcaSimpleSignerInfoVerifierBuilder verifier = new JcaSimpleSignerInfoVerifierBuilder();
        verifier.setProvider(DSSSecurityProvider.getSecurityProviderName());
        return verifier;
    }

    protected boolean verify(PublicKey publicKey) throws DSSException {
        try {
            SignerInformationVerifier signerInformationVerifier = this.verifier.build(publicKey);
            return this.signerInformation.verify(signerInformationVerifier);
        }
        catch (CMSSignerDigestMismatchException e) {
            throw new DSSException(String.format("Unable to validate CMS Signature : %s", e.getMessage()));
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to validate CMS Signature : %s", e.getMessage()), (Throwable)e);
        }
    }
}

