/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.TimeStampTokenProductionComparator;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSigProperties;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;

public class CAdESUnsignedAttributes
extends CAdESSigProperties {
    CAdESUnsignedAttributes(AttributeTable attributeTable) {
        super(attributeTable);
    }

    public static CAdESUnsignedAttributes build(SignerInformation signerInformation) {
        return new CAdESUnsignedAttributes(signerInformation.getUnsignedAttributes());
    }

    @Override
    public List<CAdESAttribute> getAttributes() {
        List<CAdESAttribute> attributes = super.getAttributes();
        return this.sortTimestamps(attributes, DSSASN1Utils.getTimestampOids());
    }

    private List<CAdESAttribute> sortTimestamps(List<CAdESAttribute> attributes, List<ASN1ObjectIdentifier> timestampOids) {
        TimeStampTokenProductionComparator comparator = new TimeStampTokenProductionComparator();
        for (int ii = 0; ii < attributes.size() - 1; ++ii) {
            for (int jj = 0; jj < attributes.size() - ii - 1; ++jj) {
                CAdESAttribute cadesAttribute = attributes.get(jj);
                if (!timestampOids.contains(cadesAttribute.getASN1Oid())) continue;
                CAdESAttribute nextCAdESAttribute = attributes.get(jj + 1);
                if (!timestampOids.contains(nextCAdESAttribute.getASN1Oid())) {
                    Collections.swap(attributes, jj, jj + 1);
                    continue;
                }
                TimeStampToken current = cadesAttribute.toTimeStampToken();
                TimeStampToken next = nextCAdESAttribute.toTimeStampToken();
                if (current == null || next == null || comparator.compare(current, next) <= 0) continue;
                Collections.swap(attributes, jj, jj + 1);
            }
        }
        return attributes;
    }
}

