/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSDocumentValidator
extends SignedDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CMSDocumentValidator.class);
    protected CMSSignedData cmsSignedData;

    CMSDocumentValidator() {
        this((SignatureScopeFinder<CAdESSignature>)new CAdESSignatureScopeFinder());
    }

    CMSDocumentValidator(SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
        super(signatureScopeFinder);
    }

    public CMSDocumentValidator(CMSSignedData cmsSignedData) {
        this();
        this.cmsSignedData = cmsSignedData;
    }

    public CMSDocumentValidator(DSSDocument document) {
        this();
        this.document = document;
        this.cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)document);
    }

    protected CMSDocumentValidator(DSSDocument document, SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
        this(signatureScopeFinder);
        this.document = document;
        this.cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)document);
    }

    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag((byte)firstByte)) {
            return !DSSUtils.isTimestampToken((DSSDocument)dssDocument);
        }
        return false;
    }

    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cmsSignedData != null) {
            for (SignerInformation signerInformation : this.cmsSignedData.getSignerInfos().getSigners()) {
                CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation);
                if (this.document != null) {
                    cadesSignature.setSignatureFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setContainerContents(this.containerContents);
                cadesSignature.setManifestFile(this.manifestFile);
                cadesSignature.setSigningCertificateSource(this.signingCertificateSource);
                cadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
                signatures.add((AdvancedSignature)cadesSignature);
            }
        }
        return signatures;
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        Objects.requireNonNull(signatureId, "Signature Id cannot be null");
        ArrayList<DSSDocument> results = new ArrayList<DSSDocument>();
        for (SignerInformation signerInformation : this.cmsSignedData.getSignerInfos().getSigners()) {
            CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation);
            cadesSignature.setSignatureFilename(this.document.getName());
            cadesSignature.setDetachedContents(this.detachedContents);
            cadesSignature.setSigningCertificateSource(this.signingCertificateSource);
            if (!Utils.areStringsEqual((String)cadesSignature.getId(), (String)signatureId) && !this.isCounterSignature(cadesSignature, signatureId)) continue;
            results.add(cadesSignature.getOriginalDocument());
        }
        return results;
    }

    private boolean isCounterSignature(CAdESSignature masterSignature, String signatureId) {
        for (SignerInformation counterSignerInformation : masterSignature.getCounterSignatureStore()) {
            CAdESSignature countersignature = new CAdESSignature(this.cmsSignedData, counterSignerInformation);
            countersignature.setMasterSignature((AdvancedSignature)masterSignature);
            if (!Utils.areStringsEqual((String)countersignature.getId(), (String)signatureId) && !this.isCounterSignature(countersignature, signatureId)) continue;
            return true;
        }
        return false;
    }

    protected CAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new CAdESDiagnosticDataBuilder();
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
        try {
            return Arrays.asList(cadesSignature.getOriginalDocument());
        }
        catch (DSSException e) {
            LOG.error("Cannot retrieve a list of original documents");
            return Collections.emptyList();
        }
    }
}

