/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ValidationData;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;

public class CAdESCounterSignatureBuilder {
    private final CertificateVerifier certificateVerifier;
    private ManifestFile manifestFile;

    public CAdESCounterSignatureBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    public CMSSignedDocument addCounterSignature(CMSSignedData originalCMSSignedData, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        List<SignerInformation> updatedSignerInfo = this.getUpdatedSignerInformations(originalCMSSignedData, originalCMSSignedData.getSignerInfos(), parameters, signatureValue, null);
        CMSSignedData updatedCMSSignedData = CMSSignedData.replaceSigners((CMSSignedData)originalCMSSignedData, (SignerInformationStore)new SignerInformationStore(updatedSignerInfo));
        updatedCMSSignedData = this.addNewCertificates(updatedCMSSignedData, parameters);
        return new CMSSignedDocument(updatedCMSSignedData);
    }

    private List<SignerInformation> getUpdatedSignerInformations(CMSSignedData originalCMSSignedData, SignerInformationStore signerInformationStore, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue, CAdESSignature masterSignature) {
        LinkedList<SignerInformation> result = new LinkedList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationStore) {
            CAdESSignature cades = new CAdESSignature(originalCMSSignedData, signerInformation);
            cades.setMasterSignature((AdvancedSignature)masterSignature);
            cades.setDetachedContents(parameters.getDetachedContents());
            cades.setManifestFile(this.manifestFile);
            if (Utils.areStringsEqual((String)cades.getId(), (String)parameters.getSignatureIdToCounterSign())) {
                if (masterSignature != null) {
                    throw new UnsupportedOperationException("Cannot recursively add a counter-signature");
                }
                this.assertCounterSignaturePossible(signerInformation);
                SignerInformationStore counterSignatureSignerInfoStore = this.generateCounterSignature(signerInformation, parameters, signatureValue);
                result.add(SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)counterSignatureSignerInfoStore));
                continue;
            }
            if (signerInformation.getCounterSignatures().size() > 0) {
                List<SignerInformation> updatedSignerInformations = this.getUpdatedSignerInformations(originalCMSSignedData, signerInformation.getCounterSignatures(), parameters, signatureValue, cades);
                result.add(SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)new SignerInformationStore(updatedSignerInformations)));
                continue;
            }
            result.add(signerInformation);
        }
        return result;
    }

    private CMSSignedData addNewCertificates(CMSSignedData updatedCMSSignedData, CAdESCounterSignatureParameters parameters) {
        ValidationData validationDataToAdd = new ValidationData();
        BaselineBCertificateSelector certificateSelectors = new BaselineBCertificateSelector(this.certificateVerifier, (AbstractSignatureParameters)parameters);
        List newCertificates = certificateSelectors.getCertificates();
        for (CertificateToken certificateToken : newCertificates) {
            validationDataToAdd.addToken((Token)certificateToken);
        }
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        return cmsSignedDataBuilder.extendCMSSignedData(updatedCMSSignedData, validationDataToAdd);
    }

    private SignerInformationStore generateCounterSignature(SignerInformation signerInformation, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        CMSSignedDataBuilder builder = new CMSSignedDataBuilder(this.certificateVerifier);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        DigestCalculatorProvider dcp = CMSUtils.getDigestCalculatorProvider((DSSDocument)new InMemoryDocument(signerInformation.getSignature()), parameters.getReferenceDigestAlgorithm());
        SignerInfoGeneratorBuilder signerInformationGeneratorBuilder = builder.getSignerInfoGeneratorBuilder(dcp, parameters, false);
        CMSSignedDataGenerator cmsSignedDataGenerator = builder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInformationGeneratorBuilder, null);
        return CMSUtils.generateCounterSigners(cmsSignedDataGenerator, signerInformation);
    }

    public SignerInformation getSignerInformationToBeCounterSigned(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        CAdESSignature cadesSignature = this.getSignatureById(signatureDocument, parameters);
        if (cadesSignature == null) {
            throw new IllegalArgumentException(String.format("CAdESSignature not found with the given dss id '%s'", parameters.getSignatureIdToCounterSign()));
        }
        return cadesSignature.getSignerInformation();
    }

    private CAdESSignature getSignatureById(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The Id of a signature to be counter signed shall be defined! Please use SerializableCounterSignatureParameters.setSignatureIdToCounterSign(signatureId) method.");
        CMSDocumentValidator validator = new CMSDocumentValidator(signatureDocument);
        validator.setDetachedContents(parameters.getDetachedContents());
        validator.setManifestFile(this.manifestFile);
        List<AdvancedSignature> signatures = validator.getSignatures();
        return this.findSignatureRecursive(signatures, parameters.getSignatureIdToCounterSign());
    }

    private CAdESSignature findSignatureRecursive(List<AdvancedSignature> signatures, String signatureId) {
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (AdvancedSignature advancedSignature : signatures) {
                if (signatureId.equals(advancedSignature.getId())) {
                    CAdESSignature cades = (CAdESSignature)advancedSignature;
                    this.assertCounterSignaturePossible(cades.getSignerInformation());
                    return cades;
                }
                CAdESSignature counterSignatureById = this.findSignatureRecursive(advancedSignature.getCounterSignatures(), signatureId);
                if (counterSignatureById == null) continue;
                throw new UnsupportedOperationException("Nested counter signatures are not supported with CAdES!");
            }
        }
        return null;
    }

    private void assertCounterSignaturePossible(SignerInformation signerInformation) {
        if (CMSUtils.containsATSTv2(signerInformation)) {
            throw new IllegalInputException("Cannot add a counter signature to a CAdES containing an archiveTimestampV2");
        }
    }
}

