/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineLTA
extends CAdESLevelBaselineLT {
    public CAdESLevelBaselineLTA(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        super(tspSource, certificateVerifier);
    }

    @Override
    protected CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters, List<String> signatureIdsToExtend) {
        cmsSignedData = super.extendCMSSignatures(cmsSignedData, parameters, signatureIdsToExtend);
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        CMSDocumentValidator documentValidator = this.getDocumentValidator(cmsSignedData, parameters);
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            SignerInformation signerInformation;
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            SignerInformation newSignerInformation = signerInformation = cadesSignature.getSignerInformation();
            if (signatureIdsToExtend.contains(cadesSignature.getId())) {
                AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
                unsignedAttributes = this.addArchiveTimestampV3Attribute(cadesSignature, signerInformation, parameters, unsignedAttributes);
                newSignerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
            }
            newSignerInformationList.add(newSignerInformation);
        }
        return this.replaceSigners(cmsSignedData, newSignerInformationList);
    }

    private AttributeTable addArchiveTimestampV3Attribute(CAdESSignature cadesSignature, SignerInformation signerInformation, CAdESSignatureParameters parameters, AttributeTable unsignedAttributes) {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(cadesSignature);
        DigestAlgorithm timestampDigestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
        byte[] originalDocumentDigest = Utils.fromBase64((String)cadesSignature.getOriginalDocument().getDigest(timestampDigestAlgorithm));
        ASN1ObjectIdentifier atsHashIndexTableIdentifier = this.getAtsHashIndexTableIdentifier(parameters);
        Attribute atsHashIndexAttribute = timestampExtractor.getAtsHashIndex(signerInformation, timestampDigestAlgorithm, atsHashIndexTableIdentifier);
        byte[] encodedToTimestamp = timestampExtractor.getArchiveTimestampV3MessageImprint(signerInformation, atsHashIndexAttribute, originalDocumentDigest);
        ASN1Object timeStampAttributeValue = this.getTimeStampAttributeValue(encodedToTimestamp, timestampDigestAlgorithm, atsHashIndexAttribute);
        return unsignedAttributes.add(OID.id_aa_ets_archiveTimestampV3, (ASN1Encodable)timeStampAttributeValue);
    }

    private ASN1ObjectIdentifier getAtsHashIndexTableIdentifier(CAdESSignatureParameters signatureParameters) {
        if (!signatureParameters.isEn319122()) {
            return OID.id_aa_ATSHashIndex;
        }
        return OID.id_aa_ATSHashIndexV3;
    }
}

