/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineT
extends CAdESSignatureExtension {
    public CAdESLevelBaselineT(TSPSource tspSource) {
        super(tspSource);
    }

    protected CAdESLevelBaselineT(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        super(tspSource, certificateVerifier);
    }

    @Override
    protected CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters, List<String> signatureIdsToExtend) {
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        CMSDocumentValidator documentValidator = this.getDocumentValidator(cmsSignedData, parameters);
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            SignerInformation signerInformation;
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            SignerInformation newSignerInformation = signerInformation = cadesSignature.getSignerInformation();
            if (signatureIdsToExtend.contains(cadesSignature.getId())) {
                newSignerInformation = this.extendSignerInformation(cmsSignedData, signerInformation, parameters);
            }
            newSignerInformationList.add(newSignerInformation);
        }
        return this.replaceSigners(cmsSignedData, newSignerInformationList);
    }

    private SignerInformation extendSignerInformation(CMSSignedData signedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        CAdESSignature cadesSignature = this.newCAdESSignature(signedData, signerInformation, parameters.getDetachedContents());
        if (!cadesSignature.hasTProfile() || SignatureLevel.CAdES_BASELINE_T.equals((Object)parameters.getSignatureLevel())) {
            this.assertExtendSignatureLevelTPossible(cadesSignature);
            AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
            unsignedAttributes = this.addSignatureTimestampAttribute(signerInformation, unsignedAttributes, parameters);
            return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
        }
        return signerInformation;
    }

    private void assertExtendSignatureLevelTPossible(CAdESSignature cadesSignature) {
        String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
        if (cadesSignature.hasLTAProfile()) {
            throw new IllegalInputException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "CAdES LTA"));
        }
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(cadesSignature.getSignerInformation());
        if (unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) != null) {
            throw new IllegalInputException(String.format("Cannot extend signature. The signedData is already extended with [%s].", PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.getId()));
        }
    }

    private AttributeTable addSignatureTimestampAttribute(SignerInformation signerInformation, AttributeTable unsignedAttributes, CAdESSignatureParameters parameters) {
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        ASN1Object signatureTimeStamp = this.getTimeStampAttributeValue(signerInformation.getSignature(), timestampDigestAlgorithm, new Attribute[0]);
        return unsignedAttributes.add(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Encodable)signatureTimeStamp);
    }
}

