/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.BaselineRequirementsChecker;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESBaselineRequirementsChecker
extends BaselineRequirementsChecker<CAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESBaselineRequirementsChecker.class);

    public CAdESBaselineRequirementsChecker(CAdESSignature signature, CertificateVerifier offlineCertificateVerifier) {
        super((DefaultAdvancedSignature)signature, offlineCertificateVerifier);
    }

    protected SignatureForm getBaselineSignatureForm() {
        return SignatureForm.CAdES;
    }

    protected boolean cmsBaselineBRequirements() {
        CertificateRef signingCertificateRef;
        Digest certDigest;
        boolean cades;
        CMSSignedData cmsSignedData = ((CAdESSignature)this.signature).getCmsSignedData();
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        if (Utils.isCollectionEmpty((Collection)cmsSignedData.getCertificates().getMatches(null))) {
            LOG.warn("SignedData.certificates shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!((CAdESSignature)this.signature).isCounterSignature() && CMSUtils.getSignedAttribute(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_contentType) == null) {
            LOG.warn("content-type attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (CMSUtils.getSignedAttribute(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_messageDigest) == null) {
            LOG.warn("message-digest attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!(CMSUtils.getSignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificate) != null ^ CMSUtils.getSignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificateV2) != null)) {
            LOG.warn("signing-certificate(-v2) attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        boolean signingTimePresent = CMSUtils.getSignedAttribute(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_signingTime) != null;
        if (signingTimePresent != (cades = SignatureForm.CAdES.equals((Object)signatureForm))) {
            if (cades) {
                LOG.warn("signing-time attribute shall be present for {}-BASELINE-B signature (cardinality == 1})!", (Object)signatureForm);
            } else {
                LOG.warn("signing-time attribute shall not be present for {}-BASELINE-B signature (cardinality == 0})!", (Object)signatureForm);
            }
            return false;
        }
        if (!this.containsSigningCertificate(((CAdESSignature)this.signature).getCertificateSource().getSignedDataCertificates())) {
            LOG.warn("Signing certificate shall be present in SignedData.certificates for {}-BASELINE-B signature (requirement (a))!", (Object)signatureForm);
            return false;
        }
        List certificateRefs = ((CAdESSignature)this.signature).getCertificateSource().getSigningCertificateRefs();
        if (Utils.isCollectionNotEmpty((Collection)certificateRefs) && (certDigest = (signingCertificateRef = (CertificateRef)certificateRefs.iterator().next()).getCertDigest()) != null) {
            DigestAlgorithm digestAlgorithm = certDigest.getAlgorithm();
            if (DigestAlgorithm.SHA1.equals((Object)digestAlgorithm)) {
                if (CMSUtils.getSignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificate) == null) {
                    LOG.warn("signing-certificate attribute shall be used for SHA1 hash algorithm for {}-BASELINE-B signature (requirement (h) 319 122-1)!", (Object)signatureForm);
                    return false;
                }
            } else if (CMSUtils.getSignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificateV2) == null) {
                LOG.warn("signing-certificate-v2 attribute shall be used for SHA1 hash algorithm for {}-BASELINE-B signature (requirement (i) 319 122-1)!", (Object)signatureForm);
                return false;
            }
        }
        return true;
    }

    public boolean hasBaselineBProfile() {
        if (!this.cmsBaselineBRequirements()) {
            return false;
        }
        SignaturePolicyStore signaturePolicyStore = ((CAdESSignature)this.signature).getSignaturePolicyStore();
        if (signaturePolicyStore != null && !this.isSignaturePolicyIdentifierHashPresent()) {
            LOG.warn("signature-policy-store shall not be present for CAdES-BASELINE-B signature with not defined signature-policy-identifier/sigPolicyHash (requirement (k))!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineTProfile() {
        return this.minimalTRequirement();
    }

    public boolean hasBaselineLTProfile() {
        if (!this.minimalLTRequirement()) {
            return false;
        }
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certValues) != null) {
            LOG.warn("certificate-values attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs) != null) {
            LOG.warn("complete-certificate-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationValues) != null) {
            LOG.warn("revocation-values attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs) != null) {
            LOG.warn("complete-revocation-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp) != null) {
            LOG.warn("time-stamped-certs-crls-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTAProfile() {
        ArrayList timestampTokens = new ArrayList();
        timestampTokens.addAll(((CAdESSignature)this.signature).getArchiveTimestamps());
        timestampTokens.addAll(((CAdESSignature)this.signature).getDetachedTimestamps());
        if (Utils.isCollectionEmpty(timestampTokens)) {
            LOG.trace("ArchiveTimeStamp shall be present for CAdES-BASELINE-LTA signature (cardinality >= 1)!");
            return false;
        }
        boolean validArcTstFound = false;
        for (TimestampToken timestampToken : timestampTokens) {
            if (!ArchiveTimestampType.CAdES_V3.equals((Object)timestampToken.getArchiveTimestampType()) && !ArchiveTimestampType.CAdES_DETACHED.equals((Object)timestampToken.getArchiveTimestampType())) continue;
            validArcTstFound = true;
            break;
        }
        if (!validArcTstFound) {
            LOG.warn("archive-time-stamp-v3 attribute shall be present for CAdES-BASELINE-LTA signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedCProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs) == null) {
            LOG.debug("complete-certificate-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean allSelfSigned = certificateSources.isAllSelfSigned();
        if (!allSelfSigned && CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs) == null) {
            LOG.debug("complete-revocation-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedXProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp) == null && CMSUtils.getUnsignedAttribute(signerInformation, PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) == null) {
            LOG.debug("complete-revocation-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedXLProfile() {
        return this.minimalLTRequirement();
    }

    public boolean hasExtendedAProfile() {
        ArrayList timestampTokens = new ArrayList();
        timestampTokens.addAll(((CAdESSignature)this.signature).getArchiveTimestamps());
        timestampTokens.addAll(((CAdESSignature)this.signature).getDetachedTimestamps());
        if (Utils.isCollectionEmpty(timestampTokens)) {
            LOG.trace("ArchiveTimeStamp shall be present for CAdES-A signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }
}

