/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.spi.DSSASN1Utils;
import java.io.Serializable;
import java.util.Comparator;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.tsp.TimeStampToken;

public class TimeStampTokenProductionComparator
implements Comparator<TimeStampToken>,
Serializable {
    private static final long serialVersionUID = 4125423970411266861L;

    @Override
    public int compare(TimeStampToken timeStampTokenOne, TimeStampToken timeStampTokenTwo) {
        int result = this.compareByGenerationTime(timeStampTokenOne, timeStampTokenTwo);
        if (result == 0) {
            result = this.compareByHashTableSize(timeStampTokenOne, timeStampTokenTwo);
        }
        return result;
    }

    public boolean after(TimeStampToken timeStampTokenOne, TimeStampToken timeStampTokenTwo) {
        return this.compare(timeStampTokenOne, timeStampTokenTwo) > 0;
    }

    private int compareByGenerationTime(TimeStampToken tst1, TimeStampToken tst2) {
        return DSSASN1Utils.getTimeStampTokenGenerationTime((TimeStampToken)tst1).compareTo(DSSASN1Utils.getTimeStampTokenGenerationTime((TimeStampToken)tst2));
    }

    private int compareByHashTableSize(TimeStampToken tst1, TimeStampToken tst2) {
        ASN1Sequence atsHashIndexOne = DSSASN1Utils.getAtsHashIndex((AttributeTable)tst1.getUnsignedAttributes());
        ASN1Sequence atsHashIndexTwo = DSSASN1Utils.getAtsHashIndex((AttributeTable)tst2.getUnsignedAttributes());
        if (atsHashIndexOne != null && atsHashIndexTwo != null) {
            int hashTableSizeTwo;
            int hashTableSizeOne = this.getHashTableSize(atsHashIndexOne);
            if (hashTableSizeOne < (hashTableSizeTwo = this.getHashTableSize(atsHashIndexTwo))) {
                return -1;
            }
            if (hashTableSizeOne > hashTableSizeTwo) {
                return 1;
            }
        } else {
            if (atsHashIndexOne != null) {
                return 1;
            }
            if (atsHashIndexTwo != null) {
                return -1;
            }
        }
        return 0;
    }

    private int getHashTableSize(ASN1Sequence derSequence) {
        int recordsNumber = 0;
        for (int ii = 0; ii < derSequence.size(); ++ii) {
            ASN1Sequence derEncodedSequence = (ASN1Sequence)derSequence.getObjectAt(ii);
            recordsNumber += derEncodedSequence.size();
        }
        return recordsNumber;
    }
}

